INCLUDE(TestCXXAcceptsFlag)

MACRO(BF_SET_DEFAULT_GCC_FLAGS)
	IF(CMAKE_COMPILER_IS_GNUCC AND CMAKE_COMPILER_IS_GNUCXX
	   AND CMAKE_C_FLAGS STREQUAL " " AND CMAKE_CXX_FLAGS STREQUAL " ")
		SET(dead_strip_ldflags_ "")
		SET(gc_sections_cflags_ "")
		SET(gc_sections_ldflags_ "")
		IF(APPLE)
			CHECK_CXX_ACCEPTS_FLAG("-Wl,-dead_strip" dead_strip_supported_)
			IF(dead_strip_supported_)
				SET(dead_strip_ldflags_ "-Wl,-dead_strip")
			ENDIF(dead_strip_supported_)
		ELSE(APPLE)
			CHECK_CXX_ACCEPTS_FLAG(
				"-ffunction-sections -fdata-sections -Wl,--gc-sections"
				gc_sections_supported_
			)
			IF(gc_sections_supported_)
				SET(gc_sections_cflags_ "-ffunction-sections -fdata-sections")
				SET(gc_sections_ldflags_ "-Wl,--gc-sections")
			ENDIF(gc_sections_supported_)
		ENDIF(APPLE)
		
		
		CHECK_CXX_ACCEPTS_FLAG("-fvisibility=hidden" visibility_supported_)
		IF(visibility_supported_)
			SET(visibility_cflags_ "-fvisibility=hidden")
		ELSE(visibility_supported_)
			SET(visibility_cflags_ "")
		ENDIF(visibility_supported_)
		
		CHECK_CXX_ACCEPTS_FLAG("-mdynamic-no-pic" mdynamic_no_pic_supported_)
		IF(mdynamic_no_pic_supported_)
			SET(mdynamic_no_pic_ "-mdynamic-no-pic")
		ELSE(mdynamic_no_pic_supported_)
			SET(mdynamic_no_pic_ "")
		ENDIF(mdynamic_no_pic_supported_)
		
		CHECK_CXX_ACCEPTS_FLAG("-mmacosx-version-min=10.3" mmacosx_version_min_supported_)
		IF(mmacosx_version_min_supported_)
			SET(mmacosx_version_min_ "-mmacosx-version-min=10.3")
		ELSE(mmacosx_version_min_supported_)
			SET(mmacosx_version_min_ "")
		ENDIF(mmacosx_version_min_supported_)
		
		CHECK_CXX_ACCEPTS_FLAG("-fno-threadsafe-statics" fno_threadsafe_statics_supported_)
		IF(fno_threadsafe_statics_supported_)
			SET(fno_threadsafe_statics_ "-fno-threadsafe-statics")
		ELSE(fno_threadsafe_statics_supported_)
			SET(fno_threadsafe_statics_ "")
		ENDIF(fno_threadsafe_statics_supported_)
		
		# Flags common for all build configurations
		SET(
			CMAKE_C_FLAGS
			"-fno-strict-aliasing ${mdynamic_no_pic_} ${mmacosx_version_min_}"
			CACHE STRING "Common C flags for all build configurations." FORCE
		)
		SET(
			CMAKE_CXX_FLAGS
			"-Wall -Wno-unused ${mdynamic_no_pic_} ${mmacosx_version_min_} ${fno_threadsafe_statics_}"
			CACHE STRING "Common C++ flags for all build configurations." FORCE
		)
		SET(
			CMAKE_EXE_LINKER_FLAGS "" CACHE STRING
			"Common link flags for all build configurations." FORCE
		)
		
		# Release
		SET(
			CMAKE_C_FLAGS_RELEASE
			"-DNDEBUG -O2 ${visibility_cflags_} ${gc_sections_cflags_}"
			CACHE STRING "C flags for Release builds." FORCE
		)
		SET(
			CMAKE_CXX_FLAGS_RELEASE
			"-DNDEBUG -O2 ${visibility_cflags_} ${gc_sections_cflags_}"
			CACHE STRING "C++ flags for Release builds." FORCE
		)
		SET(
			CMAKE_EXE_LINKER_FLAGS_RELEASE
			"${gc_sections_ldflags_} ${dead_strip_ldflags_}"
			CACHE STRING "Link flags for Release builds." FORCE
		)
		
		# MinSizeRel
		SET(
			CMAKE_C_FLAGS_MINSIZEREL
			"-DNDEBUG -Os ${visibility_cflags_} ${gc_sections_cflags_}"
			CACHE STRING "C flags for MinSizeRel builds." FORCE
		)
		SET(
			CMAKE_CXX_FLAGS_MINSIZEREL
			"-DNDEBUG -Os ${visibility_cflags_} ${gc_sections_cflags_}"
			CACHE STRING "C++ flags for MinSizeRel builds." FORCE
		)
		SET(
			CMAKE_EXE_LINKER_FLAGS_MINSIZEREL
			"${gc_sections_ldflags_} ${dead_strip_ldflags_}"
			CACHE STRING "Link flags for MinSizeRel builds." FORCE
		)
		
		# RelWithDebInfo
		SET(
			CMAKE_C_FLAGS_RELWITHDEBINFO
			"-DNDEBUG -g -O2 ${visibility_cflags_}"
			CACHE STRING "C flags for RelWithDebInfo builds." FORCE
		)
		SET(
			CMAKE_CXX_FLAGS_RELWITHDEBINFO
			"-DNDEBUG -g -O2 ${visibility_cflags_}"
			CACHE STRING "C++ flags for RelWithDebInfo builds." FORCE
		)
		SET(
			CMAKE_EXE_LINKER_FLAGS_RELWITHDEBINFO ""
			CACHE STRING "Link flags for RelWithDebInfo builds." FORCE
		)
		
		# Debug
		SET(
			CMAKE_C_FLAGS_DEBUG "-DDEBUG -g" CACHE STRING
			"C flags for Debug builds." FORCE
		)
		SET(
			CMAKE_CXX_FLAGS_DEBUG "-DDEBUG -g" CACHE STRING
			"C++ flags for Debug builds." FORCE
		)
		SET(
			CMAKE_EXE_LINKER_FLAGS_DEBUG ""
			CACHE STRING "Link flags for Debug builds." FORCE
		)
	ENDIF(CMAKE_COMPILER_IS_GNUCC AND CMAKE_COMPILER_IS_GNUCXX
	   AND CMAKE_C_FLAGS STREQUAL " " AND CMAKE_CXX_FLAGS STREQUAL " ")
ENDMACRO(BF_SET_DEFAULT_GCC_FLAGS)
