/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2003  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPRESPONSEPARSER_H_
#define HTTPRESPONSEPARSER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "types.h"
#include "HttpParserBase.h"
#include "HttpStateResponseStart.h"
#include "HttpStateStatusLine.h"
#include "HttpStateResponseHeaders.h"
#include "RequestPtr.h"
#include <string>
#include <memory>

class HttpStatusLine;
class HttpResponseMetadata;

class HttpResponseParser : public HttpParserBase
{
public:
	HttpResponseParser();
	
	virtual ~HttpResponseParser();
	
	void switchToResponseStart(ConstRequestPtr const& req);
	
	HttpState* activateStateResponseStart(ConstRequestPtr const& req);
	
	HttpState* activateStateStatusLine(ConstRequestPtr const& req);
	
	HttpState* activateStateHeaders(
		ConstRequestPtr const&, HttpStatusLine const& status_line);
	
	bool isInitialState() const { return getState() == &m_stateResponseStart; }	
	
	virtual void eventGotProvisionalResponse(
		std::auto_ptr<HttpResponseMetadata> metadata) = 0;
		
	virtual void eventGotMetadata(
		std::auto_ptr<HttpResponseMetadata> metadata, bool is_persistent) = 0;
private:
	HttpStateResponseStart   m_stateResponseStart;
	HttpStateStatusLine      m_stateStatusLine;
	HttpStateResponseHeaders m_stateResponseHeaders;
};


inline HttpState*
HttpResponseParser::activateStateResponseStart(ConstRequestPtr const& req)
{
	m_stateResponseStart.activate(req);
	return &m_stateResponseStart;
}

inline HttpState*
HttpResponseParser::activateStateStatusLine(ConstRequestPtr const& req)
{
	m_stateStatusLine.activate(req);
	return &m_stateStatusLine;
}

inline HttpState*
HttpResponseParser::activateStateHeaders(
	ConstRequestPtr const& req, HttpStatusLine const& status_line)
{
	m_stateResponseHeaders.activate(req, status_line);
	return &m_stateResponseHeaders;
}

#endif
