/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SERVERCONNECTIONPOOL_H_
#define SERVERCONNECTIONPOOL_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <memory>

class ConnectionRoute;
class ServerConnection;
class Reactor;

class ServerConnectionPool
{
private:
	ServerConnectionPool() {}
	
	virtual ~ServerConnectionPool() {}
public:
	static ServerConnectionPool* instance();
	
	virtual void storeConnection(std::auto_ptr<ServerConnection> conn) = 0;
	
	virtual std::auto_ptr<ServerConnection> retrieveConnection(
		ConnectionRoute const& route) = 0;
	
	// Reactor is used for cleanup purposes. It's optional.
	virtual void connectToReactor(Reactor& reactor) = 0;
	
	virtual void disconnectFromReactor() = 0;
private:
	enum { CAPACITY = 60 };
	enum { TIMEOUT = 12 }; // seconds
	enum { CLEANUP_TIMEOUT = 5 }; // seconds
	
	struct Entry;
	class Impl;
	class ConnRC;
	friend class ServerConnectionPool::Impl;
};

#endif
