/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef TE_H_
#define TE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "InsensitiveLess.h"
#include "BString.h"
#include <map>

class HttpHeader;

class TE
{
public:
	TE(HttpHeader const& header);
	
	~TE();
	
	bool isAccepted(BString const& item) const { return getQuality(item) > 0; }
	
	template<typename Iterator>
	Iterator bestAccepted(Iterator begin, Iterator end) const;
private:	
	typedef std::map<BString, float, InsensitiveLess> Map;
	
	float getQuality(BString const& item) const;
	
	Map m_items;
};

template<typename Iterator>
Iterator
TE::bestAccepted(Iterator begin, Iterator end) const
{
	Iterator best_option = end;
	float best_quality = 0;
	for (; begin != end; ++begin) {
		float quality = getQuality(*begin);
		if (begin->second > best_quality) {
			best_option = begin;
			best_quality = begin->second;
		}
	}
	return best_option;
}

#endif
