/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef WEBBUGADSUSPECT_H_
#define WEBBUGADSUSPECT_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AdSuspect.h"
#include "WebbugHeuristicScore.h"
#include "URI.h"
#include <memory>
#include <iosfwd>

class WebbugAdSuspect : public AdSuspect
{
public:
	WebbugAdSuspect(URI const& location,
		bool location_absolute,
		WebbugHeuristicScore const& score);
	
	virtual ~WebbugAdSuspect();
	
	virtual int getWidth() const;
	
	virtual int getHeight() const;
	
	virtual URI const& getLocation() const;
	
	virtual bool isLocationAbsolute() const;
	
	virtual HeuristicScore const& getScore() const;
	
	virtual BString getSubstitutionURL() const;
	
	virtual void writeSubstitution(std::ostream& strm) const;
	
	static BString getSubstitutionURL(URI const& orig_url);
private:
	URI m_location;
	bool m_isLocationAbsolute;
	WebbugHeuristicScore m_score;
};


inline
WebbugAdSuspect::WebbugAdSuspect(
	URI const& location, bool location_absolute,
	WebbugHeuristicScore const& score)
:	m_location(location),
	m_isLocationAbsolute(location_absolute),
	m_score(score)
{
}

inline BString
WebbugAdSuspect::getSubstitutionURL(URI const& orig_url)
{
	return AdSuspect::getSubstitutionURL("bf-si-", orig_url, 1, 1);
}

#endif
