/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "WorkerThreadPoolEx.h"

WorkerThreadPoolEx::WorkerThreadPoolEx()
:	m_numAcceptors(0),
	m_isActive(false),
	m_isAcceptingConnections(false)
{
}

WorkerThreadPoolEx::~WorkerThreadPoolEx()
{
}

void
WorkerThreadPoolEx::activate()
{
	m_rep.activate(); // may throw
	m_isActive = true;
	updateStatus();
}

void
WorkerThreadPoolEx::deactivate()
{
	m_rep.deactivate();
	m_isActive = false;
	updateStatus();
}

void
WorkerThreadPoolEx::addAcceptor(ConnAcceptor::AcceptorPtr const& acceptor)
{
	m_rep.addAcceptor(acceptor); // may throw
	++m_numAcceptors;
	updateStatus();
}

void
WorkerThreadPoolEx::removeAcceptor(ConnAcceptor::AcceptorPtr const& acceptor)
{
	m_rep.removeAcceptor(acceptor);
	--m_numAcceptors;
	updateStatus();
}

void
WorkerThreadPoolEx::removeAllAcceptors()
{
	m_rep.removeAllAcceptors();
	m_numAcceptors = 0;
	updateStatus();
}

void
WorkerThreadPoolEx::updateStatus()
{
	bool const is_accepting = (m_isActive && m_numAcceptors != 0);
	if (is_accepting != m_isAcceptingConnections) {
		m_isAcceptingConnections = is_accepting;
		m_acceptingConnectionsSignal.emit(is_accepting);
	}
}
