/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CONFERROR_H_
#define CONFERROR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

class ConfError
{
public:
	enum Type { T_ERROR, T_WARNING };
	
	ConfError(Type type, std::string const& msg, int line=0, int col=0)
	: m_type(type), m_msg(msg), m_line(line), m_col(col) {}
	
	ConfError(std::string const& msg, int line=0, int col=0)
	: m_type(T_ERROR), m_msg(msg), m_line(line), m_col(col) {}
	
	Type getType() const { return m_type; }
	
	std::string const& getMessage() const { return m_msg; }
	
	int getLine() const { return m_line; }
	
	int getCol() const { return m_col; }
private:
	Type m_type;
	std::string m_msg;
	int m_line;
	int m_col;
};

#endif
