/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CONFIGFILESTRUCTURE_H_
#define CONFIGFILESTRUCTURE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ConfIO.h"
#include <string>
#include <iosfwd>
#include <list>

class Config;
class ConfErrorHandler;

class ConfigFileStructure
{
	// Member-wise copying is OK.
public:
	void clear();
	
	void load(std::string const& text,
		Config& target, ConfErrorHandler& eh);
	
	void updateWith(Config const& config);
	
	void swap(ConfigFileStructure& other);
	
	void toStream(std::ostream& strm) const;
private:
	class Reader;
	class Updater;
	
	std::list<ConfIO::Element> m_elements;
};


inline void swap(ConfigFileStructure& o1, ConfigFileStructure& o2)
{
	o1.swap(o2);
}

inline std::ostream& operator<<(std::ostream& strm,
	ConfigFileStructure const& structure)
{
	structure.toStream(strm);
	return strm;
}

#endif
