/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ADVANCEDCONFIGWINDOW_H_
#define ADVANCEDCONFIGWINDOW_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractLogView.h"
#include <gtkmm/window.h>

namespace Gtk {
	class Notebook;
	class Button;
	class TextView;
	class Adjustment;
	class Statusbar;
}

namespace GtkGUI
{

class AdvancedConfigWindow : public Gtk::Window, private AbstractLogView
{
public:
	AdvancedConfigWindow();
	
	virtual ~AdvancedConfigWindow();
	
	static void showWindow();
protected: /* to be used by friend classes */
	class Button;
	
	Button* getReloadButton() { return m_pReloadButton; }
	
	Button* getSaveButton() { return m_pSaveButton; }
private:
	class Page;
	class ConfigPage;
	class ConfigDefaultPage;
	class UrlsPage;
	class UrlsLocalPage;
	friend class AdvancedConfigWindow::Page;
	
	virtual void on_hide();
	
	virtual bool on_delete_event(GdkEventAny*);
	
	bool prepareForWindowDestruction();
	
	bool onFocusChange(GdkEventFocus*);
	
	Page* getPage(int idx);
	
	Page const* getPage(int idx) const;
	
	Page* getCurrentPage();
	
	bool haveModifiedPages() const;
	
	void updateLineColInfo(Page* page);
	
	void onTabChanged();
	
	void onCaretMove();
	
	void onTextModified();
	
	void onReload();
	
	void onSave();
	
	void onClearLog();
	
	void onAppDestroy();
	
	static AdvancedConfigWindow* m_spInstance;
	bool m_isConstructionFinished;
	Gtk::Notebook* m_pNotebook;
	Button* m_pReloadButton;
	Button* m_pSaveButton;
	Gtk::TextView* m_pLogView;
	Gtk::Statusbar* m_pLineStatusbar;
	Gtk::Statusbar* m_pColStatusbar;
	long m_caretLine;
	long m_caretCol;
};

} // namespace GtkGUI

#endif
