/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "TwoPhaseLogRecord.h"
#include "Log.h"

namespace GtkGUI
{

TwoPhaseLogRecord::TwoPhaseLogRecord(
	Log* log, StyledText const& msg_part1, StyledText const& msg_part2)
:	m_pLog(log),
	m_msgPart2(msg_part2),
	m_isCancelled(false)
{
	log->appendRecord(msg_part1);
	m_numRecords = log->getNumRecords();
}

void
TwoPhaseLogRecord::setSecondPhaseMessage(StyledText const& msg)
{
	m_msgPart2 = msg;
}

TwoPhaseLogRecord::~TwoPhaseLogRecord()
{
	if (!m_isCancelled && m_pLog->getNumRecords() == m_numRecords) {
		m_pLog->appendToLastRecord(m_msgPart2);
	}
}

} // namespace GtkGUI
