/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2008  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "WakeupPipe.h"
#include <stdexcept>
#include <unistd.h>
#include <fcntl.h>

namespace GtkGUI
{

WakeupPipe::WakeupPipe()
:	m_readFD(-1),
	m_writeFD(-1)
{
	construct(Glib::MainContext::get_default());
}

WakeupPipe::WakeupPipe(Glib::RefPtr<Glib::MainContext> const& context)
:	m_readFD(-1),
	m_writeFD(-1)
{
	construct(context);
}

WakeupPipe::~WakeupPipe()
{
	// This will cause unregistering the IO handler.
	notify_callbacks();
	
	close(m_readFD);
	close(m_writeFD);
}

void
WakeupPipe::wakeup()
{
	char data = 0;
	write(m_writeFD, &data, 1);
}

void
WakeupPipe::construct(Glib::RefPtr<Glib::MainContext> const& context)
{
	int fds[2];
	if (pipe(fds) == -1) {
		throw std::runtime_error("Unable to construct a pipe");
	}
	m_readFD = fds[0];
	m_writeFD = fds[1];
	
	fcntl(m_readFD, F_SETFL, O_NONBLOCK);
	fcntl(m_writeFD, F_SETFL, O_NONBLOCK);
	
	context->signal_io().connect(
		sigc::mem_fun(*this, &WakeupPipe::onDataInPipe),
		m_readFD, Glib::IO_IN
	);
}

bool
WakeupPipe::onDataInPipe(Glib::IOCondition)
{
	char buf[512];
	ssize_t received;
	do {
		received = read(m_readFD, buf, sizeof(buf));
	} while (received == sizeof(buf));
	
	m_wakeupSignal.emit();
	return true;
}

} // namespace GtkGUI
