/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef MVCLISTVIEW_H_
#define MVCLISTVIEW_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "WeakPtr.h"
#include "IntrusiveList.h"
#include <wx/listctrl.h>

class ACE_NULL_SYNCH;
class MvcListModel;

class MvcListView : public wxListCtrl, public IntrusiveListNode
{
public:
	typedef WeakPtr<ACE_NULL_SYNCH, MvcListModel, MvcListModel*> ModelPtr;
	
	MvcListView(wxWindow* parent, wxWindowID id,
		const wxPoint& pos = wxDefaultPosition,
		const wxSize& size = wxDefaultSize,
		long style = wxLC_ICON)
	: wxListCtrl(parent, id, pos, size, style) {}

	ModelPtr const& getModel() const { return m_ptrModel; }
	
	void setModel(ModelPtr const& model);
	
	virtual void onRowCountChanging();

	virtual void onRowCountChanged();
private:
	virtual wxString OnGetItemText(long row, long col) const;
	
	virtual int OnGetItemImage(long row) const;
	
	virtual wxListItemAttr* OnGetItemAttr(long row) const;
	
	ModelPtr m_ptrModel;
};

#endif
