/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "../src/libraries.h"
#include <sqlite3.h>
#include "../src/sqlite_reader.h"
#include <glib.h>


int main (int argc, char *argv[])
{
  vector <ustring> name;
  vector <ustring> sequence;
  vector <ustring> osis;
  vector <ustring> paratext;
  vector <ustring> bibleworks;
  
  {
    sqlite3 *db;
    int rc;
    char *error = NULL;
    try
    {
      rc = sqlite3_open("books.sql3", &db);
      if (rc) {
        throw runtime_error (sqlite3_errmsg(db));
      }
      SqliteReader sqlitereader (0);
      char * sql;
      sql = g_strdup_printf ("select name, sequence, osis, paratext, bibleworks from books;");
      rc = sqlite3_exec(db, sql, sqlitereader.callback, &sqlitereader, &error);
      g_free (sql);
      if (rc != SQLITE_OK) {
        throw runtime_error (error);
      }
      name.assign (sqlitereader.ustring0.begin(), sqlitereader.ustring0.end());
      sequence.assign (sqlitereader.ustring1.begin(), sqlitereader.ustring1.end());
      osis.assign (sqlitereader.ustring2.begin(), sqlitereader.ustring2.end());
      paratext.assign (sqlitereader.ustring3.begin(), sqlitereader.ustring3.end());
      bibleworks.assign (sqlitereader.ustring4.begin(), sqlitereader.ustring4.end());
    }
    catch (exception & ex)
    {
      cerr << ex.what () << endl;
    }
    sqlite3_close (db);
  }

 
  {
    sqlite3 *db;
    int rc;
    char *error = NULL;
    try
    {
      rc = sqlite3_open("allbooks.sql1", &db);
      if (rc) {
        throw runtime_error (sqlite3_errmsg(db));
      }
      char * sql;
      sql = g_strdup_printf ("CREATE TABLE books (name text, namecf text, sequence integer, osis text, osiscf text, paratext text, paratextcf text, bibleworks text, bibleworkscf text, id integer);");
      rc = sqlite3_exec(db, sql, NULL, NULL, &error);
      if (rc != SQLITE_OK) {
        throw runtime_error (error);
      }
      for (unsigned int i = 0; i < name.size(); i++) {
        sql = g_strdup_printf ("insert into books values ('%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', %d);", 
          name[i].c_str(), name[i].casefold().c_str(), sequence[i].c_str(),
          osis[i].c_str(), osis[i].casefold().c_str(), paratext[i].c_str(), paratext[i].casefold().c_str(), bibleworks[i].c_str(), bibleworks[i].casefold().c_str(), i + 1);
        rc = sqlite3_exec(db, sql, NULL, NULL, &error);
        if (rc != SQLITE_OK) {
          throw runtime_error (error);
        }
      }
      g_free (sql);
    }
    catch (exception & ex)
    {
      cerr << ex.what () << endl;
    }
    sqlite3_close (db);
    
  }
    

  {
    sqlite3 *db;
    int rc;
    char *error = NULL;
    try
    {
      rc = sqlite3_open("localbooks.sql1", &db);
      if (rc) {
        throw runtime_error (sqlite3_errmsg(db));
      }
      char * sql;
      sql = g_strdup_printf ("CREATE TABLE books (name text, namecf text, sequence integer, id integer);");
      rc = sqlite3_exec(db, sql, NULL, NULL, &error);
      if (rc != SQLITE_OK) {
        throw runtime_error (error);
      }
      for (unsigned int i = 0; i < name.size(); i++) {
        sql = g_strdup_printf ("insert into books values ('%s', '%s', '%s', %d);", 
          name[i].c_str(), name[i].casefold().c_str(), sequence[i].c_str(), i + 1);
        rc = sqlite3_exec(db, sql, NULL, NULL, &error);
        if (rc != SQLITE_OK) {
          throw runtime_error (error);
        }
      }
      g_free (sql);
    }
    catch (exception & ex)
    {
      cerr << ex.what () << endl;
    }
    sqlite3_close (db);
    
  }

  return 0;
}
