/* Anti-Web HTTPD */
/* Hardcore Software */
/*
This software is Copyright (C) 2001-2004 By Hardcore Software and
others. The software is distributed under the terms of the GNU General
Public License. See the file 'COPYING' for more details.
*/


#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <pwd.h>
#include <sys/types.h>
#include <stdlib.h>
#include <unistd.h>

#include "aw3.h"



// CONF GLOBALS:

int usevirtualhosts;
char *webroot;
int allowdirectorylisting;
int allowcgi;
int permcheck;
int maxusers;
int usertimeout;
int initialslots;
char *quote;

int numusers;



void defaultconfvals() {

  usevirtualhosts = 0;
  allowdirectorylisting = 0;
  allowcgi = 0;
  permcheck = 0;
  maxusers = 500;
  usertimeout = 5;
  initialslots = 10;
  quote = "Fear and loathing on the WWW";

  // Not really conf stuff:
  numusers = 0;

  return;

}


void procconf(char *filename) {

  FILE *fp;
  char buf[MAXREQUESTLENGTH];
  char *segs[10];
  int tp, err=0, warn=0;

  usevirtualhosts = 1;

  fp = fopen(filename, "r");

  if (fp == NULL) {
    fprintf(stderr, "ERROR: Unable to open conf file '%s'\n", filename);
    exit(0);
  }


  while (fgets(buf, sizeof(buf), fp) != NULL) {
    stripcrlf(buf);

    confsplit(buf, segs, 10);

    if (segs[0] == NULL) continue;

    if (segs[1] == NULL) {
      fprintf(stderr, "ERR: Unknown command in '%s': '%s'\n", filename, segs[0]);
      err++;
      continue;
    }


    if (strcasecmp(segs[0], "listen") == 0) {
      if (isdigit(*segs[1])) {
        if ((tp=openlistener(atoi(segs[1]))) == -1) {
          fprintf(stderr, "ERR: Couldn't bind to port %d (IPv4)\n", atoi(segs[1]));
          err++;
          continue;
        }

        addtoservers(tp);
        continue;
      }
    }

    if (strcasecmp(segs[0], "listen6") == 0) {
      #ifdef HAVE_IPV6
        if (isdigit(*segs[1])) {
          if ((tp=openlistener6(atoi(segs[1]))) == -1) {
            fprintf(stderr, "ERR: Couldn't bind to port %d (IPv6)\n", atoi(segs[1]));
            err++;
            continue;
          }

          addtoservers(tp);
          continue;
        }
      #else
        fprintf(stderr, "ERR: AW was compiled without IPv6 support!\n");
        err++;
        continue;
      #endif
    }

    if (strcasecmp(segs[0], "maxusers") == 0) {
      maxusers = tp = atoi(segs[1]);
      if (tp < 1) {
        fprintf(stderr, "ERR: Bad value for maxusers\n");
        err++;
      }
      if (tp < 10 || tp > 10000) {
        fprintf(stderr, "WARN: Value for maxusers (%d) is not withing the recommended range\n", tp);
        warn++;
      }
      continue;
    }

    if (strcasecmp(segs[0], "usertimeout") == 0) {
      usertimeout = tp = atoi(segs[1]);
      if (tp < 1) {
        fprintf(stderr, "ERR: Bad value for usertimeout\n");
        err++;
      }
      if (tp > 100) {
        fprintf(stderr, "WARN: Value for usertimeout (%d) is not withing the recommended range\n", tp);
        warn++;
      }
      continue;
    }

    if (strcasecmp(segs[0], "initialslots") == 0) {
      initialslots = tp = atoi(segs[1]);
      if (tp < 1) {
        fprintf(stderr, "ERR: Bad value for initialslots\n");
        err++;
      }
      continue;
    }

    if (strcasecmp(segs[0], "directorylisting") == 0) {
      if (strcasecmp(segs[1], "on") == 0) allowdirectorylisting = 1;
      else if (strcasecmp(segs[1], "off") == 0) allowdirectorylisting = 0;
      else {
        fprintf(stderr, "ERR: Need on or off for directorylisting\n");
        err++;
      }
      continue;
    }

    if (strcasecmp(segs[0], "cgi") == 0) {
      if (strcasecmp(segs[1], "on") == 0) allowcgi = 1;
      else if (strcasecmp(segs[1], "off") == 0) allowcgi = 0;
      else {
        fprintf(stderr, "ERR: Need on or off for cgi\n");
        err++;
      }
      continue;
    }

    if (strcasecmp(segs[0], "cgiext") == 0) {
      if (*(segs[1]) != '.' && *(segs[1]+1) != '\0') {
        fprintf(stderr, "ERR: CGI extensions must start with a period and be at least 2 chars long\n");
        err++;
        continue;
      }
      addcgiext(segs[1]);
      continue;
    }

    if (strcasecmp(segs[0], "addindex") == 0) {
      if (*(segs[1]) == '.') {
        fprintf(stderr, "ERR: Index files can't start with a dot\n");
        err++;
        continue;
      }
      addindex(segs[1]);
      continue;
    }

    if (strcasecmp(segs[0], "permcheck") == 0) {
      if (strcasecmp(segs[1], "on") == 0) permcheck = 1;
      else if (strcasecmp(segs[1], "off") == 0) permcheck = 0;
      else {
        fprintf(stderr, "ERR: Need on or off for permcheck\n");
        err++;
      }
      continue;
    }

    if (strcasecmp(segs[0], "dropto") == 0) {
      struct passwd *bl;

      if ((bl = getpwnam(segs[1])) == NULL) {
        fprintf(stderr, "ERR: Unable to find look up user '%s' to drop privileges\n", segs[1]);
        err++;
      } else {
        if (setgid(bl->pw_gid) != 0) {
          fprintf(stderr, "WARN: Unable to drop GID to %d\n", bl->pw_gid);
          warn++;
        }
        if (setuid(bl->pw_uid) != 0) {
          fprintf(stderr, "WARN: Unable to drop UID to %d\n", bl->pw_uid);
          warn++;
        }
      }
      continue;
    }

    if (strcasecmp(segs[0], "quote") == 0) {
      quote = strdup(segs[1]);
      continue;
    }


    if (segs[2] == NULL) {
      fprintf(stderr, "ERR: Unknown command in '%s': '%s'\n", filename, segs[0]);
      err++;
      continue;
    }


    // Otherwise:

    fprintf(stderr, "ERR: Unknown command in '%s': '%s'\n", filename, segs[0]);
    err++;
    continue;

  }


  if (initialslots > maxusers) {
    fprintf(stderr, "ERR: initialslots is greater than maxusers!\n");
    err++;
  }


  if (warn) {
    fprintf(stderr, "Alert! %d warnings!\n", warn);
  }

  if (err) {
    fprintf(stderr, "Unable to start: %d errors!\n", err);
    exit(1);
  }

  fclose(fp);

  return;

}
