/* Anti-Web HTTPD */
/* Hardcore Software */
/*
This software is Copyright (C) 2001-2004 By Hardcore Software and
others. The software is distributed under the terms of the GNU General
Public License. See the file 'COPYING' for more details.
*/


#include <unistd.h>

#include "aw3.h"

void procpermcheck(char *pathtocheck) {

  DIR *tpdir;
  struct dirent *dp;
  char thepath[MAXREQUESTLENGTH];

  tpdir=opendir(pathtocheck);

  if (tpdir==NULL) {
    printf("WARNING: UID (%d) is unable to read %s\n", getuid(), pathtocheck);
    return;
  }

  while ((dp=readdir(tpdir))) {

    if (strcmp(dp->d_name, "..")==0) continue;
    if (strcmp(dp->d_name, ".")==0) continue;

    snprintf(thepath, sizeof(thepath), "%s/%s", pathtocheck, dp->d_name);

    if (isdir(thepath)) {
      procpermcheck(thepath);
      continue;
    }

    if (access(thepath, R_OK) != 0)
      printf("WARNING: UID (%d) is unable to read %s\n", getuid(), thepath);
    if (access(thepath, W_OK) == 0)
      printf("SECURITY: UID (%d) is ABLE TO WRITE TO %s\n", getuid(), thepath);

  }

  closedir(tpdir);

  return;

}
