/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include <glib.h>
#include "dialogformatter.h"
#include "utilities.h"
#include "java.h"
#include "gtkwrappers.h"
#include "gwrappers.h"
#include "uname.h"
#include "unixwrappers.h"
#include "directories.h"
#include "gwrappers.h"
#include "shell.h"
#include "generalconfig.h"
#include "gui.h"


FormatterDialog::FormatterDialog (int dummy)
{
  // Save and initialize variables.
  GeneralConfiguration genconfig (0);
  java_binary_path = genconfig.java_binary();
  xep_package_path = g_get_home_dir ();
  xep_package_path.append ("/");
  license_path = g_get_home_dir ();
  license_path.append ("/");
  xep_home = genconfig.xep_home();
  
  // Build GUI.
  formatterdialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (formatterdialog), "Formatter Setup");
  gtk_window_set_position (GTK_WINDOW (formatterdialog), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_modal (GTK_WINDOW (formatterdialog), TRUE);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (formatterdialog), TRUE);

  dialog_vbox1 = GTK_DIALOG (formatterdialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 5);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

  table1 = gtk_table_new (8, 4, FALSE);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (vbox1), table1, TRUE, TRUE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 4);

  image_java = gtk_image_new_from_stock ("gtk-yes", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image_java);
  gtk_table_attach (GTK_TABLE (table1), image_java, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label_java_gui = gtk_label_new ("");
  gtk_widget_show (label_java_gui);
  gtk_table_attach (GTK_TABLE (table1), label_java_gui, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_java_gui), 0, 0.5);

  label24 = gtk_label_new ("Open the Java binary");
  gtk_widget_show (label24);
  gtk_table_attach (GTK_TABLE (table1), label24, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label24), 0, 0.5);

  button_java = gtk_button_new ();
  gtk_widget_show (button_java);
  gtk_table_attach (GTK_TABLE (table1), button_java, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  alignment3 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment3);
  gtk_container_add (GTK_CONTAINER (button_java), alignment3);

  hbox6 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox6);
  gtk_container_add (GTK_CONTAINER (alignment3), hbox6);

  image3 = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image3);
  gtk_box_pack_start (GTK_BOX (hbox6), image3, FALSE, FALSE, 0);

  label25 = gtk_label_new_with_mnemonic ("_Java");
  gtk_widget_show (label25);
  gtk_box_pack_start (GTK_BOX (hbox6), label25, FALSE, FALSE, 0);

  label_install = gtk_label_new ("");
  gtk_widget_show (label_install);
  gtk_table_attach (GTK_TABLE (table1), label_install, 0, 3, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_install), 0, 0.5);

  image_install = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image_install);
  gtk_table_attach (GTK_TABLE (table1), image_install, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label_install_gui = gtk_label_new ("");
  gtk_widget_show (label_install_gui);
  gtk_table_attach (GTK_TABLE (table1), label_install_gui, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_install_gui), 0, 0.5);

  label31 = gtk_label_new ("Install or upgrade XEP");
  gtk_widget_show (label31);
  gtk_table_attach (GTK_TABLE (table1), label31, 2, 3, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label31), 0, 0.5);

  button_install = gtk_button_new ();
  gtk_widget_show (button_install);
  gtk_table_attach (GTK_TABLE (table1), button_install, 3, 4, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  alignment6 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment6);
  gtk_container_add (GTK_CONTAINER (button_install), alignment6);

  hbox11 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox11);
  gtk_container_add (GTK_CONTAINER (alignment6), hbox11);

  image10 = gtk_image_new_from_stock ("gtk-execute", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image10);
  gtk_box_pack_start (GTK_BOX (hbox11), image10, FALSE, FALSE, 0);

  label32 = gtk_label_new_with_mnemonic ("_Install");
  gtk_widget_show (label32);
  gtk_box_pack_start (GTK_BOX (hbox11), label32, FALSE, FALSE, 0);

  label_license = gtk_label_new ("");
  gtk_widget_show (label_license);
  gtk_table_attach (GTK_TABLE (table1), label_license, 0, 3, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_license), 0, 0.5);

  image_license = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image_license);
  gtk_table_attach (GTK_TABLE (table1), image_license, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label_license_gui = gtk_label_new ("ok");
  gtk_widget_show (label_license_gui);
  gtk_table_attach (GTK_TABLE (table1), label_license_gui, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_license_gui), 0, 0.5);

  label29 = gtk_label_new ("Open the XEP license");
  gtk_widget_show (label29);
  gtk_table_attach (GTK_TABLE (table1), label29, 2, 3, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label29), 0, 0.5);

  button_license = gtk_button_new ();
  gtk_widget_show (button_license);
  gtk_table_attach (GTK_TABLE (table1), button_license, 3, 4, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  alignment5 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment5);
  gtk_container_add (GTK_CONTAINER (button_license), alignment5);

  hbox10 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox10);
  gtk_container_add (GTK_CONTAINER (alignment5), hbox10);

  image8 = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image8);
  gtk_box_pack_start (GTK_BOX (hbox10), image8, FALSE, FALSE, 0);

  label30 = gtk_label_new_with_mnemonic ("_License");
  gtk_widget_show (label30);
  gtk_box_pack_start (GTK_BOX (hbox10), label30, FALSE, FALSE, 0);

  label_package = gtk_label_new ("");
  gtk_widget_show (label_package);
  gtk_table_attach (GTK_TABLE (table1), label_package, 0, 3, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_package), 0, 0.5);

  image_xep = gtk_image_new_from_stock ("gtk-justify-fill", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image_xep);
  gtk_table_attach (GTK_TABLE (table1), image_xep, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label_xep_gui = gtk_label_new ("ok");
  gtk_widget_show (label_xep_gui);
  gtk_table_attach (GTK_TABLE (table1), label_xep_gui, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_xep_gui), 0, 0.5);

  label27 = gtk_label_new ("Open the XEP installation package");
  gtk_widget_show (label27);
  gtk_table_attach (GTK_TABLE (table1), label27, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label27), 0, 0.5);

  button_xep = gtk_button_new ();
  gtk_widget_show (button_xep);
  gtk_table_attach (GTK_TABLE (table1), button_xep, 3, 4, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  alignment4 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment4);
  gtk_container_add (GTK_CONTAINER (button_xep), alignment4);

  hbox8 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox8);
  gtk_container_add (GTK_CONTAINER (alignment4), hbox8);

  image6 = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image6);
  gtk_box_pack_start (GTK_BOX (hbox8), image6, FALSE, FALSE, 0);

  label28 = gtk_label_new_with_mnemonic ("_XEP");
  gtk_widget_show (label28);
  gtk_box_pack_start (GTK_BOX (hbox8), label28, FALSE, FALSE, 0);

  label_java = gtk_label_new ("");
  gtk_widget_show (label_java);
  gtk_table_attach (GTK_TABLE (table1), label_java, 0, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_java), 0, 0.5);

  dialog_action_area1 = GTK_DIALOG (formatterdialog)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  cancelbutton = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton);
  gtk_dialog_add_action_widget (GTK_DIALOG (formatterdialog), cancelbutton, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton, GTK_CAN_DEFAULT);

  okbutton = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton);
  gtk_dialog_add_action_widget (GTK_DIALOG (formatterdialog), okbutton, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) button_java, "clicked",
                    G_CALLBACK (on_button_java_clicked),
                    gpointer(this));
  g_signal_connect ((gpointer) button_xep, "clicked",
                    G_CALLBACK (on_button_xep_clicked),
                    gpointer(this));
  g_signal_connect ((gpointer) button_license, "clicked",
                    G_CALLBACK (on_button_license_clicked),
                    gpointer(this));
  g_signal_connect ((gpointer) button_install, "clicked",
                    G_CALLBACK (on_button_install_clicked),
                    gpointer(this));
  g_signal_connect ((gpointer) okbutton, "clicked",
                    G_CALLBACK (on_okbutton_clicked),
                    gpointer(this));
  
  gtk_widget_grab_default (okbutton);
  
  // Set gui.
  set_gui ();
}


FormatterDialog::~FormatterDialog ()
{
  gtk_widget_destroy (formatterdialog);
}


int FormatterDialog::run ()
{
  return gtk_dialog_run (GTK_DIALOG (formatterdialog));
}


void FormatterDialog::on_okbutton_clicked (GtkButton *button, gpointer user_data)
{
  ((FormatterDialog *) user_data)->on_okbutton ();
}


void FormatterDialog::on_okbutton ()
{
  GeneralConfiguration genconfig (0);
  // Store Java just to remember for next time.
  genconfig.java_binary_set (java_binary_path);
  // Store xep home for printing.
  genconfig.xep_home_set (xep_home);
}


void FormatterDialog::on_button_java_clicked (GtkButton *button, gpointer user_data)
{
  ((FormatterDialog *) user_data)->on_button_java ();
}


void FormatterDialog::on_button_java ()
{
  GtkWidget *dialog;
  dialog = gtk_file_chooser_dialog_new ("Select a Java binary", GTK_WINDOW (formatterdialog),
    GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
    GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
  gtk_file_chooser_set_filename (GTK_FILE_CHOOSER (dialog), java_binary_path.c_str());
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
    java_binary_path = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
  }
  gtk_widget_destroy (dialog);  
  set_gui ();  
}


void FormatterDialog::on_button_xep_clicked (GtkButton *button, gpointer user_data)
{
  ((FormatterDialog *) user_data)->on_button_xep ();
}


void FormatterDialog::on_button_xep ()
{
  GtkWidget *dialog;
  dialog = gtk_file_chooser_dialog_new ("Select the XEP package", GTK_WINDOW (formatterdialog),
    GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
    GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
  gtk_file_chooser_set_filename (GTK_FILE_CHOOSER (dialog), xep_package_path.c_str());
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
    xep_package_path = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
  }
  gtk_widget_destroy (dialog);  
  set_gui ();  
}


void FormatterDialog::on_button_license_clicked (GtkButton *button, gpointer user_data)
{
  ((FormatterDialog *) user_data)->on_button_license ();
}


void FormatterDialog::on_button_license ()
{
  GtkWidget *dialog;
  dialog = gtk_file_chooser_dialog_new ("Select the XEP license", GTK_WINDOW (formatterdialog),
    GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
    GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
  gtk_file_chooser_set_filename (GTK_FILE_CHOOSER (dialog), license_path.c_str());
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
    license_path = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
  }
  gtk_widget_destroy (dialog);  
  set_gui ();  
}


void FormatterDialog::on_button_install_clicked (GtkButton *button, gpointer user_data)
{
  ((FormatterDialog *) user_data)->on_button_install ();
}


void FormatterDialog::on_button_install ()
// Installs XEP.
{
  // Installation folder.
  ustring installationfolder;
  installationfolder = gw_build_filename (directories_get_temp(), "xep");
  // Remove any old installation, so xep install does not ask to overwrite existing directory.
  ustring command;
  command = "rm -rf" + shell_quote_space (installationfolder);
  system (command.c_str());

  // (Re)create working folder.
  // Also prevents unzip from asking to overwrite any existing files.
  ustring workingfolder;
  workingfolder = gw_build_filename (directories_get_temp (), "xepinstall");
  command = "rm -rf" + shell_quote_space (workingfolder);
  system (command.c_str());
  create_directory (workingfolder);
  
  // Copy zip file to working folder.
  command = "cp" + shell_quote_space (xep_package_path) + shell_quote_space (workingfolder);
  system (command.c_str());

  // Unzip the file.
  command = "cd" + shell_quote_space (workingfolder) + "; ";
  command.append ("unzip " + gw_path_get_basename (xep_package_path));
  system (command.c_str());

  // Create installation policy.
  vector<ustring> lines;
  lines.push_back ("yes");
  lines.push_back (filename_modify_if_cygwin (installationfolder));
  lines.push_back ("yes");
  lines.push_back (filename_modify_if_cygwin (license_path));
  lines.push_back ("yes");
  ustring installationpolicy;
  installationpolicy = gw_build_filename (workingfolder, "bibleditpolicy");
  write_lines (installationpolicy, lines);
  lines.clear();
  
  // Install.
  command = "cd " + shell_quote_space (workingfolder) + "; cat" + shell_quote_space (installationpolicy) + "|";
  command.append (shell_quote_space (java_binary_path) + "-jar setup*jar -c");
  system (command.c_str());

  // Set new installation path.
  xep_home = installationfolder;
  
  // Remove working folder.
  command = "rm -rf" + shell_quote_space (workingfolder);
  system (command.c_str());

  // Update gui.
  set_gui ();  
}


void FormatterDialog::set_gui ()
{
  // Try to get a correct Java binary. XEP needs the Sun one, not GNU gij.
  bool java_ok = false;
  ustring java_information;
  if (java_search (java_binary_path)) {
    if (!java_binary_path.empty())
      java_ok = java_is_sun (java_binary_path, java_information);
  }

  // Set in gui whether java was ok.
  gui_okay (image_java, label_java_gui, java_ok);
  java_information = trim (java_information);
  if (java_ok)
    java_information.insert (0, "Binary: " + java_binary_path + "\n");
  else
    java_information.insert (0, "Binary not found in " + java_binary_path + "\n");
  gtk_label_set_text (GTK_LABEL (label_java), java_information.c_str());
 
  // See whether the XEP package is found.
  bool xep_ok = find_installation_package ();
  
  // Set in gui whether the package is fine.
  gui_okay (image_xep, label_xep_gui, xep_ok);
  ustring xep_information (xep_package_path);
  if (xep_ok) 
    xep_information.insert (0, "Package is ");
  else
    xep_information.insert (0, "Package not found at ");
  gtk_label_set_text (GTK_LABEL (label_package), xep_information.c_str());
    
  // See whether the license is found.
  bool license_ok = find_license ();
  
  // Set in gui whether the license is fine.
  gui_okay (image_license, label_license_gui, license_ok);
  ustring license_information (license_path);
  if (license_ok) 
    license_information.insert (0, "License is ");
  else
    license_information.insert (0, "License not found at ");
  gtk_label_set_text (GTK_LABEL (label_license), license_information.c_str());
    
  // Set Install button sensitive is all's ready.
  gtk_widget_set_sensitive (button_install, java_ok && xep_ok && license_ok);
  
  // See whether XEP has been installed.
  ustring xep;
  xep = gw_build_filename (xep_home, "xep");
  if (uname_get () == untCygwin)
    xep.append (".bat");
  bool xep_installed = g_file_test (xep.c_str(), G_FILE_TEST_IS_EXECUTABLE);
  
  // Info about installation.
  gtk_widget_set_sensitive (okbutton, xep_installed);
  xep = xep_home;
  if (xep_installed)
    xep.insert (0, "XEP installed in ");
  else
    xep.insert (0, "XEP installation not found in ");
  gtk_label_set_text (GTK_LABEL (label_install), xep.c_str());
  gui_okay (image_install, label_install_gui, xep_installed);
}


bool FormatterDialog::find_installation_package ()
{
  // See if the current path contains the package.
  ustring s (xep_package_path);
  s = gw_path_get_basename (s);
  if (g_str_has_prefix (s.c_str(), "xep"))
    if (g_str_has_suffix (s.c_str(), ".zip"))
      return true;
  // Search for a package in the home directory.
  ReadFiles rf (g_get_home_dir (), "xep", ".zip");
  if (rf.files.size () > 0) {
    xep_package_path = gw_build_filename (g_get_home_dir (), rf.files[0]);
    return true;
  }
  // Nothing found.
  return false;
}


bool FormatterDialog::find_license ()
{
  // See if the current one is a license.
  ustring s = gw_path_get_basename (license_path);
  if (s == "license.xml")
    return true;
  // Search for the license in the home directory.
  s = gw_build_filename (g_get_home_dir (), "license.xml");
  if (g_file_test (s.c_str(), G_FILE_TEST_IS_REGULAR)) {
    license_path = s;
    return true;
  }
  // Sorry, nothing found.
  return false;
}
