/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include <glib.h>
#include "dialogimporttext.h"
#include "usfmtools.h"
#include "bible.h"
#include "utilities.h"
#include "dialogwait.h"
#include "utilities.h"
#include "projectutils.h"
#include "usfmtools.h"
#include "dialogselectbooks.h"
#include "gwrappers.h"
#include "dialogunicode.h"
#include "shell.h"
#include "import.h"
#include "progresswindow.h"
#include "books.h"
#include "generalconfig.h"
#include "gui.h"
#include "session.h"
#include "combobox.h"


#define USFM "USFM"
#define BIBLE_WORKS "BibleWorks"
#define MECHON_MAMRE "Mechon Mamre"


ImportTextDialog::ImportTextDialog (int dummy)
{
  importsfmdialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (importsfmdialog), "Import text");
  gtk_window_set_position (GTK_WINDOW (importsfmdialog), GTK_WIN_POS_CENTER_ON_PARENT);

  dialog_vbox1 = GTK_DIALOG (importsfmdialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 5);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

  table1 = gtk_table_new (11, 4, FALSE);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (vbox1), table1, TRUE, TRUE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 4);

  image_directory = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image_directory);
  gtk_table_attach (GTK_TABLE (table1), image_directory, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label_directory_gui = gtk_label_new ("");
  gtk_widget_show (label_directory_gui);
  gtk_table_attach (GTK_TABLE (table1), label_directory_gui, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_directory_gui), 0, 0.5);

  label24 = gtk_label_new ("Select directory");
  gtk_widget_show (label24);
  gtk_table_attach (GTK_TABLE (table1), label24, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label24), 0, 0.5);

  button_directory = gtk_button_new ();
  gtk_widget_show (button_directory);
  gtk_table_attach (GTK_TABLE (table1), button_directory, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  alignment3 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment3);
  gtk_container_add (GTK_CONTAINER (button_directory), alignment3);

  hbox6 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox6);
  gtk_container_add (GTK_CONTAINER (alignment3), hbox6);

  image3 = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image3);
  gtk_box_pack_start (GTK_BOX (hbox6), image3, FALSE, FALSE, 0);

  label25 = gtk_label_new_with_mnemonic ("_Directory");
  gtk_widget_show (label25);
  gtk_box_pack_start (GTK_BOX (hbox6), label25, FALSE, FALSE, 0);

  label_unicode = gtk_label_new ("");
  gtk_widget_show (label_unicode);
  gtk_table_attach (GTK_TABLE (table1), label_unicode, 0, 3, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_unicode), 0, 0.5);

  image_unicode = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image_unicode);
  gtk_table_attach (GTK_TABLE (table1), image_unicode, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label_unicode_gui = gtk_label_new ("");
  gtk_widget_show (label_unicode_gui);
  gtk_table_attach (GTK_TABLE (table1), label_unicode_gui, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_unicode_gui), 0, 0.5);

  label29 = gtk_label_new ("Convert to Unicode");
  gtk_widget_show (label29);
  gtk_table_attach (GTK_TABLE (table1), label29, 2, 3, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label29), 0, 0.5);

  button_unicode = gtk_button_new ();
  gtk_widget_show (button_unicode);
  gtk_table_attach (GTK_TABLE (table1), button_unicode, 3, 4, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  alignment5 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment5);
  gtk_container_add (GTK_CONTAINER (button_unicode), alignment5);

  hbox10 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox10);
  gtk_container_add (GTK_CONTAINER (alignment5), hbox10);

  image8 = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image8);
  gtk_box_pack_start (GTK_BOX (hbox10), image8, FALSE, FALSE, 0);

  label30 = gtk_label_new_with_mnemonic ("_Unicode");
  gtk_widget_show (label30);
  gtk_box_pack_start (GTK_BOX (hbox10), label30, FALSE, FALSE, 0);

  label_books = gtk_label_new ("");
  gtk_widget_show (label_books);
  gtk_table_attach (GTK_TABLE (table1), label_books, 0, 3, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_books), 0, 0.5);

  image_books = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image_books);
  gtk_table_attach (GTK_TABLE (table1), image_books, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label_books_gui = gtk_label_new ("");
  gtk_widget_show (label_books_gui);
  gtk_table_attach (GTK_TABLE (table1), label_books_gui, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_books_gui), 0, 0.5);

  label27 = gtk_label_new ("Select books");
  gtk_widget_show (label27);
  gtk_table_attach (GTK_TABLE (table1), label27, 2, 3, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label27), 0, 0.5);

  button_books = gtk_button_new ();
  gtk_widget_show (button_books);
  gtk_table_attach (GTK_TABLE (table1), button_books, 3, 4, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  alignment4 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment4);
  gtk_container_add (GTK_CONTAINER (button_books), alignment4);

  hbox8 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox8);
  gtk_container_add (GTK_CONTAINER (alignment4), hbox8);

  image6 = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image6);
  gtk_box_pack_start (GTK_BOX (hbox8), image6, FALSE, FALSE, 0);

  label28 = gtk_label_new_with_mnemonic ("_Books");
  gtk_widget_show (label28);
  gtk_box_pack_start (GTK_BOX (hbox8), label28, FALSE, FALSE, 0);

  label_directory = gtk_label_new ("");
  gtk_widget_show (label_directory);
  gtk_table_attach (GTK_TABLE (table1), label_directory, 0, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_directory), 0, 0.5);

  label_import = gtk_label_new ("");
  gtk_widget_show (label_import);
  gtk_table_attach (GTK_TABLE (table1), label_import, 0, 3, 10, 11,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_import), 0, 0.5);

  image_method = gtk_image_new_from_stock ("gtk-yes", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image_method);
  gtk_table_attach (GTK_TABLE (table1), image_method, 0, 1, 8, 10,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  label_method_gui = gtk_label_new ("");
  gtk_widget_show (label_method_gui);
  gtk_table_attach (GTK_TABLE (table1), label_method_gui, 1, 2, 8, 10,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_method_gui), 0, 0.5);

  label33 = gtk_label_new ("How to import the files?");
  gtk_widget_show (label33);
  gtk_table_attach (GTK_TABLE (table1), label33, 2, 3, 8, 10,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label33), 0, 0.5);

  GSList *radiobutton_copy_group = NULL;

  radiobutton_copy = gtk_radio_button_new_with_mnemonic (NULL, "Co_py them");
  gtk_widget_show (radiobutton_copy);
  gtk_table_attach (GTK_TABLE (table1), radiobutton_copy, 3, 4, 8, 9,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobutton_copy), radiobutton_copy_group);
  radiobutton_copy_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobutton_copy));

  radiobutton_link = gtk_radio_button_new_with_mnemonic (NULL, "_Link to them");
  gtk_widget_show (radiobutton_link);
  gtk_table_attach (GTK_TABLE (table1), radiobutton_link, 3, 4, 9, 10,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobutton_link), radiobutton_copy_group);
  radiobutton_copy_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobutton_link));

  image_type = gtk_image_new_from_stock ("gtk-dialog-warning", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image_type);
  gtk_table_attach (GTK_TABLE (table1), image_type, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  label_type_gui = gtk_label_new ("");
  gtk_widget_show (label_type_gui);
  gtk_table_attach (GTK_TABLE (table1), label_type_gui, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_type_gui), 0, 0.5);

  label35 = gtk_label_new_with_mnemonic ("Which _type of file to import?");
  gtk_widget_show (label35);
  gtk_table_attach (GTK_TABLE (table1), label35, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label35), 0, 0.5);

  combobox_type = gtk_combo_box_new_text ();
  gtk_widget_show (combobox_type);
  gtk_table_attach (GTK_TABLE (table1), combobox_type, 3, 4, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  // Load values in the type combo.
  vector <ustring> types;
  types.push_back (USFM);
  types.push_back (BIBLE_WORKS);
  types.push_back (MECHON_MAMRE);
  combobox_set_strings (combobox_type, types);
  combobox_set_string (combobox_type, USFM);

  dialog_action_area1 = GTK_DIALOG (importsfmdialog)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  cancelbutton = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton);
  gtk_dialog_add_action_widget (GTK_DIALOG (importsfmdialog), cancelbutton, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton, GTK_CAN_DEFAULT);

  okbutton = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton);
  gtk_dialog_add_action_widget (GTK_DIALOG (importsfmdialog), okbutton, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) button_directory, "clicked",
                    G_CALLBACK (on_button_directory_clicked),
                    gpointer(this));
  g_signal_connect ((gpointer) combobox_type, "changed",
                    G_CALLBACK (on_combobox_type_changed),
                    gpointer(this));
  g_signal_connect ((gpointer) button_unicode, "clicked",
                    G_CALLBACK (on_button_unicode_clicked),
                    gpointer(this));
  g_signal_connect ((gpointer) button_books, "clicked",
                    G_CALLBACK (on_button_books_clicked),
                    gpointer(this));
  g_signal_connect ((gpointer) okbutton, "clicked",
                    G_CALLBACK (on_okbutton_clicked),
                    gpointer(this));

  gtk_label_set_mnemonic_widget (GTK_LABEL (label35), combobox_type);
  
  gtk_widget_grab_default (okbutton);

  // Set gui.
  select_all_books = true;
  set_gui ();
}


ImportTextDialog::~ImportTextDialog ()
{
  gtk_widget_destroy (importsfmdialog);
}


int ImportTextDialog::run ()
{
  return gtk_dialog_run (GTK_DIALOG (importsfmdialog));
}


ustring ImportTextDialog::pick_newest_filename (const vector <ustring>& filenames)
// This function returns the newest filename of the vector of filenames given.
{
  // Pick newest.
  unsigned int modificationtime = 0;
  ustring returnvalue;
  // Solve bug that when the modification times were equal, nothing was taken.
  if (filenames.size() > 0)
    returnvalue = filenames[0];
  // Get newest (= youngest) file.
  for (unsigned int i = 0; i < filenames.size (); i++) {
    unsigned int modtime = file_get_modification_time (filenames[i]);
    if (modtime > modificationtime) {
      modificationtime = modtime;
      returnvalue = filenames[i];
    }
  }
  return returnvalue;
}


void ImportTextDialog::on_button_directory_clicked (GtkButton *button, gpointer user_data)
{
  ((ImportTextDialog *) user_data)->on_button_directory();
}


void ImportTextDialog::on_button_directory ()
{
  GtkWidget *dialog;
  dialog = gtk_file_chooser_dialog_new ("Select a folder", GTK_WINDOW (importsfmdialog),
    GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
    GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
  gtk_file_chooser_set_filename (GTK_FILE_CHOOSER (dialog), directory.c_str());
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
    directory = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
    select_all_books = true;
  }
  gtk_widget_destroy (dialog);
  set_gui ();
}



void ImportTextDialog::on_combobox_type_changed (GtkComboBox *combobox, gpointer user_data)
{
  ((ImportTextDialog *) user_data)->on_type();
}


void ImportTextDialog::on_type ()
{
  select_all_books = true;
  set_gui ();
}


ImportType ImportTextDialog::get_type ()
{
  ustring s = combobox_get_active_string (combobox_type);
  if (s == BIBLE_WORKS) 
    return itBibleWorks;
  if (s == MECHON_MAMRE)
    return itMechonMamre;
  return itUsfm;
}


void ImportTextDialog::on_button_unicode_clicked (GtkButton *button, gpointer user_data)
{
  ((ImportTextDialog *) user_data)->on_button_unicode();
}


void ImportTextDialog::on_button_unicode ()
{
  for (unsigned int i = 0; i < filenames_not_in_unicode.size(); i++) {
    UnicodeDialog unicodedialog (filenames_not_in_unicode[i]);
    if (unicodedialog.run () == GTK_RESPONSE_OK) {
      encoding_convert_from = unicodedialog.encoding;
      break;
    }
  }
  set_gui ();
}


void ImportTextDialog::on_button_books_clicked (GtkButton *button, gpointer user_data)
{
  ((ImportTextDialog *) user_data)->on_button_books();
}


void ImportTextDialog::on_button_books ()
{
  SelectBooksDialog dialog (sbImport, selectable_booknames, selected_books);
  if (dialog.run () == GTK_RESPONSE_OK)
    set_gui ();  
}


void ImportTextDialog::on_okbutton_clicked (GtkButton *button, gpointer user_data)
{
  ((ImportTextDialog *) user_data)->on_okbutton();
}


void ImportTextDialog::on_okbutton ()
// Does the actual import
{
  GeneralConfiguration genconfig (0);
  // Progress.
  ProgressWindow progress ("Importing ...", false);
  progress.set_iterate (0, 1, selectable_booknames.size());
  // Make container with all files to be converted.
  set <ustring> to_be_converted (filenames_not_in_unicode.begin(), filenames_not_in_unicode.end());
  // Go through all selectable books.
  for (unsigned int i = 0; i < selectable_booknames.size(); i++) {
    progress.iterate ();
    // Is book selected for import?
    if (selected_books.find (selectable_booknames[i]) != selected_books.end()) {
      // Get the book into the project.
      ustring source = selectable_filenames[i];
      ustring encoding;
      if (to_be_converted.find (selectable_filenames[i]) != to_be_converted.end()) {
        encoding = encoding_convert_from;
      }
      ImportBookRead ibr (source, encoding);
      switch (get_type ()) {
        case itUsfm:
        {
          ibr.usfm ();
          break;
        }
        case itBibleWorks:
        {
          ibr.bibleworks ();
          break;
        }
        case itMechonMamre:
        {
          ibr.mechonmamre ();
          break;
        }          
      }
      CategorizeChapterVerse ccv (ibr.lines);
      project_store_book (genconfig.project(), selectable_booknames[i], ccv);
      // Link?
      if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radiobutton_link))) {
        project_link_book (genconfig.project(), selectable_booknames[i], source);
      }
    }
  }
}


void ImportTextDialog::set_gui()
{
  // Handle progress.
  ProgressWindow progresswindow ("Processing import...", false);
  
  // Configuration
  GeneralConfiguration genconfig (0);
 
  // What to import.
  ImportType importtype = get_type ();
  
  // Directory part.
  
  // Initialize variable directory.
  if (directory.empty ()) 
    directory = g_get_home_dir ();
  // Read the directory, but leave the subdirectories out.
  vector <ustring> filenames;
  ReadFiles rd (directory, "", "");
  for (unsigned int i = 0; i < rd.files.size (); i++) {
    ustring filename = gw_build_filename (directory, rd.files[i]);
    /* Only check on files with a size smaller than so many bytes. This solves a
       problem of importing files, when a huge file of hundreds of megabytes is 
       found. It would try to read it all. This would take a very long time. 
       Therefore only files that are relatively small are taken into account.
     */
    unsigned int maximum_size = 1000000;
    // A file exported from BibleWorks can have sizes to about 5 Mbyte.
    if (importtype == itBibleWorks)
      maximum_size = 10000000;
    if (file_get_size (filename) < maximum_size) {
      filenames.push_back (filename);
    }
  }
  // Container for text files.
  vector <ustring> text_files;
  // See which files seem to be the proper ones.
  progresswindow.set_iterate (0, 0.5, filenames.size());
  for (unsigned int i = 0; i < filenames.size (); i++) {
    progresswindow.iterate ();
    switch (importtype) {
      case itUsfm:
      {
        if (!get_usfm_id_from_file (filenames[i]).empty ()) {
          text_files.push_back (filenames[i]);
        }
        break;
      }
      case itBibleWorks:
      {
        if (!bibleworks_file_get_bookname (filenames[i]).empty()) {
          text_files.push_back (filenames[i]);
        }
        break;
      }
      case itMechonMamre:
      {
        if (mechon_mamre_copyright (filenames[i])) {
          unsigned int digitcount = digit_count_in_string (filenames[i]);
          if (digitcount == 3 || digitcount == 4) {
            text_files.push_back (filenames[i]);
          }
        }
        break;
      }          
    }
  }
  // Info for user.
  ustring info = "Directory: " + directory;
  if (filenames.size () == 0)
    info.append ("\nThis directory contains no files");
  else {
    info.append ("\nNumber of files in this directory: " + convert_to_string (int (filenames.size ())));
    info.append ("\nNumber of files that seem to be proper texts: " + convert_to_string (int (text_files.size ())));
  }
  gtk_label_set_text (GTK_LABEL (label_directory), info.c_str());
  // Set Warning/Okay.
  gui_okay (image_directory, label_directory_gui, text_files.size () > 0);

  // Handle book type.

  switch (importtype) {
    case itUsfm:
    {
      // Do nothing.
      break;
    }
    case itBibleWorks:
    {
      // Importing BibleWorks files: divide the files per book.
      vector <ustring> bibleworks_text_files (text_files);
      text_files.clear();
      for (unsigned int i = 0; i < bibleworks_text_files.size(); i++) {
        vector<ustring> filenames = bibleworks_file_divide (bibleworks_text_files[i]);
        for (unsigned int i2 = 0; i2 < filenames.size(); i2++) {
          text_files.push_back (filenames[i2]);
        }
      }
      break;
    }
    case itMechonMamre:
    {
      // Importing Mechon Mamre Hebrew files: make one master file per book.
      text_files = mechon_mamre_produce_master_files (text_files);
      break;
    }
  }
  
  // Set Warning/Okay.
  gui_okay (image_type, label_type_gui, true);
  
  // Handle Book Selection.
  
  // Set button's sensitivity.
  gtk_widget_set_sensitive (button_books, text_files.size() > 0);
  // Handle selection mechanism.
  selectable_booknames.clear();
  selectable_filenames.clear();
  if (select_all_books)
    selected_books.clear();
  // Make a vector that contains all English names of the text files.
  vector <ustring> textfiles_names;
  for (unsigned int i = 0; i < text_files.size (); i++) {
    ustring english_name;
    switch (importtype) {
      case itUsfm:
      {
        ustring id_string = get_usfm_id_from_file (text_files[i]);
        unsigned int id = books_paratext_to_id (id_string);
        english_name = books_id_to_english (id);
        break;
      }
      case itBibleWorks:
      {
        english_name = bibleworks_file_get_bookname (text_files[i]);
        break;
      }
      case itMechonMamre:
      {
        english_name = gw_path_get_basename (text_files[i]);
        break;
      }          
    }
    textfiles_names.push_back (english_name);
  }
  // See which ones can be imported.
  vector <ustring> scripture_books = project_get_books (genconfig.project());
  for (unsigned int i = BOOKS_OT_FIRST_ID; i <= BOOKS_NT_LAST_ID; i++) {
    ustring bookname = books_id_to_english (i);
    bool inproject = false;
    for (unsigned int i2 = 0; i2 < scripture_books.size (); i2++) {
      if (scripture_books[i2] == bookname) {
        inproject = true;
        break;
      }
    }
    if (!inproject) {
      // Search if the book is among the files.
      vector <ustring> filenames_particular_book;
      for (unsigned int i2 = 0; i2 < text_files.size (); i2++) {
        if (textfiles_names[i2] == bookname) {
          filenames_particular_book.push_back (text_files[i2]);
        }
      }
      // Sort out what we found.
      ustring booktocopy;
      if (filenames_particular_book.empty ());
      else if (filenames_particular_book.size () == 1) {
        booktocopy = filenames_particular_book[0];
      } else {
        booktocopy = pick_newest_filename (filenames_particular_book);
      }
      // If we've a book, store it.
      if (!booktocopy.empty ()) {
        selectable_filenames.push_back (booktocopy);
        selectable_booknames.push_back(bookname);
        if (select_all_books)
          selected_books.insert (bookname);
      }
    }
  }
  // Clear initialization flag.
  select_all_books = false;
  // Set whether anything was selected.
  gui_okay (image_books, label_books_gui, selected_books.size () > 0);
  // Information for user.
  info = "Books selected: " + convert_to_string ((unsigned int) selected_books.size());
  gtk_label_set_text (GTK_LABEL (label_books), info.c_str());
  
  // Unicode part.
  
  // Progress
  progresswindow.set_iterate (0.5, 1, selectable_filenames.size());
  // Sensitivity of button.
  gtk_widget_set_sensitive (button_unicode, selected_books.size () > 0);
  // Check all text on Unicode.
  filenames_not_in_unicode.clear();
  for (unsigned int i = 0; i < selectable_filenames.size(); i++) {
    // Progress
    progresswindow.iterate ();
    // Is this book selected?
    if (selected_books.find (selectable_booknames[i]) != selected_books.end()) {
      ustring file_contents;
      bool unicode_valid = true;
      {
        gchar *s;
        g_file_get_contents (selectable_filenames[i].c_str(), &s, NULL, NULL);
        file_contents = s;
        g_free (s);
      }
      if (!file_contents.validate ()) {
        unicode_valid = false;
        filenames_not_in_unicode.push_back (selectable_filenames[i]);
      }
    }    
  }
  // User information. Widgets sensitivity.
  bool unicode_ok = filenames_not_in_unicode.size() == 0;
  info = "Books in already Unicode format: " + convert_to_string ((unsigned int) (selected_books.size() - filenames_not_in_unicode.size()));
  if (!encoding_convert_from.empty()) {
    info.append ("\nBooks to be converted from encoding " + encoding_convert_from + " to Unicode: " + convert_to_string ((unsigned int) (filenames_not_in_unicode.size())));
    unicode_ok = true;
  }
  gtk_label_set_text (GTK_LABEL (label_unicode), info.c_str());
  gui_okay (image_unicode, label_unicode_gui, unicode_ok);
  gtk_widget_set_sensitive (button_unicode, filenames_not_in_unicode.size() != 0);

  // Method is always okay.
  gui_okay (image_method, label_method_gui, true);
  switch (importtype) {
    // Usfm: either copy or link.
    case itUsfm:
    {
      gtk_widget_set_sensitive (radiobutton_copy, true);
      gtk_widget_set_sensitive (radiobutton_link, true);
      break;
    }
    // BibleWorks, etc.: only copy.
    case itBibleWorks:
    case itMechonMamre:
    {
      gtk_widget_set_sensitive (radiobutton_copy, false);
      gtk_widget_set_sensitive (radiobutton_link, false);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_copy), true);      
      break;
    }          
  }
  
  // Final information.
  bool import_possible = (text_files.size () > 0) && (selected_books.size () > 0) && (unicode_ok);
  info.clear();
  if (import_possible)
    info = "Press OK to import";
  gtk_label_set_text (GTK_LABEL (label_import), info.c_str());
  // Set sensitivity of OK button.
  gtk_widget_set_sensitive (okbutton, import_possible);
}
