/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_DIALOGPROJECT_H
#define INCLUDED_DIALOGPROJECT_H


#include <gtk/gtk.h>
#include "generalconfig.h"


class ProjectDialog
{
public:
  ProjectDialog (bool newproject);
  ~ProjectDialog ();
  int run ();
  ustring newprojectname;
protected:
  GtkWidget *projectdialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox1;
  GtkWidget *label1;
  GtkWidget *nameentry;
  GtkWidget *messagelabel;
  GtkWidget *table1;
  GtkWidget *label9;
  GtkWidget *label8;
  GtkWidget *vseparator1;
  GtkWidget *addbutton;
  GtkWidget *alignment1;
  GtkWidget *hbox2;
  GtkWidget *image1;
  GtkWidget *label5;
  GtkWidget *deletebutton;
  GtkWidget *alignment2;
  GtkWidget *hbox3;
  GtkWidget *image2;
  GtkWidget *label6;
  GtkWidget *importbutton;
  GtkWidget *alignment3;
  GtkWidget *hbox5;
  GtkWidget *image3;
  GtkWidget *label10;
  GtkWidget *hseparator1;
  GtkWidget *table2;
  GtkWidget *label11;
  GtkWidget *combobox_versification;
  GtkWidget *dialog_action_area1;
  GtkWidget *cancelbutton1;
  GtkWidget *okbutton1;
private:
  ustring currentprojectname;
  bool set_gui ();
  void on_book_add ();
  void on_book_delete ();
  void on_import ();
  void on_ok ();
  void on_cancel ();
  static void projectdialog_on_nameentry_changed (GtkEditable * editable, gpointer user_data);
  static void projectdialog_on_okbutton1_clicked (GtkButton * button, gpointer user_data);
  static void projectdialog_on_addbutton_clicked (GtkButton * button, gpointer user_data);
  static void projectdialog_on_deletebutton_clicked (GtkButton * button, gpointer user_data);
  static void projectdialog_on_cancelbutton1_clicked (GtkButton * button, gpointer user_data);
  static void on_importbutton_clicked (GtkButton *button, gpointer user_data);
  GeneralConfiguration genconfig;
};


#endif
