/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include <glib.h>
#include "dialogselectchapters.h"
#include "combobox.h"
#include "utilities.h"
#include "portion_utils.h"
#include "projectutils.h"
#include "constants.h"


SelectChaptersDialog::SelectChaptersDialog (const ustring& project, const ustring& book, const ustring& currentselection)
{
  // Save / check variables.
  myproject = project;
  mybook = book;
  myportion = currentselection;
  
  // Build dialog.
  selectchaptersdialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (selectchaptersdialog), "Select portion");
  gtk_window_set_position (GTK_WINDOW (selectchaptersdialog), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_modal (GTK_WINDOW (selectchaptersdialog), TRUE);

  dialog_vbox1 = GTK_DIALOG (selectchaptersdialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  table1 = gtk_table_new (4, 3, TRUE);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), table1, TRUE, TRUE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 2);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 2);

  buttonall = gtk_button_new ();
  gtk_widget_show (buttonall);
  gtk_table_attach (GTK_TABLE (table1), buttonall, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  alignment5 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment5);
  gtk_container_add (GTK_CONTAINER (buttonall), alignment5);

  hbox8 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox8);
  gtk_container_add (GTK_CONTAINER (alignment5), hbox8);

  image5 = gtk_image_new_from_stock ("gtk-justify-fill", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image5);
  gtk_box_pack_start (GTK_BOX (hbox8), image5, FALSE, FALSE, 0);

  label18 = gtk_label_new_with_mnemonic ("_All");
  gtk_widget_show (label18);
  gtk_box_pack_start (GTK_BOX (hbox8), label18, FALSE, FALSE, 0);

  label17 = gtk_label_new_with_mnemonic ("_To:");
  gtk_widget_show (label17);
  gtk_table_attach (GTK_TABLE (table1), label17, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label17), 1, 0.5);

  label16 = gtk_label_new_with_mnemonic ("_From:");
  gtk_widget_show (label16);
  gtk_table_attach (GTK_TABLE (table1), label16, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label16), 1, 0.5);

  comboboxtochapter = gtk_combo_box_new_text ();
  gtk_widget_show (comboboxtochapter);
  gtk_table_attach (GTK_TABLE (table1), comboboxtochapter, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  comboboxfromchapter = gtk_combo_box_new_text ();
  gtk_widget_show (comboboxfromchapter);
  gtk_table_attach (GTK_TABLE (table1), comboboxfromchapter, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label19 = gtk_label_new ("chapter");
  gtk_widget_show (label19);
  gtk_table_attach (GTK_TABLE (table1), label19, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label20 = gtk_label_new ("verse");
  gtk_widget_show (label20);
  gtk_table_attach (GTK_TABLE (table1), label20, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  comboboxfromverse = gtk_combo_box_new_text ();
  gtk_widget_show (comboboxfromverse);
  gtk_table_attach (GTK_TABLE (table1), comboboxfromverse, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  comboboxtoverse = gtk_combo_box_new_text ();
  gtk_widget_show (comboboxtoverse);
  gtk_table_attach (GTK_TABLE (table1), comboboxtoverse, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  dialog_action_area1 = GTK_DIALOG (selectchaptersdialog)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  cancelbutton = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton);
  gtk_dialog_add_action_widget (GTK_DIALOG (selectchaptersdialog), cancelbutton, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton, GTK_CAN_DEFAULT);

  okbutton = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton);
  gtk_dialog_add_action_widget (GTK_DIALOG (selectchaptersdialog), okbutton, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) buttonall, "clicked",
                    G_CALLBACK (on_buttonall_clicked),
                    gpointer(this));
  g_signal_connect ((gpointer) comboboxtochapter, "changed",
                    G_CALLBACK (on_comboboxtochapter_changed),
                    gpointer(this));
  g_signal_connect ((gpointer) comboboxfromchapter, "changed",
                    G_CALLBACK (on_comboboxfromchapter_changed),
                    gpointer(this));
  g_signal_connect ((gpointer) comboboxfromverse, "changed",
                    G_CALLBACK (on_comboboxfromverse_changed),
                    gpointer(this));
  g_signal_connect ((gpointer) comboboxtoverse, "changed",
                    G_CALLBACK (on_comboboxtoverse_changed),
                    gpointer(this));
  g_signal_connect ((gpointer) okbutton, "clicked",
                    G_CALLBACK (on_okbutton_clicked),
                    gpointer(this));

  gtk_label_set_mnemonic_widget (GTK_LABEL (label16), comboboxfromchapter);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label17), comboboxtochapter);

  gtk_widget_grab_focus (okbutton);
  gtk_widget_grab_default (okbutton);
  
  // Set comboboxes.
  portion_set (myportion);
}


SelectChaptersDialog::~SelectChaptersDialog ()
{
  gtk_widget_destroy (selectchaptersdialog);
}


int SelectChaptersDialog::run ()
{
  return gtk_dialog_run (GTK_DIALOG (selectchaptersdialog));
}


void SelectChaptersDialog::on_okbutton_clicked (GtkButton *button, gpointer user_data)
{
  ((SelectChaptersDialog *) user_data)->on_okbutton ();
}


void SelectChaptersDialog::on_okbutton ()
{
  new_selection = select_portion_get_label (myproject, mybook,
    convert_to_int (combobox_get_active_string (comboboxfromchapter)),
    combobox_get_active_string (comboboxfromverse),
    convert_to_int (combobox_get_active_string (comboboxtochapter)),
    combobox_get_active_string (comboboxtoverse));
}


void SelectChaptersDialog::on_comboboxfromchapter_changed (GtkComboBox *combobox, gpointer user_data)
{
  ((SelectChaptersDialog *) user_data)->on_fromchapter ();
}


void SelectChaptersDialog::on_fromchapter ()
{
  if (driving_combos)
    return;
  // Fill verses combo.
  unsigned int from = convert_to_int (combobox_get_active_string (comboboxfromchapter));
  vector<ustring> verses = project_get_verses (myproject, mybook, from);
  combobox_set_strings (comboboxfromverse, verses);
  combobox_set_string (comboboxfromverse, verses[0]);
  // If from_chapter > to_chapter, push to_chapter up, as this is probably what the user wants.
  unsigned int to = convert_to_int (combobox_get_active_string (comboboxtochapter));
  if (from > to) {
    combobox_set_string (comboboxtochapter, from);
  }
}


void SelectChaptersDialog::on_comboboxfromverse_changed (GtkComboBox *combobox, gpointer user_data)
{
  ((SelectChaptersDialog *) user_data)->on_fromverse ();
}


void SelectChaptersDialog::on_fromverse ()
{
  verses_from_to (true);
}


void SelectChaptersDialog::on_comboboxtochapter_changed (GtkComboBox *combobox, gpointer user_data)
{
  ((SelectChaptersDialog *) user_data)->on_tochapter ();
}


void SelectChaptersDialog::on_tochapter ()
{
  if (driving_combos)
    return;
  // Fill verses combo.
  unsigned int to = convert_to_int (combobox_get_active_string (comboboxtochapter));
  vector<ustring> verses = project_get_verses (myproject, mybook, to);
  combobox_set_strings (comboboxtoverse, verses);
  combobox_set_string (comboboxtoverse, verses[verses.size() - 1]);
  // Modify "from" chapter, if need be.
  unsigned int from = convert_to_int (combobox_get_active_string (comboboxfromchapter));
  if (to < from) {
    combobox_set_string (comboboxfromchapter, to);
  }
}


void SelectChaptersDialog::on_comboboxtoverse_changed (GtkComboBox *combobox, gpointer user_data)
{
  ((SelectChaptersDialog *) user_data)->on_toverse ();
}


void SelectChaptersDialog::on_toverse ()
{
  verses_from_to (false);
}


void SelectChaptersDialog::on_buttonall_clicked (GtkButton *button, gpointer user_data)
{
  ((SelectChaptersDialog *) user_data)->on_all ();
}


void SelectChaptersDialog::on_all ()
{
  portion_set (CHAPTER_VERSE_SELECTION_ALL); 
}


void SelectChaptersDialog::portion_set (const ustring& selection)
// Sets the portion in the gui.
{
  // Get values for the portion.
  unsigned int chapter_from, chapter_to;
  ustring verse_from, verse_to;
  select_portion_get_values (myproject, mybook, selection, chapter_from, verse_from, chapter_to, verse_to);

  // Signal we're filling comboboxes.
  driving_combos = true;
  
  // Set the chapter combos.
  vector<unsigned int> chapters = project_get_chapters (myproject, mybook);
  combobox_set_strings (comboboxfromchapter, chapters);
  combobox_set_strings (comboboxtochapter, chapters);
  combobox_set_string (comboboxfromchapter, chapter_from);
  combobox_set_string (comboboxtochapter, chapter_to);

  // Set the verse combox.
  combobox_set_strings (comboboxfromverse, project_get_verses (myproject, mybook, chapter_from));
  combobox_set_strings (comboboxtoverse, project_get_verses (myproject, mybook, chapter_to));
  combobox_set_string (comboboxfromverse, verse_from);
  combobox_set_string (comboboxtoverse, verse_to);  
  
  // Ready filling combos.
  driving_combos = false;
}


void SelectChaptersDialog::verses_from_to (bool called_by_from)
{
  if (driving_combos)
    return;
  // If from/to chapters are different, don't bother further.
  unsigned int chapter = convert_to_int (combobox_get_active_string (comboboxfromchapter));
  if (convert_to_int (combobox_get_active_string (comboboxtochapter)) != chapter)
    return;
  // Ensure there's no clash between the verses "from" and "to".
  vector<ustring> verses = project_get_verses (myproject, mybook, chapter);
  ustring from = combobox_get_active_string (comboboxfromverse);
  ustring to = combobox_get_active_string (comboboxtoverse);
  unsigned int from_offset = 0;
  unsigned int to_offset = 0;
  for (unsigned int i = 0; i < verses.size(); i++) {
    if (verses[i] == from)
      from_offset = i;
    if (verses[i] == to)
      to_offset = i;
  }
  if (called_by_from) {
    if (from_offset > to_offset)
      combobox_set_string (comboboxtoverse, verses[from_offset]);
  } else {
    if (to_offset < from_offset)
      combobox_set_string (comboboxfromverse, verses[to_offset]);
  }
}
