/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "gtkwrappers.h"
#include <libgen.h>
#include <glib.h>


void gtkw_dialog_info (GtkWidget * parent, const ustring& info)
{
  // Create the basic dialog.
  GtkWidget * dialog = gtk_message_dialog_new (GTK_WINDOW (parent), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, info.c_str());
  // Add cancel button so that pressing the Escape button will also close the window,
  // but hide this button so it's not visible, but Escape remains working.
  GtkWidget * cancel = gtk_dialog_add_button (GTK_DIALOG (dialog), "", GTK_RESPONSE_CANCEL);
  gtk_widget_hide (cancel);
  // Run dialog.
  gtk_dialog_run (GTK_DIALOG (dialog));
  // After through, destroy it.
  gtk_widget_destroy (dialog);
}


int gtkw_dialog_question (GtkWidget * parent, const ustring& question, int default_response)
{
  int result;
  GtkWidget * dialog = gtk_message_dialog_new (GTK_WINDOW (parent), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, question.c_str());
  if (default_response != GTK_RESPONSE_NO)
    gtk_dialog_set_default_response (GTK_DIALOG (dialog), default_response);    
  result = gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
  return result;
}


void gtkw_dialog_error (GtkWidget * parent, const ustring& error)
{
  GtkWidget * dialog = gtk_message_dialog_new (GTK_WINDOW (parent), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, error.c_str());
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}


void gtkw_dialog_warning (GtkWidget * parent, const ustring& warning)
{
  GtkWidget * dialog = gtk_message_dialog_new (GTK_WINDOW (parent), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK, warning.c_str());
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}


ustring gtkw_file_chooser_select_folder (GtkWidget * parent, const ustring& title, const ustring& directory)
// Allows user to select a folder.
// parent: window will be centered on parent, or NULL.
// title: If given, will be title for the dialog.
// directory: If given, will be directory selected by default.
// Returns the folder selected, or is empty if no selection was made.
{
  // Initialize variables.
  ustring selection;
  ustring mytitle (title);
  if (mytitle.empty()) 
    mytitle = "Select a folder";
  ustring mydirectory (directory);
  if (mydirectory.empty()) 
    mydirectory = g_get_home_dir ();
  mydirectory.append (G_DIR_SEPARATOR_S);
  // Create dialog.
  GtkWidget *dialog;
  dialog = gtk_file_chooser_dialog_new (mytitle.c_str(), GTK_WINDOW (parent),
    GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
    GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
  gtk_file_chooser_set_filename (GTK_FILE_CHOOSER (dialog), mydirectory.c_str());
  // Run dialog.
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
    selection = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
  }
  // Destroy dialog
  gtk_widget_destroy (dialog);  
  // Return selection.
  return selection;
}
