/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "oldconfiguration.h"
#include "utilities.h"
#include "config.h"
#include "directories.h"
#include "java.h"
#include "date_time_utils.h"
#include "gwrappers.h"
#include "xmlutils.h"


// Inserting notes.
#define INSERT_FOOTNOTE_TEMPLATE "insert-footnote-template"
#define INSERT_ENDNOTE_TEMPLATE "insert-endnote-template"
#define INSERT_XREF_TEMPLATE "insert-xref-template"

// Styletree.
#define CATEGORY_EXPANDED_0 "category-expanded-0"
#define CATEGORY_EXPANDED_1 "category-expanded-1"
#define CATEGORY_EXPANDED_2a "category-expanded-2a"
#define CATEGORY_EXPANDED_2b "category-expanded-2b"
#define CATEGORY_EXPANDED_2c "category-expanded-2c"
#define CATEGORY_EXPANDED_3 "category-expanded-3"
#define CATEGORY_EXPANDED_4 "category-expanded-4"
#define CATEGORY_EXPANDED_5 "category-expanded-5"
#define CATEGORY_EXPANDED_6 "category-expanded-6"
#define CATEGORY_EXPANDED_7 "category-expanded-7"
#define CATEGORY_EXPANDED_8 "category-expanded-8"
#define CATEGORY_EXPANDED_9 "category-expanded-9"
#define CATEGORY_EXPANDED_10 "category-expanded-10"
#define CATEGORY_EXPANDED_11 "category-expanded-11"
#define CATEGORY_EXPANDED_12 "category-expanded-12"
#define CATEGORY_EXPANDED_13 "category-expanded-13"

// Printing
#define PRINT_HIGH_QUALITY "print-high-quality"
#define NOTES_PRINT_FULL_PAGE_WIDTH "notes-print-full-page-width"

// Export
#define EXPORT_TO_BIBLEWORKS_FILENAME "export-to-bibleworks-filename"
#define EXPORT_TO_SWORD_MODULE_PATH "export-to-sword-module-path"
#define EXPORT_TO_SWORD_INSTALL_PATH "export-to-sword-install-path"

// Parallel Bible
#define PARALLEL_BIBLE_KEEP_VERSES_TOGETHER "parallel-bible-keep-verses-together"
#define PARALLEL_BIBLE_CHAPTES_VERSES "parallel-bible-chapters-verses"
#define PARALLEL_BIBLE_INCLUDE_VERSE_0 "parallel-bible-include_verse0"

// Screen layout
#define VPANE_FOOTNOTES_POSITION "vpane-footnotes-position"
#define VPANE_REFERENCES_POSITION "vpane-references-position"
#define TOOLS_AREA_LEFT "tools-area-left"

// Reference exchange
#define BIBLEWORKS_EXECUTABLE "bibleworks-executable"
#define REFERENCE_EXCHANGE_SEND_TO_SANTAFEFOCUS "reference-exchange-send-to-santafefocus"
#define REFERENCE_EXCHANGE_RECEIVE_FROM_SANTAFEFOCUS "reference-exchange-receive-from-santafefocus"

// Notes view
#define NOTES_SHOW_PROJECT "notes-show-project"


OldConfiguration::OldConfiguration (GtkWindow *window)
{
  // Set default values.
  export_to_sword_module_path = g_get_home_dir ();
  export_to_sword_install_path = gw_build_filename (g_get_home_dir (), ".sword");
  parallel_bible_keep_verses_together = true;
  parallel_bible_chapters_verses = CHAPTER_VERSE_SELECTION_ALL;
  parallel_bible_include_verse_zero = false;
  reference_exchange_send_to_santafefocus = true;
  reference_exchange_receive_from_santafefocus = false;
  bibleworks_executable = "bw700.exe";
  notes_show_project = false;
  tools_area_left = false;
  
  // Read the configuration file, if there is any. Add the bits that are missing.
  ReadText rc (bibleditrc (), true);
  screen_resolution_changed = false;
  for (unsigned int i = 0; i <= 1000; i++)
    {
      switch (i)
        {
        case 2:
          {
            if (i < rc.lines.size ())
              {
                edit_note_standard_text_one = rc.lines[i];
              }
            else
              {
                edit_note_standard_text_one.clear();
              }
            break;
          }
        case 3:
          {
            if (i < rc.lines.size ())
              {
                edit_note_standard_text_two = rc.lines[i];
              }
            else
              {
                edit_note_standard_text_two.clear ();
              }
            break;
          }
        case 4:
          {
            if (i < rc.lines.size ())
              {
                edit_note_standard_text_three = rc.lines[i];
              }
            else
              {
                edit_note_standard_text_three.clear();
              }
            break;
          }
        case 5:
          {
            screen_width = 0;
            if (window) {
              GdkScreen *screen;
              screen = gtk_window_get_screen (window);
              gint width;
              width = gdk_screen_get_width (screen);
              if (i < rc.lines.size ()) screen_width = convert_to_int (rc.lines[i]);
              if (screen_width != width) {
                screen_resolution_changed = true;
                screen_width = width;
              }
            } else {
              if (i < rc.lines.size ()) screen_width = convert_to_int (rc.lines[i]);
            }
            break;
          }
        case 6:
          {
            if (window) {
              screen_height = 0;
              GdkScreen *screen;
              screen = gtk_window_get_screen (window);
              gint height;
              height = gdk_screen_get_height (screen);
              if (i < rc.lines.size ()) screen_height = convert_to_int (rc.lines[i]);
              if (screen_height != height) {
                screen_resolution_changed = true;
                screen_height = height;
              }
            } else {
              if (i < rc.lines.size ()) screen_height = convert_to_int (rc.lines[i]);
            }
            break;
          }
        case 7:
          {
            bool take_default = false;
            if (i < rc.lines.size ())
              {
                window_width = convert_to_int (rc.lines[i]);
              }
            else
              {
                take_default = true;
              }
            if (screen_resolution_changed || take_default)
              {
                window_width = screen_width * 95 / 100;
              }
            break;
          }
        case 8:
          {
            bool take_default = false;
            if (i < rc.lines.size ())
              {
                window_height = convert_to_int (rc.lines[i]);
              }
            else
              {
                take_default = true;
              }
            if (screen_resolution_changed || take_default)
              {
                window_height = screen_height * 90 / 100;
              }
            break;
          }
        case 9:
          {
            bool take_default = false;
            if (i < rc.lines.size ())
              {
                window_x_position = convert_to_int (rc.lines[i]);
              }
            else
              {
                take_default = true;
              }
            if (screen_resolution_changed || take_default)
              {
                window_x_position = 0;
              }
            break;
          }
        case 10:
          {
            bool take_default = false;
            if (i < rc.lines.size ())
              {
                window_y_position = convert_to_int (rc.lines[i]);
              }
            else
              {
                take_default = true;
              }
            if (screen_resolution_changed || take_default)
              {
                window_y_position = 0;
              }
            break;
          }
        case 11:
          {
            bool take_default = false;
            if (i < rc.lines.size ())
              {
                hpane_position = convert_to_int (rc.lines[i]);
              }
            else
              {
                take_default = true;
              }
            if (screen_resolution_changed || take_default)
              {
                hpane_position = window_width * 87 / 100;
              }
            // Prevents editor from becoming invisible altogether,
            // prompting users to ask for support.
            if (hpane_position < 300) hpane_position = 300;
            break;
          }
        case 12:
          {
            bool take_default = false;
            if (i < rc.lines.size ())
              {
                vpane_editor_position = convert_to_int (rc.lines[i]);
              }
            else
              {
                take_default = true;
              }
            if (screen_resolution_changed || take_default)
              {
                vpane_editor_position = window_height * 60 / 100;
              }
            // Prevents editor from becoming invisible altogether,
            // prompting users to ask for support.
            if (vpane_editor_position < 200) vpane_editor_position = 200;
            break;
          }
        case 13:
          {
            if (i < rc.lines.size ())
              {
                book_opened = rc.lines[i];
              }
            else
              {
                book_opened.clear ();
              }
            break;
          }
        case 14:
          {
            if (i < rc.lines.size ())
              {
                chapter_opened = rc.lines[i];
              }
            else
              {
                chapter_opened = "1";
              }
            break;
          }
        case 15:
          {
            if (i < rc.lines.size ())
              {
                verse_opened = rc.lines[i];
              }
            else
              {
                verse_opened = "1";
              }
            break;
          }

        case 16:
          {
            if (i < rc.lines.size ())
              {
                edit_note_standard_text_four = rc.lines[i];
              }
            else
              {
                edit_note_standard_text_four.clear ();
              }
            break;
          }

        case 20:
          {
            if (i < rc.lines.size ())
              {
                references_file = rc.lines[i];
              }
            else
              {
                references_file.clear ();
              }
            break;
          }

        case 23:
          {
            if (i < rc.lines.size ())
              export_to_bibleworks_filename = rc.lines[i];
            break;
          }

        case 24:
          {
            if (i < rc.lines.size ())
              {
                editor_font_name = rc.lines[i];
              }
            else
              {
                editor_font_name = "Sans 14";
              }
            break;
          }

        case 26:
          {
            if (i < rc.lines.size ())
              {
                project = rc.lines[i];
              }
            else
              {
                project.clear ();
              }
            break;
          }

        case 28:
          {
            if (i < rc.lines.size ()) {
              paper_format = rc.lines[i];
            }
            else {
              paper_format = "A4";
            }
            break;
          }

        case 29:
          {
            if (i < rc.lines.size ()) {
              paper_width = convert_to_double (rc.lines[i]);
            }
            else {
              paper_width = 21.0;
            }
            break;
          }

        case 30:
          {
            if (i < rc.lines.size ()) {
              paper_height = convert_to_double (rc.lines[i]);
            }
            else {
              paper_height = 29.7;
            }
            break;
          }

        case 31:
          {
            if (i < rc.lines.size ()) {
              paper_left_margin = convert_to_double (rc.lines[i]);
            }
            else {
              paper_left_margin = 2;
            }
            break;
          }

        case 32:
          {
            if (i < rc.lines.size ()) {
              paper_right_margin = convert_to_double (rc.lines[i]);
            }
            else {
              paper_right_margin = 2;
            }
            break;
          }

        case 33:
          {
            if (i < rc.lines.size ()) {
              paper_top_margin = convert_to_double (rc.lines[i]);
            }
            else {
              paper_top_margin = 2;
            }
            break;
          }

        case 34:
          {
            if (i < rc.lines.size ()) {
              paper_bottom_margin = convert_to_double (rc.lines[i]);
            }
            else {
              paper_bottom_margin = 2;
            }
            break;
          }

        case 35:
          {
            if (i < rc.lines.size ()) {
              java_binary = rc.lines[i];
            }
            else {
              java_binary.clear();
            }
            break;
          }

        case 36:
          {
            if (i < rc.lines.size ()) {
              printcoverpage = convert_to_bool (rc.lines[i]);
            }
            else {
              printcoverpage = true;
            }
            break;
          }

        case 38:
          {
            if (i < rc.lines.size ()) {
              printdate = convert_to_bool (rc.lines[i]);
            }
            else {
              printdate = true;
            }
            break;
          }

        case 39:
          {
            if (i < rc.lines.size ()) {
              print_changes_only = convert_to_bool (rc.lines[i]);
            }
            else {
              print_changes_only = false;
            }
            break;
          }

        case 40:
          {
            if (i < rc.lines.size ()) {
              project_to_compare_with = rc.lines[i];
            }
            else {
              project_to_compare_with.clear();
            }
            break;
          }

        case 43:
          {
            if (i < rc.lines.size ()) {
              show_notes_for_current_project_only = convert_to_bool (rc.lines[i]);
            }
            else {
              show_notes_for_current_project_only = false;
            }
            break;
          }

        case 45:
          {
            if (i < rc.lines.size ()) {
              xep_home = rc.lines[i];
            }
            else {
              xep_home.clear();
            }
            break;
          }

        case 46:
          {
            int selector;
            if (i < rc.lines.size ()) {
              selector = convert_to_int (rc.lines[i]);
            }
            else {
              selector = 0;
            }
            show_notes_selector = ShowNotesSelector (selector);
            break;
          }

        case 47:
          {
            if (i < rc.lines.size ()) {
              show_notes_category = rc.lines[i];
            }
            else {
              show_notes_category.clear();
            }
            break;
          }

        case 48:
          {
            if (i < rc.lines.size ()) {
              show_notes_date_range_from = convert_to_int (rc.lines[i]);
            }
            else {
              show_notes_date_range_from = date_time_julian_day_get_current();
            }
            break;
          }

        case 49:
          {
            if (i < rc.lines.size ()) {
              show_notes_date_range_to = convert_to_int (rc.lines[i]);
            }
            else {
              show_notes_date_range_to = date_time_julian_day_get_current();
            }
            break;
          }

        case 52:
          {
            if (i < rc.lines.size ()) {
              reference_exchange_send_to_bibleworks = convert_to_bool (rc.lines[i]);
            }
            else {
              reference_exchange_send_to_bibleworks = false;
            }
            break;
          }
          
        case 53:
          {
            if (i < rc.lines.size ()) {
              reference_exchange_receive_from_bibleworks = convert_to_bool (rc.lines[i]);
            }
            else {
              reference_exchange_receive_from_bibleworks = false;
            }
            break;
          }
          
        case 54:
          {
            if (i < rc.lines.size ()) {
              reference_exchange_send_to_bibletime = convert_to_bool (rc.lines[i]);
            }
            else {
              reference_exchange_send_to_bibletime = false;
            }
            break;
          }
          
        case 55:
          {
            if (i < rc.lines.size ()) {
              reference_exchange_receive_from_bibletime = convert_to_bool (rc.lines[i]);
            }
            else {
              reference_exchange_receive_from_bibletime = false;
            }
            break;
          }
          
        case 56:
          {
            if (i < rc.lines.size ()) {
              check_markers_compare_project = rc.lines[i];
            }
            else {
              check_markers_compare_project.clear();
            }
            break;
          }

        case 57:
          {
            if (i < rc.lines.size ()) {
              check_markers_compare_all_markers = convert_to_bool (rc.lines[i]);
            }
            else {
              check_markers_compare_all_markers = true;
            }
            break;
          }
          
        case 58:
          {
            if (i < rc.lines.size ()) {
              check_markers_compare_include_only = rc.lines[i];
            }
            else {
              check_markers_compare_include_only.clear();
            }
            break;
          }
          
        case 59:
          {
            if (i < rc.lines.size ()) {
              check_markers_compare_ignore = rc.lines[i];
            }
            else {
              check_markers_compare_ignore.clear();
            }
            break;
          }
          
        case 60:
          {
            if (i < rc.lines.size ()) {
              check_markers_compare_ignore_verse_zero = convert_to_bool (rc.lines[i]);
            }
            else {
              check_markers_compare_ignore_verse_zero = false;
            }
            break;
          }
          
        case 61:
          {
            if (i < rc.lines.size ()) {
              check_capitalization_punctuation = rc.lines[i];
            }
            else {
              check_capitalization_punctuation = CAPITALIZATION_PUNCTUATION;
            }
            break;
          }
          
        case 62:
          {
            if (i < rc.lines.size ()) {
              check_capitalization_ignore = rc.lines[i];
            }
            else {
              check_capitalization_ignore = CAPITALIZATION_LOWERCASE;
            }
            break;
          }
          
        case 63:
          {
            if (i < rc.lines.size ()) {
              check_capitalization_allow_any_prefixes = convert_to_bool (rc.lines[i]);
            }
            else {
              check_capitalization_allow_any_prefixes = false;
            }
            break;
          }

        case 64:
          {
            if (i < rc.lines.size ()) {
              check_repetition_ignore_case = convert_to_bool (rc.lines[i]);
            }
            else {
              check_repetition_ignore_case = false;
            }
            break;
          }
          
        case 65:
          {
            if (i < rc.lines.size ()) {
              check_repetition_show_only_these = convert_to_bool (rc.lines[i]);
            }
            else {
              check_repetition_show_only_these = false;
            }
            break;
          }
          
        case 66:
          {
            if (i < rc.lines.size ()) {
              check_repetition_ignore_these = convert_to_bool (rc.lines[i]);
            }
            else {
              check_repetition_ignore_these = false;
            }
            break;
          }

        case 67:
          {
            if (i < rc.lines.size ()) {
              check_matching_pairs_ignore = rc.lines[i];
            }
            else {
              check_matching_pairs_ignore.clear();
            }
            break;
          }

        case 68:
          {
            if (i < rc.lines.size ()) {
              tools_area_page_number = convert_to_int (rc.lines[i]);
            }
            else {
              tools_area_page_number = 0;
            }
            break;
          }

        case 69:
          {
            if (i < rc.lines.size ()) {
              stylesheet = convert_to_int (rc.lines[i]);
            }
            else {
            }
            break;
          }

        case 80:
          {
            if (i < rc.lines.size ()) {
              category_expanded_0 = convert_to_bool (rc.lines[i]);
            }
            else {
              category_expanded_0 = false;
            }
            break;
          }

        case 81:
          {
            if (i < rc.lines.size ()) {
              category_expanded_1 = convert_to_bool (rc.lines[i]);
            }
            else {
              category_expanded_1 = false;
            }
            break;
          }

        case 82:
          {
            if (i < rc.lines.size ()) {
              category_expanded_2a = convert_to_bool (rc.lines[i]);
            }
            else {
              category_expanded_2a = false;
            }
            break;
          }

        case 83:
          {
            if (i < rc.lines.size ()) {
              category_expanded_3 = convert_to_bool (rc.lines[i]);
            }
            else {
              category_expanded_3 = false;
            }
            break;
          }

        case 84:
          {
            if (i < rc.lines.size ()) {
              category_expanded_4 = convert_to_bool (rc.lines[i]);
            }
            else {
              category_expanded_4 = false;
            }
            break;
          }

        case 85:
          {
            if (i < rc.lines.size ()) {
              category_expanded_5 = convert_to_bool (rc.lines[i]);
            }
            else {
              category_expanded_5 = false;
            }
            break;
          }

        case 86:
          {
            if (i < rc.lines.size ()) {
              category_expanded_6 = convert_to_bool (rc.lines[i]);
            }
            else {
              category_expanded_6 = false;
            }
            break;
          }

        case 87:
          {
            if (i < rc.lines.size ()) {
              category_expanded_7 = convert_to_bool (rc.lines[i]);
            }
            else {
              category_expanded_7 = false;
            }
            break;
          }

        case 88:
          {
            if (i < rc.lines.size ()) {
              category_expanded_8 = convert_to_bool (rc.lines[i]);
            }
            else {
              category_expanded_8 = false;
            }
            break;
          }

        case 89:
          {
            if (i < rc.lines.size ()) {
              category_expanded_9 = convert_to_bool (rc.lines[i]);
            }
            else {
              category_expanded_9 = false;
            }
            break;
          }

        case 90:
          {
            if (i < rc.lines.size ()) {
              category_expanded_10 = convert_to_bool (rc.lines[i]);
            }
            else {
              category_expanded_10 = false;
            }
            break;
          }

        case 91:
          {
            if (i < rc.lines.size ()) {
              category_expanded_11 = convert_to_bool (rc.lines[i]);
            }
            else {
              category_expanded_11 = false;
            }
            break;
          }

        case 92:
          {
            if (i < rc.lines.size ()) {
              category_expanded_12 = convert_to_bool (rc.lines[i]);
            }
            else {
              category_expanded_12 = false;
            }
            break;
          }

        case 93:
          {
            if (i < rc.lines.size ()) {
              category_expanded_13 = convert_to_bool (rc.lines[i]);
            }
            else {
              category_expanded_13 = false;
            }
            break;
          }

        case 94:
          {
            if (i < rc.lines.size ()) {
              print_high_quality = convert_to_bool (rc.lines[i]);
            }
            else {
              print_high_quality = false;
            }
            break;
          }

        case 95:
          {
            if (i < rc.lines.size ()) {
              category_expanded_2b = convert_to_bool (rc.lines[i]);
            }
            else {
              category_expanded_2b = false;
            }
            break;
          }

        case 96:
          {
            if (i < rc.lines.size ()) {
              category_expanded_2c = convert_to_bool (rc.lines[i]);
            }
            else {
              category_expanded_2c = false;
            }
            break;
          }
          
        case 97:
          {
            if (i < rc.lines.size ()) {
              notes_print_full_page_width = convert_to_bool (rc.lines[i]);
            }
            else {
              notes_print_full_page_width = false;
            }
            break;
          }
        }
    }

  // Set default values depending on values read thus far in the old configuration style.
  vpane_footnotes_position = int (0.85 * vpane_editor_position);
  vpane_references_position = vpane_editor_position;

  // Read the style file.
  bool was_error = false;
  gchar *contents;
  gsize  length;
  GError *error;
  error = NULL;
  if (!g_file_get_contents (configurationfilename().c_str(), &contents, &length, &error)) {
    cerr << error->message << endl;
    g_error_free (error);
    was_error = true;
  }
  // Set up parser.
  GMarkupParseContext *context = NULL;
  GMarkupParser parser = {
    start_element_handler,
    end_element_handler,
    text_handler,
    passthrough_handler,
    error_handler
  };
  // Parse xml file.
  if (!was_error) {
    context = g_markup_parse_context_new (&parser, GMarkupParseFlags (0), gpointer (this), NULL);
    if (!g_markup_parse_context_parse (context, contents, length, NULL)) {
      g_markup_parse_context_free (context);
      was_error = true;
      cerr << error->message << endl;
    }
  }
  if (!was_error) {
    if (!g_markup_parse_context_end_parse (context, NULL)) {
      g_markup_parse_context_free (context);
      was_error = true;
      cerr << error->message << endl;
    }
  }
  if (!was_error)
    g_markup_parse_context_free (context);
  current_element.clear();
  current_value.clear();
  
  // Prevents editor from becoming invisible altogether, prompting users to ask for support.
  if (vpane_footnotes_position < 100) vpane_footnotes_position = 100;
  // Same for references.
  if (vpane_references_position < 100) vpane_references_position = 100;
}


ustring OldConfiguration::bibleditrc ()
{
  // Returns the full name of the ~/<root>/settings configuration file.
  // E.g.: /home/joe/.bibledit/settings
  return gw_build_filename (directories_get_root (), "settings");
}


vector<ustring> OldConfiguration::printing_fonts_get ()
{
  ReadText rt (fontfilename (), true);
  return rt.lines;
}


void OldConfiguration::printing_fonts_set (vector<ustring>& fonts)
{
  write_lines (fontfilename (), fonts);
}


vector<ustring> OldConfiguration::parallel_bible_projects_get ()
{
  ReadText rt (parallel_bible_projects_filename (), true);
  return rt.lines;
}


void OldConfiguration::parallel_bible_projects_set (vector<ustring>& fonts)
{
  write_lines (parallel_bible_projects_filename (), fonts);
}


ustring OldConfiguration::configurationfilename ()
{
  return gw_build_filename (directories_get_configuration (), "configuration.xml");
}


ustring OldConfiguration::fontfilename ()
{
  return gw_build_filename (directories_get_root (), "settings-fonts");
}


ustring OldConfiguration::parallel_bible_projects_filename ()
{
  return gw_build_filename (directories_get_root (), "parallel-bible-projects");
}


void OldConfiguration::start_element_handler (GMarkupParseContext *context,
                                           const gchar         *element_name,
                                           const gchar        **attribute_names,
                                           const gchar        **attribute_values,
                                           gpointer             user_data,
                                           GError             **error)
{
  ustring element;
  element = element_name;
  ((OldConfiguration *) user_data)->start_element_handler (element);
}


void OldConfiguration::end_element_handler (GMarkupParseContext *context,
                                         const gchar         *element_name,
                                         gpointer             user_data,
                                         GError             **error)
{
  ustring element;
  element = element_name;
  ((OldConfiguration *) user_data)->end_element_handler (element);
}


void OldConfiguration::text_handler (GMarkupParseContext *context,
                                  const gchar         *text,
                                  gsize                text_len,
                                  gpointer             user_data,
                                  GError             **error)
{
  ustring utext;
  utext = text;
  ((OldConfiguration *) user_data)->text_handler (utext);
}



void OldConfiguration::passthrough_handler    (GMarkupParseContext *context,
                                            const gchar         *passthrough_text,
                                            gsize                text_len,
                                            gpointer             user_data,
                                            GError             **error)
{
}


void OldConfiguration::error_handler          (GMarkupParseContext *context,
                                            GError              *error,
                                            gpointer             user_data)
{
  cerr << error->message << endl;
}


void OldConfiguration::start_element_handler (const ustring& element_name)
{
  current_element = element_name;
  current_value.clear();
}


void OldConfiguration::end_element_handler (const ustring& element_name)
{
  if (current_element == INSERT_FOOTNOTE_TEMPLATE)
    insert_footnote_template = current_value;
  if (current_element == INSERT_ENDNOTE_TEMPLATE)
    insert_endnote_template = current_value;
  if (current_element == INSERT_XREF_TEMPLATE)
    insert_xref_template = current_value;
  
  if (current_element == CATEGORY_EXPANDED_0)
    category_expanded_0 = convert_to_bool (current_value);
  if (current_element == CATEGORY_EXPANDED_1)
    category_expanded_1 = convert_to_bool (current_value);
  if (current_element == CATEGORY_EXPANDED_2a)
    category_expanded_2a = convert_to_bool (current_value);
  if (current_element == CATEGORY_EXPANDED_2b)
    category_expanded_2b = convert_to_bool (current_value);
  if (current_element == CATEGORY_EXPANDED_2c)
    category_expanded_2c = convert_to_bool (current_value);
  if (current_element == CATEGORY_EXPANDED_3)
    category_expanded_3 = convert_to_bool (current_value);
  if (current_element == CATEGORY_EXPANDED_4)
    category_expanded_4 = convert_to_bool (current_value);
  if (current_element == CATEGORY_EXPANDED_5)
    category_expanded_5 = convert_to_bool (current_value);
  if (current_element == CATEGORY_EXPANDED_6)
    category_expanded_6 = convert_to_bool (current_value);
  if (current_element == CATEGORY_EXPANDED_7)
    category_expanded_7 = convert_to_bool (current_value);
  if (current_element == CATEGORY_EXPANDED_8)
    category_expanded_8 = convert_to_bool (current_value);
  if (current_element == CATEGORY_EXPANDED_9)
    category_expanded_9 = convert_to_bool (current_value);
  if (current_element == CATEGORY_EXPANDED_10)
    category_expanded_10 = convert_to_bool (current_value);
  if (current_element == CATEGORY_EXPANDED_11)
    category_expanded_11 = convert_to_bool (current_value);
  if (current_element == CATEGORY_EXPANDED_12)
    category_expanded_12 = convert_to_bool (current_value);
  if (current_element == CATEGORY_EXPANDED_13)
    category_expanded_13 = convert_to_bool (current_value);

  if (current_element == PRINT_HIGH_QUALITY)
    print_high_quality = convert_to_bool (current_value);
  if (current_element == NOTES_PRINT_FULL_PAGE_WIDTH)
    notes_print_full_page_width = convert_to_bool (current_value);

  if (current_element == EXPORT_TO_BIBLEWORKS_FILENAME)
    export_to_bibleworks_filename = current_value;
  if (current_element == EXPORT_TO_SWORD_INSTALL_PATH)
    export_to_sword_install_path = current_value;
  if (current_element == EXPORT_TO_SWORD_MODULE_PATH)
    export_to_sword_module_path = current_value;

  if (current_element == PARALLEL_BIBLE_KEEP_VERSES_TOGETHER)
    parallel_bible_keep_verses_together = convert_to_bool (current_value);
  if (current_element == PARALLEL_BIBLE_CHAPTES_VERSES)
    parallel_bible_chapters_verses = current_value;
  if (current_element == PARALLEL_BIBLE_INCLUDE_VERSE_0)
    parallel_bible_include_verse_zero = convert_to_bool (current_value);

  if (current_element == VPANE_FOOTNOTES_POSITION)
    vpane_footnotes_position = convert_to_int (current_value);
  if (current_element == VPANE_REFERENCES_POSITION)
    vpane_references_position = convert_to_int (current_value);
  if (current_element == TOOLS_AREA_LEFT)
    tools_area_left = convert_to_bool (current_value);

  if (current_element == BIBLEWORKS_EXECUTABLE)
    bibleworks_executable = current_value;
  if (current_element == REFERENCE_EXCHANGE_SEND_TO_SANTAFEFOCUS)
    reference_exchange_send_to_santafefocus = convert_to_bool (current_value);
  if (current_element == REFERENCE_EXCHANGE_RECEIVE_FROM_SANTAFEFOCUS)
    reference_exchange_receive_from_santafefocus = convert_to_bool (current_value);

  if (current_element == NOTES_SHOW_PROJECT)
    notes_show_project = convert_to_bool (current_value);

  current_element.clear();
  current_value.clear();
}


void OldConfiguration::text_handler (const ustring& text)
{
  current_value.append (text);
}


// Move whole configuration to xml. Test it per move. 
// Make smooth move: read old config, and transfer the value to the new.
// Then after some releases take out the old system, as it can be expected everybody has moved.
