/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_PROJECTCONFIGURATION_H
#define INCLUDED_PROJECTCONFIGURATION_H


#include "libraries.h"
#include "constants.h"
#include "sqlite3.h"
#include "generalconfig.h"


void project_configuration_vacuum (const ustring& project, unsigned int starttime);
ustring project_configuration_filename (const ustring& project);
void upgrade_project_configuration (const ustring& project);


class ProjectConfiguration
// Manages program settings.
{
public:
  ProjectConfiguration (ustring project);
  ~ProjectConfiguration ();
  ustring value_get (const ustring& key, const ustring& standard);
  void value_set (const ustring& key, const ustring& value);
  vector<ustring> valuelist_get (const ustring& key);
  void valuelist_set (const ustring& key, const vector<ustring>& value);
private:
  ustring editor_font_key ();
public:
  ustring editor_font ();
  void editor_font_set (ustring value);
private:
  ustring stylesheet_key ();
public:
  ustring stylesheet ();
  void stylesheet_set (ustring value);
private:
  ustring versification_key ();
public:
  ustring versification ();
  void versification_set (ustring value);
private:
  ustring printing_fonts_key ();
public:
  vector<ustring> printing_fonts ();
  void printing_fonts_set (vector<ustring> value);
private:
  ustring printing_font_size_key ();
public:
  int printing_font_size ();
  void printing_font_size_set (int value);
private:
  ustring printing_line_height_key ();
public:
  int printing_line_height ();
  void printing_line_height_set (int value);
private:
  ustring sword_name_key ();
public:
  ustring sword_name ();
  void sword_name_set (ustring value);
private:
  ustring sword_description_key ();
public:
  ustring sword_description ();
  void sword_description_set (ustring value);
private:
  ustring sword_about_key ();
public:
  ustring sword_about ();
  void sword_about_set (ustring value);
private:
  ustring sword_lcsh_key ();
public:
  ustring sword_lcsh ();
  void sword_lcsh_set (ustring value);
private:
  ustring sword_license_key ();
public:
  ustring sword_license ();
  void sword_license_set (ustring value);
private:
  ustring sword_version_key ();
public:
  ustring sword_version ();
  void sword_version_set (ustring value);
private:
  ustring sword_language_key ();
public:
  ustring sword_language ();
  void sword_language_set (ustring value);
private:
  ustring reordered_books_key ();
public:
  vector<ustring> reordered_books ();
  void reordered_books_set (vector<ustring> value);
private:
  ustring reordered_includes_key ();
public:
  vector<bool> reordered_includes ();
  void reordered_includes_set (vector<bool> value);
private:
  ustring reordered_portions_key ();
public:
  vector<ustring> reordered_portions ();
  void reordered_portions_set (vector<ustring> value);
private:
  sqlite3 *db;
  int rc;
  char *error;
  void create (const ustring& filename);
  bool bool_get (const ustring& id, bool standard);
  void bool_set (const ustring& id, bool value);
  int int_get (const ustring& id, int standard);
  void int_set (const ustring& id, int value);
  ustring string_get (const ustring& id, const ustring& standard);
  void string_set (const ustring& id, const ustring& value);
  double double_get (const ustring& id, double standard);
  void double_set (const ustring& id, double value);
  vector<bool> vector_bool_get (const ustring& id);
  void vector_bool_set (const ustring& id, const vector<bool>& value);
  vector<ustring> vector_string_get (const ustring& id);
  void vector_string_set (const ustring& id, const vector<ustring>& value);
  GeneralConfiguration genconfig;
};


#endif
