/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __KOZO_FIELD_H__
#define __KOZO_FIELD_H__

#include <glib.h>
#include <time.h>

#include <kozo-types.h>

KozoField    *kozo_field_new_string       (int         field_id,
                                           const char *value);
KozoField    *kozo_field_new_int          (int         field_id,
                                           gint32      value);
KozoField    *kozo_field_new_time         (int         field_id,
                                           time_t      value);

KozoField    *kozo_field_new_string_list  (int         field_id,
                                           GSList     *values);
KozoField    *kozo_field_new_int_list     (int         field_id,
                                           GSList     *values);
KozoField    *kozo_field_new_time_list    (int         field_id,
                                           GSList     *values);

int           kozo_field_get_id           (KozoField  *field);
const guint8 *kozo_field_get_raw_data     (KozoField  *field,
                                           guint32    *length);

guint32       kozo_field_get_value_count  (KozoField  *field);
const char   *kozo_field_get_value_string (KozoField  *field,
                                           int         n);
gint32        kozo_field_get_value_int    (KozoField  *field,
                                           int         n);
time_t        kozo_field_get_value_time   (KozoField  *field,
                                           int         n);

void          kozo_field_free             (KozoField  *field);

void kozo_field_list_free (GSList *field_list);

#endif /* __KOZO_FIELD_H__ */
