/** 
 * @namespace   biew
 * @file        biewutil.h
 * @brief       This file contains prototypes of BIEW utilities.
 * @version     -
 * @remark      this source file is part of Binary vIEW project (BIEW).
 *              The Binary vIEW (BIEW) is copyright (C) 1995 Nick Kurshev.
 *              All rights reserved. This software is redistributable under the
 *              licence given in the file "Licence.en" ("Licence.ru" in russian
 *              translation) distributed in the BIEW archive.
 * @note        Requires POSIX compatible development system
 *
 * @author      Nick Kurshev
 * @since       1995
 * @note        Development, fixes and improvements
**/
#ifndef __BIEWUTIL__H
#define __BIEWUTIL__H

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __TWIN_H
#include "biewlib/twin.h"
#endif

#ifndef __BBIO_H
#include "biewlib/bbio.h"
#endif

#ifndef __FILE_INI_RUNTIME_SUPPORT_SYSTEM__
#include "biewlib/file_ini.h"
#endif

#define NOT_EXE 0
#define DOS_SYS 1
#define OLD_EXE 2
#define NEW_EXE 3

typedef struct tagDOSDRIVER
{
  uint16_t ddAttribute;
  uint16_t ddStrategyOff;
  uint16_t ddInterruptOff;
  uint8_t  ddName[8];
}DOSDRIVER;

typedef struct tagMZHEADER
{
 uint16_t mzPartLastPage;
 uint16_t mzPageCount;
 uint16_t mzRelocationCount;
 uint16_t mzHeaderSize;
 uint16_t mzMinMem;
 uint16_t mzMaxMem;
 uint16_t mzRelocationSS;
 uint16_t mzExeSP;
 uint16_t mzCheckSumm;
 uint16_t mzExeIP;
 uint16_t mzRelocationCS;
 uint16_t mzTableOffset;
 uint16_t mzOverlayNumber;
}MZHEADER;

typedef union tagDOSHDR
{
  DOSDRIVER                 drv;
  MZHEADER                  mz;
}DOSHDR;

extern DOSHDR oldh;

extern char legalchars[];
extern char FType;
extern unsigned long headshift;
extern tBool DumpMode;
extern tBool EditMode;

extern unsigned long lastbyte;
extern char * ini_name;

extern int   __FASTCALL__ GetBool(tBool _bool);
extern void **            FAllocPtrPtr(unsigned num);
extern void *             FAllocPtr(unsigned size);
extern void               FFreeArr(void **arr,unsigned n);
extern void               CriticalExit(int code);

extern void               init_addons(void);
extern void               term_addons(void);
extern void               SelectTool( void );
extern void               init_sysinfo( void );
extern void               term_sysinfo( void );
extern void               SelectSysInfo( void );
                          /** return True if LastOpenFile == Current open file */
extern tBool              isValidIniArgs( void ); 

extern tBool              NewSource( void );
extern tBool              FileUtils( void );
extern unsigned long      IsNewExe(void);

extern char * __FASTCALL__ Get2Digit(unsigned char);
extern char * __FASTCALL__ Get2SignDig(signed char);
extern char * __FASTCALL__ Get4Digit(unsigned short);
extern char * __FASTCALL__ Get4SignDig(signed short);
extern char * __FASTCALL__ Get8Digit(unsigned long);
extern char * __FASTCALL__ Get8SignDig(signed long);
extern char * __FASTCALL__ Get2DigitS(unsigned char *);
extern char * __FASTCALL__ Get4DigitS(unsigned char *);
extern char * __FASTCALL__ Get8DigitS(unsigned char *);
extern char * __FASTCALL__ GetBinary(char val);

extern int      __FASTCALL__ ExpandHex(char * dest,const unsigned char * src,int size,char hard);
extern void     __FASTCALL__ CompressHex(unsigned char * dest,const char * src,int sizedest,tBool usespace);
extern unsigned __FASTCALL__ Summ(unsigned char *array,unsigned size);

extern void   ExtHelp(void);
extern void   drawEditPrompt( void );
extern void   drawEmptyPrompt( void );
extern void   drawEmptyListPrompt( void );
extern void   drawAsmEdPrompt( void );
extern void   drawListPrompt( void );
extern void   drawOrdListPrompt( void );
extern void   drawSearchListPrompt( void );
extern void   drawHelpPrompt( void );
extern void   drawHelpListPrompt( void );
extern void   drawPrompt( void );
extern void   About( void );

extern unsigned long __FASTCALL__ WhereAMI(unsigned long ctrl_pos);

#define RAPREF_NONE            0 /**< means reference is not appended */
#define RAPREF_PROCEEDCMT      1 /**< means reference is appended, but it possible to proceed commentaries */
#define RAPREF_DONE            2 /**< means reference is appended */

                   /** Appends disassembler reference to string.
                     * @param str          string buffer for append to
                     * @param ulShift      physical address of field, that required of binding
                     * @param mode         see reg_form.h for detail
                     * @param codelen      length of field, that required binding
                     * @param r_shift      used only if APPREF_TRY_LABEL mode is set, contains real value of field, that required binding
                     * @return             one of RAPREF_* constants
                    **/
extern int __FASTCALL__ AppendAsmRef(char *str,unsigned long ulShift,
                                     int mode,char codelen,
                                     unsigned long r_shift);


extern void  ShowSysInfo( void );
extern unsigned long ShowSysHeader( void );
extern unsigned long ShowMZHeader( void );

extern void  PaintTitle( void );
extern void  MainLoop( void );

extern unsigned long FoundTextSt,FoundTextEnd;
extern int  __FASTCALL__ isHOnLine(unsigned long cp,int width);

#define HLS_NORMAL               0x0000
#define HLS_USE_DOUBLE_WIDTH     0x0001
#define HLS_USE_BUFFER_AS_VIDEO  0x0002

typedef union tag_HLInfo
{
  const char     *text;
  tvioBuff        buff;
}HLInfo;

extern void __FASTCALL__ HiLightSearch(TWindow *out,unsigned long cfp,char minx,
                          char maxx,char y,HLInfo *buff,unsigned flags);

extern unsigned long __FASTCALL__ Search( tBool mod );


/** Class memory array */

typedef struct tag_memArray
{
  void **  data;
  unsigned nItems;
  unsigned nSize;
}memArray;

extern memArray *__FASTCALL__ ma_Build( int maxitems, tBool interact );
extern tBool     __FASTCALL__ ma_AddString(memArray *obj,const char *data,tBool interact);
extern tBool     __FASTCALL__ ma_AddData(memArray *obj,const void *data,unsigned size,tBool interact);
extern void      __FASTCALL__ ma_Destroy(memArray *obj);
extern int       __FASTCALL__ ma_Display(memArray *obj,const char *title,int flg,unsigned defsel);

extern unsigned __FASTCALL__ biewReadProfileString(hIniProfile *ini,
                                      const char *section,
                                      const char *subsection,
                                      const char *_item,
                                      const char *def_value,
                                      char *buffer,
                                      unsigned cbBuffer);

extern tBool __FASTCALL__ biewWriteProfileString(hIniProfile *ini,
                                                 const char *section,
                                                 const char *subsection,
                                                 const char *item,
                                                 const char *value);

#ifdef __cplusplus
}
#endif

#endif
