/** 
 * @namespace   biew
 * @file        setup.c
 * @brief       This file contains BIEW setup.
 * @version     -
 * @remark      this source file is part of Binary vIEW project (BIEW).
 *              The Binary vIEW (BIEW) is copyright (C) 1995 Nick Kurshev.
 *              All rights reserved. This software is redistributable under the
 *              licence given in the file "Licence.en" ("Licence.ru" in russian
 *              translation) distributed in the BIEW archive.
 * @note        Requires POSIX compatible development system
 *
 * @author      Nick Kurshev
 * @since       1999
 * @note        Development, fixes and improvements
**/
#include <string.h>
#include <stdio.h>

#include "biewhelp.h"
#include "colorset.h"
#include "setup.h"
#include "bconsole.h"
#include "biewutil.h"
#include "biewlib/twin.h"
#include "biewlib/kbd_code.h"

extern char biew_help_name[];
extern char biew_skin_name[];

extern unsigned long biew_vioIniFlags;
extern unsigned long biew_twinIniFlags;
extern unsigned long biew_kbdFlags;
extern tBool iniSettingsAnywhere;

char * biewGetHelpName( void )
{
  if(!biew_help_name[0])
  {
    strcpy(biew_help_name,__get_rc_dir("biew"));
    strcat(biew_help_name,"biew.hlp");
  }
  return biew_help_name;
}

static char * __NEAR__ __FASTCALL__ biewGetColorSetName( void )
{
  if(!biew_skin_name[0])
  {
    strcpy(biew_skin_name,__get_rc_dir("biew"));
    strcat(biew_skin_name,"standard.skn");
  }
  return biew_skin_name;
}

static void __NEAR__ __FASTCALL__ setup_paint( TWindow *twin )
{
  TWindow *usd;
  usd = twUsedWin();
  twUseWin(twin);
  twSetColorAttr(dialog_cset.group.active);
  twGotoXY(2,6);
  twPrintF(" [%c] - Direct console access "
           ,GetBool((biew_vioIniFlags & __TVIO_FLG_DIRECT_CONSOLE_ACCESS) == __TVIO_FLG_DIRECT_CONSOLE_ACCESS));
  twGotoXY(2,7);
  twPrintF(" [%c] - Mouse sensitivity     "
           ,GetBool((biew_kbdFlags & KBD_NONSTOP_ON_MOUSE_PRESS) == KBD_NONSTOP_ON_MOUSE_PRESS));
  twGotoXY(2,8);
  twPrintF(" [%c] - Force mono            "
           ,GetBool((biew_twinIniFlags & TWIF_FORCEMONO) == TWIF_FORCEMONO));
  twGotoXY(2,9);
  twPrintF(" [%c] - Force 7-bit output    "
           ,GetBool((biew_vioIniFlags & __TVIO_FLG_USE_7BIT) == __TVIO_FLG_USE_7BIT));
  twGotoXY(32,6);
  twPrintF(" [%c] - Apply plugins settings to all files    "
           ,GetBool(iniSettingsAnywhere));
  twSetColorAttr(dialog_cset.main);
  twUseWin(usd);
}

void Setup(void)
{
  tAbsCoord x1,y1,x2,y2;
  tRelCoord X1,Y1,X2,Y2;
  int ret;
  TWindow * wdlg,*ewnd[2];
  char estr[2][FILENAME_MAX+1];
  int active = 0;
  strcpy(estr[0],biewGetHelpName());
  strcpy(estr[1],biewGetColorSetName());
  wdlg = CrtDlgWndnls(" Setup ",78,10);
  twGetWinPos(wdlg,&x1,&y1,&x2,&y2);
  X1 = x1;
  Y1 = y1;
  X2 = x2;
  Y2 = y2;
  twSetFooterAttr(wdlg," [F2] - Console [F3] - Color [F4] - Mouse [F5] - Bit [F6] - Plugin ",TW_TMODE_CENTER,dialog_cset.footer);
  twinDrawFrameAttr(1,5,78,10,TW_UP3D_FRAME,dialog_cset.main);
  X1 += 2;
  X2 -= 2;
  Y1 += 2;
  Y2 = Y1;
  ewnd[0] = CreateEditor(X1,Y1,X2,Y2,TWS_CURSORABLE | TWS_NLSOEM);
  twUseWin(wdlg);
  twGotoXY(2,1); twPutS("Input fully qualified help name:");
  twShowWin(ewnd[0]);
  Y1 += 2;
  Y2 = Y1;
  ewnd[1] = CreateEditor(X1,Y1,X2,Y2,TWS_CURSORABLE | TWS_NLSOEM);
  twUseWin(wdlg);
  twGotoXY(2,3); twPutS("Input fully qualified color set name:");
  twShowWin(ewnd[1]);
  twUseWin(ewnd[1]);
  PostEvent(KE_ENTER);
  xeditstring(estr[1],NULL,sizeof(estr[1]));
  active = 0;
  twUseWin(ewnd[active]);
  setup_paint(wdlg);
  while(1)
  {
   ret = xeditstring(estr[active],NULL,sizeof(estr[active]));
   switch(ret)
   {
     case KE_F(10):
     case KE_ESCAPE: ret = 0; goto exit;
     case KE_ENTER: ret = 1; goto exit;
     case KE_TAB:   active = active ? 0 : 1;
                    twUseWin(ewnd[active]);
                    continue;
     case KE_F(1):  hlpDisplay(5);
                    break;
     case KE_F(2):  biew_vioIniFlags ^= __TVIO_FLG_DIRECT_CONSOLE_ACCESS;
                    break;
     case KE_F(3):  biew_twinIniFlags ^= TWIF_FORCEMONO ;
                    break;
     case KE_F(4):  biew_kbdFlags ^= KBD_NONSTOP_ON_MOUSE_PRESS;
                    break;
     case KE_F(5):  biew_vioIniFlags ^= __TVIO_FLG_USE_7BIT;
                    break;
     case KE_F(6):  iniSettingsAnywhere = iniSettingsAnywhere ? False : True;
                    break;
     default: continue;
   }
   setup_paint(wdlg);
  }
  exit:
  if(ret)
  {
    strcpy(biew_help_name,estr[0]);
    strcpy(biew_skin_name,estr[1]);
  }
  CloseWnd(ewnd[0]);
  CloseWnd(ewnd[1]);
  CloseWnd(wdlg);
}
