/*
 * Biloba
 * Copyright (C) 2004-2008 Guillaume Demougeot, Colin Leroy
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

/**
 * Biloba - Q1 2005
	* Game by Guillaume Demougeot <dmgt@wanadoo.fr>
	* Code by Colin Leroy <colin@colino.net>
	*
	* Our single-linked-list implementation, done to
	* avoid a dependancy to another library.
	*/

#include <stdlib.h>
#include "llist.h"

LList *llist_append(LList *list, void *data)
{
	LList *result = malloc(sizeof(LList));
	LList *orig = list;
	result->data = data;
	result->next = NULL;
	if (list) {
		while(list->next)
			list = list->next;
		list->next = result;
		return orig;
	} 

	return result;
}

LList *llist_prepend(LList *list, void *data)
{
	LList *result = malloc(sizeof(LList));
	result->data = data;
	result->next = list;
	return result;
}

LList *llist_remove(LList *list, void *data)
{
	LList *result = list;
	if (!list)
		return NULL;
	
	if (list->data == data) {
		result = list->next;
		free(list);
		return result;
	}
	
	while (list) {
		if (list->next && list->next->data == data) {
			LList *tmp = list->next;
			list->next = list->next->next;
			free(tmp);
			return result;
		}
		list = list->next;
	}
	return result;
}

LList *llist_find(LList *list, void *data)
{
	while(list) {
		if (list->data == data)
			return list;
		list = list->next;
	}
	return NULL;
}

void llist_free(LList *list)
{
	while (list) {
		LList *next = list->next;
		free(list);
		list = next;
	}
}

int llist_length(LList *list)
{
	int cnt = 0;
	while (list) {
		cnt++;
		list = list->next;
	}
	return cnt;
}
