option add *HighlightThickness		0
option add *Tile			bgTexture
option add *Button.Tile			""

image create photo bgTexture -file ./images/chalk.gif

set configOptions {
    InvertXY			no
    Axis.TickFont		{ Helvetica 18 bold }
    Axis.TitleFont		{ Helvetica 12 bold }
    BorderWidth			2
    Element*Pixels		2.75m
    Element.ScaleSymbols	true
    Font			{ Helvetica 24 bold }
    Foreground			white
    Legend.ActiveBorderWidth	2
    Legend.ActiveRelief		raised
    Legend.Anchor		ne
    Legend.BorderWidth		0
    Legend.Font			{ Helvetica 34 }
    Legend.Foreground		orange
    Legend.Position		plotarea
    Legend.Relief		flat
    Postscript.Preview		yes
    Relief			raised
    Shadow			{ navyblue 2 }
    Title			"Bitmap Symbols" 
    degrees.Command		formatXLabels 
    degrees.LimitsFormat	"Deg=%g"
    degrees.Subdivisions	0 
    degrees.Title		"Degrees" 
    degrees.stepSize		90 
    temp.LimitsFormat		"Temp=%g"
    temp.Title			"Temperature"
    y.Color			purple2
    y.LimitsFormat		"Y=%g"
    y.Rotate			90 
    y.Title			"Y" 
    y.loose			no
    y2.Color			magenta3
    y2.Hide			no
    xy2.Rotate			270
    y2.Rotate			0
    y2.Title			"Y2" 
    y2.LimitsFormat		"Y2=%g"
    x2.LimitsFormat		"x2=%g"
}

set resource [string trimleft $graph .]
foreach { option value } $configOptions {
    option add *$resource.$option $value
}

graph $graph

proc formatXLabels {graph x} {
     format "%d%c" [expr int($x)] 0xB0
}

set max -1.0
set step 0.2

set letters { A B C D E F G H I J K L }
set count 0
for { set level 30 } { $level <= 100 } { incr level 10 } {
    set color [format "#dd0d%0.2x" [expr round($level*2.55)]]
    bitmap compose symbol$count [lindex $letters $count] \
    	-font -*-helvetica-medium-r-*-*-34-*-*-*-*-*-*-*
    $graph pen create style$level -color $color -symbol symbol$count \
	-fill "" -pixels 6m
    set min $max
    set max [expr $max + $step]
    lappend styles "style$level $min $max"
    incr count
}


$graph axis create temp -color lightgreen -title Temp  -min -0.5 -max 0.5
$graph axis create degrees -rotate 90
$graph xaxis use degrees

set tcl_precision 15
set pi1_2 [expr 3.14159265358979323846/180.0]

vector create w x sinX cosX radians
x seq -360.0 360.0 10.0
radians expr { x * $pi1_2 }
sinX expr sin(radians)
cosX expr cos(radians)
cosX dup w
vector destroy radians

$graph element create line1 \
    -color orange \
    -outline black \
    -fill orange \
    -fill yellow \
    -label "sin(x)" \
    -linewidth 3 \
    -mapx degrees \
    -pixels 6m \
    -symbol "@bitmaps/hobbes.xbm @bitmaps/hobbes_mask.xbm" \
    -xdata x \
    -ydata sinX

$graph element create line2 \
    -color green4 \
    -fill green \
    -label "cos(x)" \
    -mapx degrees \
    -styles $styles \
    -weights w \
    -xdata x \
    -ydata cosX 


Blt_ZoomStack $graph
Blt_Crosshairs $graph
#Blt_ActiveLegend $graph
Blt_ClosestPoint $graph
Blt_PrintKey $graph

