/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2005-2006  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <dbus/dbus-glib.h>

#include "adapter.h"

#define BLUETOOTH_ADAPTER_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE((obj), \
				BLUETOOTH_TYPE_ADAPTER, BluetoothAdapterPrivate))

typedef struct _BluetoothAdapterPrivate BluetoothAdapterPrivate;

struct _BluetoothAdapterPrivate {
	gchar *address;

	GList *devices;
};

G_DEFINE_TYPE(BluetoothAdapter, bluetooth_adapter, G_TYPE_OBJECT)

static void bluetooth_adapter_init(BluetoothAdapter *self)
{
	BluetoothAdapterPrivate *priv = BLUETOOTH_ADAPTER_GET_PRIVATE(self);

	priv->address = NULL;
}

static void bluetooth_adapter_finalize(GObject *object)
{
	BluetoothAdapterPrivate *priv = BLUETOOTH_ADAPTER_GET_PRIVATE(object);

	g_free(priv->address);
}

static void bluetooth_adapter_set_property(GObject *object, guint prop_id,
					const GValue *value, GParamSpec *pspec)
{
	switch (prop_id) {
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
		break;
	}
}

static void bluetooth_adapter_get_property(GObject *object, guint prop_id,
					GValue *value, GParamSpec *pspec)
{
	switch (prop_id) {
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
		break;
	}
}

static void bluetooth_adapter_class_init(BluetoothAdapterClass *klass)
{
	g_type_class_add_private(klass, sizeof(BluetoothAdapterPrivate));

	G_OBJECT_CLASS(klass)->finalize = bluetooth_adapter_finalize;

	G_OBJECT_CLASS(klass)->set_property = bluetooth_adapter_set_property;
	G_OBJECT_CLASS(klass)->get_property = bluetooth_adapter_get_property;
}

BluetoothAdapter *bluetooth_adapter_new(void)
{
	return g_object_new(BLUETOOTH_TYPE_ADAPTER, NULL);
}
