-- Haskell data types for the abstract syntax.
-- Generated by the BNF converter.

{-# LANGUAGE DeriveDataTypeable #-}
{-# LANGUAGE DeriveGeneric #-}

module AbsBNF where

import Data.Data    (Data, Typeable)
import GHC.Generics (Generic)

newtype Ident = Ident String
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

data LGrammar = LGr [LDef]
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

data LDef = DefAll Def | DefSome [Ident] Def | LDefView [Ident]
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

data Grammar = Grammar [Def]
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

data Def
    = Rule Label Cat [Item]
    | Comment String
    | Comments String String
    | Internal Label Cat [Item]
    | Token Ident Reg
    | PosToken Ident Reg
    | Entryp [Ident]
    | Separator MinimumSize Cat String
    | Terminator MinimumSize Cat String
    | Delimiters Cat String String Separation MinimumSize
    | Coercions Ident Integer
    | Rules Ident [RHS]
    | Function Ident [Arg] Exp
    | Layout [String]
    | LayoutStop [String]
    | LayoutTop
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

data Item = Terminal String | NTerminal Cat
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

data Cat = ListCat Cat | IdCat Ident
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

data Label
    = LabNoP LabelId
    | LabP LabelId [ProfItem]
    | LabPF LabelId LabelId [ProfItem]
    | LabF LabelId LabelId
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

data LabelId = Id Ident | Wild | ListE | ListCons | ListOne
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

data ProfItem = ProfIt [IntList] [Integer]
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

data IntList = Ints [Integer]
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

data Arg = Arg Ident
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

data Separation = SepNone | SepTerm String | SepSepar String
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

data Exp
    = Cons Exp Exp
    | App Ident [Exp]
    | Var Ident
    | LitInt Integer
    | LitChar Char
    | LitString String
    | LitDouble Double
    | List [Exp]
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

data RHS = RHS [Item]
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

data MinimumSize = MNonempty | MEmpty
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

data Reg
    = RSeq Reg Reg
    | RAlt Reg Reg
    | RMinus Reg Reg
    | RStar Reg
    | RPlus Reg
    | ROpt Reg
    | REps
    | RChar Char
    | RAlts String
    | RSeqs String
    | RDigit
    | RLetter
    | RUpper
    | RLower
    | RAny
  deriving (Eq, Ord, Show, Read, Data, Typeable, Generic)

