#! /bin/sh
# MILO disk maker.  David Huggins-Daines, February 2000
# This is free software under the GNU General Public License

. ./common.sh

if [ $# -lt 2 ]; then
    echo "Usage: $0 image-name outfile" 1>&2
    exit 1
fi

# Name of the MILO image to use
image=$1

# File to output
outfile=$2

testroot

[ -f $image ] || error "can't find $image"
[ -f linload.exe ] || error "can't find linload.exe"

if ! command -v srmbootfat >/dev/null 2>&1; then
    error "can't find srmbootfat - it's in the MILO source, build it... sorry"
fi

floppy=$(tempfile -p milo -m 644)
size=720 # This is the smallest size that can hold MILO which srmbootfat will accept
mnt=${tmpdir}/boot-floppies/mnt.milo
make_tmpdir $mnt
trap "umount $mnt 2>/dev/null || true ; rmdir $mnt || true; rm -f $floppy" 0 1 2 15

info "making loop filesystem in $floppy, size $size"
dd if=/dev/zero of=$floppy bs=1k count=$size

mkdosfs -r 112 -F 12 $floppy $size
mount $floppy -o loop -t msdos $mnt

cp $image      $mnt/milo
cp linload.exe $mnt/
umount $mnt
srmbootfat $floppy milo
cp $floppy $outfile
