/* vi: set sw=4 ts=4: */
#include <stdio.h>
#include "dbootstrap.h"
#include "util.h"
#include "lang.h"

#ifdef _TESTING_
#define supported_filesystem(x) 1
#endif

#ifdef NFSROOT
static struct fdisk_partition* select_NFS_server(void);
#endif

struct fdisk_partition *
select_not_mounted( const char *message, const char *title, int ntypes, ... ) {
	struct fdisk_partition *p,**plist;
	struct d_choices *choices;
	va_list argp;
	char *name, *fstypes_list=NULL;
	int fstype,rs,i,items=0;
#ifdef NFSROOT
	int addnfs=0;
#endif

	choices=malloc(5*sizeof(struct d_choices));
	plist=malloc(5*sizeof(struct fdisk_partition *));

	if (ntypes) {
		va_start (argp, ntypes); 
		for (i = 0; i < ntypes; i++) {
			fstype= va_arg(argp, int);		
			if (fstype==FSTYPE_EXTPART) {
				name="extended";
			} else {
				name = fstype_name[fstype];
			}
#ifdef NFSROOT
			if (fstype == FSTYPE_NFS) {
				addnfs=1;
			} else 
#endif
			{
				p = fdisk_partitions_by_type[fstype];
				if (fstypes_list)
					addtolist(&fstypes_list,name);
				else
					fstypes_list = strdup(name);
				while (p) {
					if (! p->in_use){
						choices[items].tag    = p->name;
						choices[items].string = fdisk_sysname(p->type);
						choices[items].state  = 0;
						plist[items] = p;
						items++;
						if ((items%5)==0) {
							choices = realloc(choices,(items+5)*sizeof(struct d_choices));
							plist = realloc(plist,(items+5)*sizeof(struct fdisk_partition *));
						}
					}
					p = p->next_by_type;
				}
			}
		}
	} else {
/* Offer NFS only when explicitely requested */
		p = fdisk_partitions;
		while (p) {
			if (! p->in_use) {
				choices[items].tag    = p->name;
				choices[items].string = fdisk_sysname(p->type);
				choices[items].state  = 0;
				plist[items]=p;
				items++;
				if ((items%5)==0) {
					choices = realloc(choices,(items+5)*sizeof(struct d_choices));
					plist = realloc(plist,(items+5)*sizeof(struct fdisk_partition *));
				}
			}
			p = p->next;
		}
	}

#ifdef NFSROOT
	if (addnfs && is_network_up (0)) {
		choices[items].tag    = "nfs";
		choices[items].string = _("select an NFS server");
		choices[items].state  = 0;
		plist[items] = NULL;
		items++;
		if ((items % 5) == 0) {
			choices = realloc(choices, (items + 5) * sizeof(struct d_choices));
			plist = realloc(plist, (items + 5) * sizeof(struct fdisk_partition *));
		}
	}
#endif
/* FIXME Add "loop" and "manual" options. */

	p = NULL;
	if (! items){
		if (ntypes) {
			sprintf(prtbuf,_("No %s partitions that had not already been mounted were detected."),fstypes_list);
			problemBox(prtbuf,_("Problem"));
		} else {
			problemBox(_("No partitions that had not already been mounted were detected."),_("Problem"));
		}
	} else {
		rs = menuBox(message, title, choices, items, 1);
		if (rs != -1) {
			p = plist[rs];
#ifdef NFSROOT
			if ((p == NULL) && (0 == strcmp(choices[rs].tag, "nfs"))) {
				p = select_NFS_server();
			}
#endif
/* FIXME
 Fixme fixme fixme...  If you will outline what needs to be done with more verbose comments I will try to write the code...

			if (loop) select_loop blah, blah...
			if (manually) select_manually blah, blah...
*/
		}
	}

	free(plist);
	free(choices);
	return(p);
}


#ifdef NFSROOT
static struct fdisk_partition*
select_NFS_server(void)
{
	char *nfsmountpath;
	static char *preventry=NULL;
	struct fdisk_partition *p;

	if (! supported_filesystem("nfs")) {
		sprintf(prtbuf,"modprobe nfs");
		system(prtbuf);
		if(! supported_filesystem("nfs")) /* if that still didn't work... */
			return NULL;
	}
	if (! is_network_up(0)) {
	    	wideMessageBox(_("\nYou must first configure your network. Please do so now.\n"),
			_("Network configuration required"));
		if (configure_network())
		    	return NULL;
	}

	for(;;) {
		if (!preventry) preventry=strdup("");
		nfsmountpath=inputBox(_("Please choose the NFS server and the mount path of the NFS filesystem.\nEnter them in this way:  server:/path"),_("Choose NFS filesystem"),preventry);
		if (! nfsmountpath) return NULL;
		free(preventry);
		preventry=nfsmountpath;
		/* repeat the loop until the path entered is not already mounted */
		if (! fdisk_find_partition_by_name(nfsmountpath))
			break;
	}
	p=fdisk_add_partition(nfsmountpath,-1,PTYPE_NFS,0);
	return p;
}
#endif

#ifdef _TESTING_
int main() {
	LOAD_TRMFILE("test.trm");
    get_kver();
	Archive_Dir=NULL;
	disqtype=base;
	InstallationRootDevice=strdup("/dev/sdc");
    
	boxInit();
	select_not_mounted(_("Please select the partition to initialize as a Linux \"ext2\" filesystem."),_("Select Partition"),1,FSTYPE_EXT2);
	select_not_mounted(_("The root filesystem is installed in a logical partition. LILO can't boot from there, so you must install LILO in one of the following extended partitions. Please select the partition to use."),_("Select Partition"), 1,FSTYPE_EXTPART);
	select_not_mounted(_("Please select the partition where your Debian Archive resides."),_("Select Partition"), 6,FSTYPE_EXT2,FSTYPE_MINIX,FSTYPE_MSDOS,FSTYPE_AFFS,FSTYPE_HFS,FSTYPE_ADFS);
        
	boxFinished();
	return 0;
}
#endif

/*
 * Local Variables:
 * c-file-style : "linux"
 * tab-width : 4
 * End:
 */
