(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)
open OImage
open Image
open Lvshtype
open Geometry
open Ximage
open OXimage

let mime_icons = Hashtbl.create 107

let thumb_path name =
  (Filename.concat (Filename.concat (Filename.dirname name) ".xvpics")
     (Filename.basename name))

let create_xvthumb name =
  let thumbpath = thumb_path name in
  let thumbdir = Filename.dirname thumbpath in
  (* prerr_endline ("thumbdir: " ^ thumbdir); *)
  if not (Sys.file_exists thumbdir) then begin
    prerr_endline ("thumbdir creating: " ^ thumbdir);
    Unix.mkdir thumbdir 0o755
  end;

  let format, hdrs = Image.file_format name in
  let w, h, img =
    match format with
    | Jpeg -> 
	OJpeg.load_thumbnail name [] { spec_width= Pixel 80;
				       spec_height= Pixel 60;
				       spec_aspect= Keep_at_most;
				       spec_switch= Smaller_only;
				       spec_x= 0;
				       spec_y= 0 } 
    | _ ->
	let img = OImage.load name [] in
  	let w, h = img#width, img#height in
	w, h, img
  in
  let thumb = OXvthumb.create img in
  OXvthumb.save thumbpath
    (Printf.sprintf "%dx%d %s file  (%d bytes)" w h
     (match format with
      | Gif -> "GIF8x"
      | Bmp -> "BMP"
      | Tiff -> "TIFF"
      | Jpeg -> "JPEG"
      | Png -> "PNG"
      | Xpm -> "XPM"
      |	Ppm -> "PPM"
      |	_ -> "???" )
       (Unix.lstat name).Unix.st_size) thumb;
  img#destroy;
  thumb#destroy

let load_icon name typ =
  let thumb = thumb_path name in
  let inf, pixmap =
    (* XVTHUMB *)
    try
      let inf, img = OXvthumb.load thumb in
      inf, pixmap_of_image Gui.root_win None img#coerce
    with
    | _ ->
	let mj,mn = typ in
	
	try
	  if mj <> "image" then raise Exit;
	  create_xvthumb name;
	  let inf, img = OXvthumb.load thumb in
	  inf, pixmap_of_image Gui.root_win None img#coerce
	with
	| _ -> 
  	  let iconpath = 
  	    try
  	      Hashtbl.find Iconcap.table (mj,mn) 
  	    with
  	    | Not_found ->
  		Hashtbl.find Iconcap.table (mj,"*")
  	  in
  	  let iconpath = 
  	    Pathfind.find [ "."; "~/.lv"; 
  			    "/usr/share/icons/"; "/usr/share/pixmaps"] 
  	      iconpath 
  	  in
  	  
  	  (* prerr_endline ("loading "^iconpath); *)
  	  (mj^"/"^mn), 
  	  begin
  	    try
  	      Hashtbl.find mime_icons iconpath
  	    with
  	    | Not_found ->
  		let pixmap = pixmap_of_image Gui.root_win None
		    (OImage.load iconpath []) in
  		Hashtbl.add mime_icons iconpath pixmap;
  		pixmap
  	  end
  in
  inf, pixmap

