(* Capstone Disassembler Engine
 * By Nguyen Anh Quynh <aquynh@gmail.com>, 2013> *)

(* architecture specific info of instruction *)
type arm64_op_shift = {
	shift_type: int;	(* TODO: covert this to pattern like arm_op_value? *)
	shift_value: int;
}

type arm64_op_mem = {
	base: int;
	index: int;
	displ: int
}

type arm64_op_value =
	| ARM64_OP_INVALID of int
	| ARM64_OP_REG of int
	| ARM64_OP_CIMM of int
	| ARM64_OP_IMM of int
	| ARM64_OP_FP of float
	| ARM64_OP_MEM of arm64_op_mem

type arm64_op = {
	shift: arm64_op_shift;
	ext: int;
	value: arm64_op_value;
}

type cs_arm64 = {
	cc: int;
	update_flags: bool;
	writeback: bool;
	op_count: int;
	operands: arm64_op array;
}

(* ARM64 operand shift type *)
let _ARM64_SFT_INVALID = 0;;
let _ARM64_SFT_LSL = 1;;
let _ARM64_SFT_MSL = 2;;
let _ARM64_SFT_LSR = 3;;
let _ARM64_SFT_ASR = 4;;
let _ARM64_SFT_ROR = 5;;

(* ARM64 extension type (for operands) *)
let _ARM64_EXT_INVALID = 0;;
let _ARM64_EXT_UXTB = 1;;
let _ARM64_EXT_UXTH = 2;;
let _ARM64_EXT_UXTW = 3;;
let _ARM64_EXT_UXTX = 4;;
let _ARM64_EXT_SXTB = 5;;
let _ARM64_EXT_SXTH = 6;;
let _ARM64_EXT_SXTW = 7;;
let _ARM64_EXT_SXTX = 8;;

(* ARM64 code condition type *)
let _ARM64_CC_INVALID = 0;;
let _ARM64_CC_EQ = 1;;
let _ARM64_CC_NE = 2;;
let _ARM64_CC_HS = 3;;
let _ARM64_CC_LO = 4;;
let _ARM64_CC_MI = 5;;
let _ARM64_CC_PL = 6;;
let _ARM64_CC_VS = 7;;
let _ARM64_CC_VC = 8;;
let _ARM64_CC_HI = 9;;
let _ARM64_CC_LS = 10;;
let _ARM64_CC_GE = 11;;
let _ARM64_CC_LT = 12;;
let _ARM64_CC_GT = 13;;
let _ARM64_CC_LE = 14;;
let _ARM64_CC_AL = 15;;
let _ARM64_CC_NV = 16;;

(* ARM registers *)
let _ARM64_REG_INVALID = 0;;
let _ARM64_REG_NZCV = 1;;
let _ARM64_REG_WSP = 2;;
let _ARM64_REG_WZR = 3;;
let _ARM64_REG_SP = 4;;
let _ARM64_REG_XZR = 5;;
let _ARM64_REG_B0 = 6;;
let _ARM64_REG_B1 = 7;;
let _ARM64_REG_B2 = 8;;
let _ARM64_REG_B3 = 9;;
let _ARM64_REG_B4 = 10;;
let _ARM64_REG_B5 = 11;;
let _ARM64_REG_B6 = 12;;
let _ARM64_REG_B7 = 13;;
let _ARM64_REG_B8 = 14;;
let _ARM64_REG_B9 = 15;;
let _ARM64_REG_B10 = 16;;
let _ARM64_REG_B11 = 17;;
let _ARM64_REG_B12 = 18;;
let _ARM64_REG_B13 = 19;;
let _ARM64_REG_B14 = 20;;
let _ARM64_REG_B15 = 21;;
let _ARM64_REG_B16 = 22;;
let _ARM64_REG_B17 = 23;;
let _ARM64_REG_B18 = 24;;
let _ARM64_REG_B19 = 25;;
let _ARM64_REG_B20 = 26;;
let _ARM64_REG_B21 = 27;;
let _ARM64_REG_B22 = 28;;
let _ARM64_REG_B23 = 29;;
let _ARM64_REG_B24 = 30;;
let _ARM64_REG_B25 = 31;;
let _ARM64_REG_B26 = 32;;
let _ARM64_REG_B27 = 33;;
let _ARM64_REG_B28 = 34;;
let _ARM64_REG_B29 = 35;;
let _ARM64_REG_B30 = 36;;
let _ARM64_REG_B31 = 37;;
let _ARM64_REG_D0 = 38;;
let _ARM64_REG_D1 = 39;;
let _ARM64_REG_D2 = 40;;
let _ARM64_REG_D3 = 41;;
let _ARM64_REG_D4 = 42;;
let _ARM64_REG_D5 = 43;;
let _ARM64_REG_D6 = 44;;
let _ARM64_REG_D7 = 45;;
let _ARM64_REG_D8 = 46;;
let _ARM64_REG_D9 = 47;;
let _ARM64_REG_D10 = 48;;
let _ARM64_REG_D11 = 49;;
let _ARM64_REG_D12 = 50;;
let _ARM64_REG_D13 = 51;;
let _ARM64_REG_D14 = 52;;
let _ARM64_REG_D15 = 53;;
let _ARM64_REG_D16 = 54;;
let _ARM64_REG_D17 = 55;;
let _ARM64_REG_D18 = 56;;
let _ARM64_REG_D19 = 57;;
let _ARM64_REG_D20 = 58;;
let _ARM64_REG_D21 = 59;;
let _ARM64_REG_D22 = 60;;
let _ARM64_REG_D23 = 61;;
let _ARM64_REG_D24 = 62;;
let _ARM64_REG_D25 = 63;;
let _ARM64_REG_D26 = 64;;
let _ARM64_REG_D27 = 65;;
let _ARM64_REG_D28 = 66;;
let _ARM64_REG_D29 = 67;;
let _ARM64_REG_D30 = 68;;
let _ARM64_REG_D31 = 69;;
let _ARM64_REG_H0 = 70;;
let _ARM64_REG_H1 = 71;;
let _ARM64_REG_H2 = 72;;
let _ARM64_REG_H3 = 73;;
let _ARM64_REG_H4 = 74;;
let _ARM64_REG_H5 = 75;;
let _ARM64_REG_H6 = 76;;
let _ARM64_REG_H7 = 77;;
let _ARM64_REG_H8 = 78;;
let _ARM64_REG_H9 = 79;;
let _ARM64_REG_H10 = 80;;
let _ARM64_REG_H11 = 81;;
let _ARM64_REG_H12 = 82;;
let _ARM64_REG_H13 = 83;;
let _ARM64_REG_H14 = 84;;
let _ARM64_REG_H15 = 85;;
let _ARM64_REG_H16 = 86;;
let _ARM64_REG_H17 = 87;;
let _ARM64_REG_H18 = 88;;
let _ARM64_REG_H19 = 89;;
let _ARM64_REG_H20 = 90;;
let _ARM64_REG_H21 = 91;;
let _ARM64_REG_H22 = 92;;
let _ARM64_REG_H23 = 93;;
let _ARM64_REG_H24 = 94;;
let _ARM64_REG_H25 = 95;;
let _ARM64_REG_H26 = 96;;
let _ARM64_REG_H27 = 97;;
let _ARM64_REG_H28 = 98;;
let _ARM64_REG_H29 = 99;;
let _ARM64_REG_H30 = 100;;
let _ARM64_REG_H31 = 101;;
let _ARM64_REG_Q0 = 102;;
let _ARM64_REG_Q1 = 103;;
let _ARM64_REG_Q2 = 104;;
let _ARM64_REG_Q3 = 105;;
let _ARM64_REG_Q4 = 106;;
let _ARM64_REG_Q5 = 107;;
let _ARM64_REG_Q6 = 108;;
let _ARM64_REG_Q7 = 109;;
let _ARM64_REG_Q8 = 110;;
let _ARM64_REG_Q9 = 111;;
let _ARM64_REG_Q10 = 112;;
let _ARM64_REG_Q11 = 113;;
let _ARM64_REG_Q12 = 114;;
let _ARM64_REG_Q13 = 115;;
let _ARM64_REG_Q14 = 116;;
let _ARM64_REG_Q15 = 117;;
let _ARM64_REG_Q16 = 118;;
let _ARM64_REG_Q17 = 119;;
let _ARM64_REG_Q18 = 120;;
let _ARM64_REG_Q19 = 121;;
let _ARM64_REG_Q20 = 122;;
let _ARM64_REG_Q21 = 123;;
let _ARM64_REG_Q22 = 124;;
let _ARM64_REG_Q23 = 125;;
let _ARM64_REG_Q24 = 126;;
let _ARM64_REG_Q25 = 127;;
let _ARM64_REG_Q26 = 128;;
let _ARM64_REG_Q27 = 129;;
let _ARM64_REG_Q28 = 130;;
let _ARM64_REG_Q29 = 131;;
let _ARM64_REG_Q30 = 132;;
let _ARM64_REG_Q31 = 133;;
let _ARM64_REG_S0 = 134;;
let _ARM64_REG_S1 = 135;;
let _ARM64_REG_S2 = 136;;
let _ARM64_REG_S3 = 137;;
let _ARM64_REG_S4 = 138;;
let _ARM64_REG_S5 = 139;;
let _ARM64_REG_S6 = 140;;
let _ARM64_REG_S7 = 141;;
let _ARM64_REG_S8 = 142;;
let _ARM64_REG_S9 = 143;;
let _ARM64_REG_S10 = 144;;
let _ARM64_REG_S11 = 145;;
let _ARM64_REG_S12 = 146;;
let _ARM64_REG_S13 = 147;;
let _ARM64_REG_S14 = 148;;
let _ARM64_REG_S15 = 149;;
let _ARM64_REG_S16 = 150;;
let _ARM64_REG_S17 = 151;;
let _ARM64_REG_S18 = 152;;
let _ARM64_REG_S19 = 153;;
let _ARM64_REG_S20 = 154;;
let _ARM64_REG_S21 = 155;;
let _ARM64_REG_S22 = 156;;
let _ARM64_REG_S23 = 157;;
let _ARM64_REG_S24 = 158;;
let _ARM64_REG_S25 = 159;;
let _ARM64_REG_S26 = 160;;
let _ARM64_REG_S27 = 161;;
let _ARM64_REG_S28 = 162;;
let _ARM64_REG_S29 = 163;;
let _ARM64_REG_S30 = 164;;
let _ARM64_REG_S31 = 165;;
let _ARM64_REG_W0 = 166;;
let _ARM64_REG_W1 = 167;;
let _ARM64_REG_W2 = 168;;
let _ARM64_REG_W3 = 169;;
let _ARM64_REG_W4 = 170;;
let _ARM64_REG_W5 = 171;;
let _ARM64_REG_W6 = 172;;
let _ARM64_REG_W7 = 173;;
let _ARM64_REG_W8 = 174;;
let _ARM64_REG_W9 = 175;;
let _ARM64_REG_W10 = 176;;
let _ARM64_REG_W11 = 177;;
let _ARM64_REG_W12 = 178;;
let _ARM64_REG_W13 = 179;;
let _ARM64_REG_W14 = 180;;
let _ARM64_REG_W15 = 181;;
let _ARM64_REG_W16 = 182;;
let _ARM64_REG_W17 = 183;;
let _ARM64_REG_W18 = 184;;
let _ARM64_REG_W19 = 185;;
let _ARM64_REG_W20 = 186;;
let _ARM64_REG_W21 = 187;;
let _ARM64_REG_W22 = 188;;
let _ARM64_REG_W23 = 189;;
let _ARM64_REG_W24 = 190;;
let _ARM64_REG_W25 = 191;;
let _ARM64_REG_W26 = 192;;
let _ARM64_REG_W27 = 193;;
let _ARM64_REG_W28 = 194;;
let _ARM64_REG_W29 = 195;;
let _ARM64_REG_W30 = 196;;
let _ARM64_REG_X0 = 197;;
let _ARM64_REG_X1 = 198;;
let _ARM64_REG_X2 = 199;;
let _ARM64_REG_X3 = 200;;
let _ARM64_REG_X4 = 201;;
let _ARM64_REG_X5 = 202;;
let _ARM64_REG_X6 = 203;;
let _ARM64_REG_X7 = 204;;
let _ARM64_REG_X8 = 205;;
let _ARM64_REG_X9 = 206;;
let _ARM64_REG_X10 = 207;;
let _ARM64_REG_X11 = 208;;
let _ARM64_REG_X12 = 209;;
let _ARM64_REG_X13 = 210;;
let _ARM64_REG_X14 = 211;;
let _ARM64_REG_X15 = 212;;
let _ARM64_REG_X16 = 213;;
let _ARM64_REG_X17 = 214;;
let _ARM64_REG_X18 = 215;;
let _ARM64_REG_X19 = 216;;
let _ARM64_REG_X20 = 217;;
let _ARM64_REG_X21 = 218;;
let _ARM64_REG_X22 = 219;;
let _ARM64_REG_X23 = 220;;
let _ARM64_REG_X24 = 221;;
let _ARM64_REG_X25 = 222;;
let _ARM64_REG_X26 = 223;;
let _ARM64_REG_X27 = 224;;
let _ARM64_REG_X28 = 225;;
let _ARM64_REG_X29 = 226;;
let _ARM64_REG_X30 = 227;;

(* ARM64 instructions *)
let _ARM64_INS_INVALID = 0;;
let _ARM64_INS_ADC = 1;;
let _ARM64_INS_ADDHN2 = 2;;
let _ARM64_INS_ADDHN = 3;;
let _ARM64_INS_ADDP = 4;;
let _ARM64_INS_ADD = 5;;
let _ARM64_INS_CMN = 6;;
let _ARM64_INS_ADRP = 7;;
let _ARM64_INS_ADR = 8;;
let _ARM64_INS_AND = 9;;
let _ARM64_INS_ASR = 10;;
let _ARM64_INS_AT = 11;;
let _ARM64_INS_BFI = 12;;
let _ARM64_INS_BFM = 13;;
let _ARM64_INS_BFXIL = 14;;
let _ARM64_INS_BIC = 15;;
let _ARM64_INS_BIF = 16;;
let _ARM64_INS_BIT = 17;;
let _ARM64_INS_BLR = 18;;
let _ARM64_INS_BL = 19;;
let _ARM64_INS_BRK = 20;;
let _ARM64_INS_BR = 21;;
let _ARM64_INS_BSL = 22;;
let _ARM64_INS_B = 23;;
let _ARM64_INS_CBNZ = 24;;
let _ARM64_INS_CBZ = 25;;
let _ARM64_INS_CCMN = 26;;
let _ARM64_INS_CCMP = 27;;
let _ARM64_INS_CLREX = 28;;
let _ARM64_INS_CLS = 29;;
let _ARM64_INS_CLZ = 30;;
let _ARM64_INS_CMEQ = 31;;
let _ARM64_INS_CMGE = 32;;
let _ARM64_INS_CMGT = 33;;
let _ARM64_INS_CMHI = 34;;
let _ARM64_INS_CMHS = 35;;
let _ARM64_INS_CMLE = 36;;
let _ARM64_INS_CMLT = 37;;
let _ARM64_INS_CMP = 38;;
let _ARM64_INS_CMTST = 39;;
let _ARM64_INS_CRC32B = 40;;
let _ARM64_INS_CRC32CB = 41;;
let _ARM64_INS_CRC32CH = 42;;
let _ARM64_INS_CRC32CW = 43;;
let _ARM64_INS_CRC32CX = 44;;
let _ARM64_INS_CRC32H = 45;;
let _ARM64_INS_CRC32W = 46;;
let _ARM64_INS_CRC32X = 47;;
let _ARM64_INS_CSEL = 48;;
let _ARM64_INS_CSINC = 49;;
let _ARM64_INS_CSINV = 50;;
let _ARM64_INS_CSNEG = 51;;
let _ARM64_INS_DCPS1 = 52;;
let _ARM64_INS_DCPS2 = 53;;
let _ARM64_INS_DCPS3 = 54;;
let _ARM64_INS_DC = 55;;
let _ARM64_INS_DMB = 56;;
let _ARM64_INS_DRPS = 57;;
let _ARM64_INS_DSB = 58;;
let _ARM64_INS_EON = 59;;
let _ARM64_INS_EOR = 60;;
let _ARM64_INS_ERET = 61;;
let _ARM64_INS_EXTR = 62;;
let _ARM64_INS_FABD = 63;;
let _ARM64_INS_FABS = 64;;
let _ARM64_INS_FACGE = 65;;
let _ARM64_INS_FACGT = 66;;
let _ARM64_INS_FADDP = 67;;
let _ARM64_INS_FADD = 68;;
let _ARM64_INS_FCCMPE = 69;;
let _ARM64_INS_FCCMP = 70;;
let _ARM64_INS_FCMEQ = 71;;
let _ARM64_INS_FCMGE = 72;;
let _ARM64_INS_FCMGT = 73;;
let _ARM64_INS_FCMLE = 74;;
let _ARM64_INS_FCMLT = 75;;
let _ARM64_INS_FCMP = 76;;
let _ARM64_INS_FCMPE = 77;;
let _ARM64_INS_FCSEL = 78;;
let _ARM64_INS_FCVTAS = 79;;
let _ARM64_INS_FCVTAU = 80;;
let _ARM64_INS_FCVTMS = 81;;
let _ARM64_INS_FCVTMU = 82;;
let _ARM64_INS_FCVTNS = 83;;
let _ARM64_INS_FCVTNU = 84;;
let _ARM64_INS_FCVTPS = 85;;
let _ARM64_INS_FCVTPU = 86;;
let _ARM64_INS_FCVTZS = 87;;
let _ARM64_INS_FCVTZU = 88;;
let _ARM64_INS_FCVT = 89;;
let _ARM64_INS_FDIV = 90;;
let _ARM64_INS_FMADD = 91;;
let _ARM64_INS_FMAXNMP = 92;;
let _ARM64_INS_FMAXNM = 93;;
let _ARM64_INS_FMAXP = 94;;
let _ARM64_INS_FMAX = 95;;
let _ARM64_INS_FMINNMP = 96;;
let _ARM64_INS_FMINNM = 97;;
let _ARM64_INS_FMINP = 98;;
let _ARM64_INS_FMIN = 99;;
let _ARM64_INS_FMLA = 100;;
let _ARM64_INS_FMLS = 101;;
let _ARM64_INS_FMOV = 102;;
let _ARM64_INS_FMSUB = 103;;
let _ARM64_INS_FMULX = 104;;
let _ARM64_INS_FMUL = 105;;
let _ARM64_INS_FNEG = 106;;
let _ARM64_INS_FNMADD = 107;;
let _ARM64_INS_FNMSUB = 108;;
let _ARM64_INS_FNMUL = 109;;
let _ARM64_INS_FRECPS = 110;;
let _ARM64_INS_FRINTA = 111;;
let _ARM64_INS_FRINTI = 112;;
let _ARM64_INS_FRINTM = 113;;
let _ARM64_INS_FRINTN = 114;;
let _ARM64_INS_FRINTP = 115;;
let _ARM64_INS_FRINTX = 116;;
let _ARM64_INS_FRINTZ = 117;;
let _ARM64_INS_FRSQRTS = 118;;
let _ARM64_INS_FSQRT = 119;;
let _ARM64_INS_FSUB = 120;;
let _ARM64_INS_HINT = 121;;
let _ARM64_INS_HLT = 122;;
let _ARM64_INS_HVC = 123;;
let _ARM64_INS_IC = 124;;
let _ARM64_INS_INS = 125;;
let _ARM64_INS_ISB = 126;;
let _ARM64_INS_LDARB = 127;;
let _ARM64_INS_LDAR = 128;;
let _ARM64_INS_LDARH = 129;;
let _ARM64_INS_LDAXP = 130;;
let _ARM64_INS_LDAXRB = 131;;
let _ARM64_INS_LDAXR = 132;;
let _ARM64_INS_LDAXRH = 133;;
let _ARM64_INS_LDPSW = 134;;
let _ARM64_INS_LDRSB = 135;;
let _ARM64_INS_LDURSB = 136;;
let _ARM64_INS_LDRSH = 137;;
let _ARM64_INS_LDURSH = 138;;
let _ARM64_INS_LDRSW = 139;;
let _ARM64_INS_LDR = 140;;
let _ARM64_INS_LDTRSB = 141;;
let _ARM64_INS_LDTRSH = 142;;
let _ARM64_INS_LDTRSW = 143;;
let _ARM64_INS_LDURSW = 144;;
let _ARM64_INS_LDXP = 145;;
let _ARM64_INS_LDXRB = 146;;
let _ARM64_INS_LDXR = 147;;
let _ARM64_INS_LDXRH = 148;;
let _ARM64_INS_LDRH = 149;;
let _ARM64_INS_LDURH = 150;;
let _ARM64_INS_STRH = 151;;
let _ARM64_INS_STURH = 152;;
let _ARM64_INS_LDTRH = 153;;
let _ARM64_INS_STTRH = 154;;
let _ARM64_INS_LDUR = 155;;
let _ARM64_INS_STR = 156;;
let _ARM64_INS_STUR = 157;;
let _ARM64_INS_LDTR = 158;;
let _ARM64_INS_STTR = 159;;
let _ARM64_INS_LDRB = 160;;
let _ARM64_INS_LDURB = 161;;
let _ARM64_INS_STRB = 162;;
let _ARM64_INS_STURB = 163;;
let _ARM64_INS_LDTRB = 164;;
let _ARM64_INS_STTRB = 165;;
let _ARM64_INS_LDP = 166;;
let _ARM64_INS_LDNP = 167;;
let _ARM64_INS_STNP = 168;;
let _ARM64_INS_STP = 169;;
let _ARM64_INS_LSL = 170;;
let _ARM64_INS_LSR = 171;;
let _ARM64_INS_MADD = 172;;
let _ARM64_INS_MLA = 173;;
let _ARM64_INS_MLS = 174;;
let _ARM64_INS_MOVI = 175;;
let _ARM64_INS_MOVK = 176;;
let _ARM64_INS_MOVN = 177;;
let _ARM64_INS_MOVZ = 178;;
let _ARM64_INS_MRS = 179;;
let _ARM64_INS_MSR = 180;;
let _ARM64_INS_MSUB = 181;;
let _ARM64_INS_MUL = 182;;
let _ARM64_INS_MVNI = 183;;
let _ARM64_INS_MVN = 184;;
let _ARM64_INS_ORN = 185;;
let _ARM64_INS_ORR = 186;;
let _ARM64_INS_PMULL2 = 187;;
let _ARM64_INS_PMULL = 188;;
let _ARM64_INS_PMUL = 189;;
let _ARM64_INS_PRFM = 190;;
let _ARM64_INS_PRFUM = 191;;
let _ARM64_INS_SQRSHRUN2 = 192;;
let _ARM64_INS_SQRSHRUN = 193;;
let _ARM64_INS_SQSHRUN2 = 194;;
let _ARM64_INS_SQSHRUN = 195;;
let _ARM64_INS_RADDHN2 = 196;;
let _ARM64_INS_RADDHN = 197;;
let _ARM64_INS_RBIT = 198;;
let _ARM64_INS_RET = 199;;
let _ARM64_INS_REV16 = 200;;
let _ARM64_INS_REV32 = 201;;
let _ARM64_INS_REV = 202;;
let _ARM64_INS_ROR = 203;;
let _ARM64_INS_RSHRN2 = 204;;
let _ARM64_INS_RSHRN = 205;;
let _ARM64_INS_RSUBHN2 = 206;;
let _ARM64_INS_RSUBHN = 207;;
let _ARM64_INS_SABAL2 = 208;;
let _ARM64_INS_SABAL = 209;;
let _ARM64_INS_SABA = 210;;
let _ARM64_INS_SABDL2 = 211;;
let _ARM64_INS_SABDL = 212;;
let _ARM64_INS_SABD = 213;;
let _ARM64_INS_SADDL2 = 214;;
let _ARM64_INS_SADDL = 215;;
let _ARM64_INS_SADDW2 = 216;;
let _ARM64_INS_SADDW = 217;;
let _ARM64_INS_SBC = 218;;
let _ARM64_INS_SBFIZ = 219;;
let _ARM64_INS_SBFM = 220;;
let _ARM64_INS_SBFX = 221;;
let _ARM64_INS_SCVTF = 222;;
let _ARM64_INS_SDIV = 223;;
let _ARM64_INS_SHADD = 224;;
let _ARM64_INS_SHL = 225;;
let _ARM64_INS_SHRN2 = 226;;
let _ARM64_INS_SHRN = 227;;
let _ARM64_INS_SHSUB = 228;;
let _ARM64_INS_SLI = 229;;
let _ARM64_INS_SMADDL = 230;;
let _ARM64_INS_SMAXP = 231;;
let _ARM64_INS_SMAX = 232;;
let _ARM64_INS_SMC = 233;;
let _ARM64_INS_SMINP = 234;;
let _ARM64_INS_SMIN = 235;;
let _ARM64_INS_SMLAL2 = 236;;
let _ARM64_INS_SMLAL = 237;;
let _ARM64_INS_SMLSL2 = 238;;
let _ARM64_INS_SMLSL = 239;;
let _ARM64_INS_SMOV = 240;;
let _ARM64_INS_SMSUBL = 241;;
let _ARM64_INS_SMULH = 242;;
let _ARM64_INS_SMULL2 = 243;;
let _ARM64_INS_SMULL = 244;;
let _ARM64_INS_SQADD = 245;;
let _ARM64_INS_SQDMLAL2 = 246;;
let _ARM64_INS_SQDMLAL = 247;;
let _ARM64_INS_SQDMLSL2 = 248;;
let _ARM64_INS_SQDMLSL = 249;;
let _ARM64_INS_SQDMULH = 250;;
let _ARM64_INS_SQDMULL2 = 251;;
let _ARM64_INS_SQDMULL = 252;;
let _ARM64_INS_SQRDMULH = 253;;
let _ARM64_INS_SQRSHL = 254;;
let _ARM64_INS_SQRSHRN2 = 255;;
let _ARM64_INS_SQRSHRN = 256;;
let _ARM64_INS_SQSHLU = 257;;
let _ARM64_INS_SQSHL = 258;;
let _ARM64_INS_SQSHRN2 = 259;;
let _ARM64_INS_SQSHRN = 260;;
let _ARM64_INS_SQSUB = 261;;
let _ARM64_INS_SRHADD = 262;;
let _ARM64_INS_SRI = 263;;
let _ARM64_INS_SRSHL = 264;;
let _ARM64_INS_SRSHR = 265;;
let _ARM64_INS_SRSRA = 266;;
let _ARM64_INS_SSHLL2 = 267;;
let _ARM64_INS_SSHLL = 268;;
let _ARM64_INS_SSHL = 269;;
let _ARM64_INS_SSHR = 270;;
let _ARM64_INS_SSRA = 271;;
let _ARM64_INS_SSUBL2 = 272;;
let _ARM64_INS_SSUBL = 273;;
let _ARM64_INS_SSUBW2 = 274;;
let _ARM64_INS_SSUBW = 275;;
let _ARM64_INS_STLRB = 276;;
let _ARM64_INS_STLR = 277;;
let _ARM64_INS_STLRH = 278;;
let _ARM64_INS_STLXP = 279;;
let _ARM64_INS_STLXRB = 280;;
let _ARM64_INS_STLXR = 281;;
let _ARM64_INS_STLXRH = 282;;
let _ARM64_INS_STXP = 283;;
let _ARM64_INS_STXRB = 284;;
let _ARM64_INS_STXR = 285;;
let _ARM64_INS_STXRH = 286;;
let _ARM64_INS_SUBHN2 = 287;;
let _ARM64_INS_SUBHN = 288;;
let _ARM64_INS_SUB = 289;;
let _ARM64_INS_SVC = 290;;
let _ARM64_INS_SXTB = 291;;
let _ARM64_INS_SXTH = 292;;
let _ARM64_INS_SXTW = 293;;
let _ARM64_INS_SYSL = 294;;
let _ARM64_INS_SYS = 295;;
let _ARM64_INS_TBNZ = 296;;
let _ARM64_INS_TBZ = 297;;
let _ARM64_INS_TLBI = 298;;
let _ARM64_INS_TST = 299;;
let _ARM64_INS_UABAL2 = 300;;
let _ARM64_INS_UABAL = 301;;
let _ARM64_INS_UABA = 302;;
let _ARM64_INS_UABDL2 = 303;;
let _ARM64_INS_UABDL = 304;;
let _ARM64_INS_UABD = 305;;
let _ARM64_INS_UADDL2 = 306;;
let _ARM64_INS_UADDL = 307;;
let _ARM64_INS_UADDW2 = 308;;
let _ARM64_INS_UADDW = 309;;
let _ARM64_INS_UBFIZ = 310;;
let _ARM64_INS_UBFM = 311;;
let _ARM64_INS_UBFX = 312;;
let _ARM64_INS_UCVTF = 313;;
let _ARM64_INS_UDIV = 314;;
let _ARM64_INS_UHADD = 315;;
let _ARM64_INS_UHSUB = 316;;
let _ARM64_INS_UMADDL = 317;;
let _ARM64_INS_UMAXP = 318;;
let _ARM64_INS_UMAX = 319;;
let _ARM64_INS_UMINP = 320;;
let _ARM64_INS_UMIN = 321;;
let _ARM64_INS_UMLAL2 = 322;;
let _ARM64_INS_UMLAL = 323;;
let _ARM64_INS_UMLSL2 = 324;;
let _ARM64_INS_UMLSL = 325;;
let _ARM64_INS_UMOV = 326;;
let _ARM64_INS_UMSUBL = 327;;
let _ARM64_INS_UMULH = 328;;
let _ARM64_INS_UMULL2 = 329;;
let _ARM64_INS_UMULL = 330;;
let _ARM64_INS_UQADD = 331;;
let _ARM64_INS_UQRSHL = 332;;
let _ARM64_INS_UQRSHRN2 = 333;;
let _ARM64_INS_UQRSHRN = 334;;
let _ARM64_INS_UQSHL = 335;;
let _ARM64_INS_UQSHRN2 = 336;;
let _ARM64_INS_UQSHRN = 337;;
let _ARM64_INS_UQSUB = 338;;
let _ARM64_INS_URHADD = 339;;
let _ARM64_INS_URSHL = 340;;
let _ARM64_INS_URSHR = 341;;
let _ARM64_INS_URSRA = 342;;
let _ARM64_INS_USHLL2 = 343;;
let _ARM64_INS_USHLL = 344;;
let _ARM64_INS_USHL = 345;;
let _ARM64_INS_USHR = 346;;
let _ARM64_INS_USRA = 347;;
let _ARM64_INS_USUBL2 = 348;;
let _ARM64_INS_USUBL = 349;;
let _ARM64_INS_USUBW2 = 350;;
let _ARM64_INS_USUBW = 351;;
let _ARM64_INS_UXTB = 352;;
let _ARM64_INS_UXTH = 353;;

(* ARM64 group of instructions *)
let _ARM64_GRP_INVALID = 0;;
let _ARM64_GRP_NEON = 1;;

