#!/usr/bin/perl
#  wrapper.pl - a command parsing wrapper for the CBB 'engine'.
#
#  Written by Curtis Olson.  Started August 22, 1994.
#
#  Copyright (C) 1994 - 1999  Curtis L. Olson  - curt@me.umn.edu
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: wrapper.pl,v 1.1.1.1 1999/12/18 02:05:33 curt Exp $


package CBB;

use strict;    # don't take no guff


# specify the installed location of the necessary pieces.
BEGIN {
  $CBB::cbb_incl_dir = ".";
  unshift(@INC, $CBB::cbb_incl_dir);
}

require "engine.pl";
require "categories.pl";
require "file.pl";
require "memorized.pl";
require "import.pl";
require "export.pl";


sub BEGIN {
    $CBB::logging = 1;		# 0 = off,  1 = on
    $CBB::debug = 0;		# 0 = off,  1 = on

    if ( $ENV{"OS"} ne "Windows_NT" ) {
        # get user name
        @CBB::pw = getpwuid($<);

        $CBB::user_name = $CBB::pw[0]
	    || $ENV{LOGNAME} || die "No user name!";
    } else {
	$CBB::user_name = "ruut";
    }

    $CBB::current_file = "";

    $CBB::encrypt = "";
    $CBB::decrypt = "";

    $CBB::duplicate = 2;	# 0 = always insert, 1 = never insert, 2 = ask
    $CBB::compare = 31;		# compare all fields except category

    # set umask to 066 (only owner should be able to read this)
    umask(066);
}


&main_loop();


# main command parsing loop
sub main_loop {
    my($arg, $command, $full_command);

    while (<>) {
	chop;

	$full_command = $_;
	print DEBUG "Command string:  '$full_command'\n" if $CBB::debug;

	if ( m/ / ) {
	    ($command, $arg) = split(/ /, $full_command, 2);
	} else {
	    ($command, $arg) = ($full_command, "");
	}

	if ($command eq "create_trans") {
	    print DEBUG "calling create_trans($arg)\n" if $CBB::debug;
	    print &create_trans($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "create_xfer") {
	    print DEBUG "calling create_xfer($arg)\n" if $CBB::debug;
	    print &create_xfer($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "update_trans") {
	    print DEBUG "calling update_trans($arg)\n" if $CBB::debug;
	    print &update_trans($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "update_xfer") {
	    print DEBUG "calling update_xfer($arg)\n" if $CBB::debug;
	    print &update_xfer($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "delete_trans") {
	    print DEBUG "calling delete_trans($arg)\n" if $CBB::debug;
	    print &delete_trans($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "delete_xfer") {
	    print DEBUG "calling delete_xfer($arg)\n" if $CBB::debug;
	    print &delete_xfer($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "next_trans") {
	    print DEBUG "next_trans()\n" if $CBB::debug;
	    print &next_trans()."\n";
	} elsif ($command eq "prev_trans") {
	    print "prev_trans()\n";
	} elsif ($command eq "find_trans") {
	    print DEBUG "find_trans($arg)\n" if $CBB::debug;
	    print &find_trans($arg)."\n";
	} elsif ($command eq "get_current_index") {
	    print DEBUG "get_current_index()\n" if $CBB::debug;
	    print &get_current_index()."\n";
	} elsif ($command eq "first_trans") {
	    print DEBUG "first_trans()\n" if $CBB::debug;
	    print &first_trans()."\n";
	} elsif ($command eq "all_trans") {
	    print DEBUG "all_trans($arg)\n" if $CBB::debug;
	    print &all_trans($arg)."\n";
	} elsif ($command eq "part_trans") {
	    print DEBUG "part_trans($arg)\n" if $CBB::debug;
	    print &part_trans($arg)."\n";
	} elsif ($command eq "last_trans") {
	    print "last_trans()\n";
	} elsif ($command eq "first_uncleared_trans") {
	    print DEBUG "first_uncleared_trans()\n" if $CBB::debug;
	    print &first_uncleared_trans()."\n";
	} elsif ($command eq "last_uncleared_trans") {
	    print "last_uncleared_trans()\n";
	} elsif ($command eq "next_uncleared_trans") {
	    print DEBUG "next_uncleared_trans()\n" if $CBB::debug;
	    print &next_uncleared_trans()."\n";
	} elsif ($command eq "prev_uncleared_trans") {
	    print "prev_uncleared_trans()\n";
	} elsif ($command eq "select_trans") {
	    print DEBUG "select_trans()\n" if $CBB::debug;
	    print &select_trans($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "unselect_trans") {
	    print DEBUG "unselect_trans()\n" if $CBB::debug;
	    print &unselect_trans($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "clear_trans") {
	    print DEBUG "clear_trans()\n" if $CBB::debug;
	    print &clear_trans()."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "get_cleared_bal") {
	    print DEBUG "get_cleared_bal()\n" if $CBB::debug;
	    print &get_cleared_bal()."\n";
	} elsif ($command eq "sort_trans") {
	    print "sort_trans()\n";
	} elsif ($command eq "init_trans") {
	    print DEBUG "calling init_trans()\n" if $CBB::debug;
	    print &init_trans()."\n";
	} elsif ($command eq "make_acct") {
	    print DEBUG "calling make_acct($arg)\n" if $CBB::debug;
	    print &make_acct($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "load_trans") {
	    print DEBUG "calling load_trans($arg)\n" if $CBB::debug;
	    print &load_trans($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "load_cbb") {
	    print DEBUG "calling load_cbb($arg)\n" if $CBB::debug;
	    print &load_cbb($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "import_qif") {
	    print DEBUG "calling import_qif($arg)\n" if $CBB::debug;
	    print &import_qif($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "save_cbb") {
	    print DEBUG "calling save_cbb($arg)\n" if $CBB::debug;
	    print &save_cbb($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "export_qif") {
	    print DEBUG "calling export_qif($arg)\n" if $CBB::debug;
	    print &export_qif($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "save_trans") {
	    print DEBUG "calling save_trans($arg)\n" if $CBB::debug;
	    print &save_trans($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "auto_save_trans") {
	    print DEBUG "calling auto_save_trans($arg)\n" if $CBB::debug;
	    &save_trans($arg);
	} elsif ($command eq "rehash_mems") {
	    print DEBUG "calling rehash_mems()\n" if $CBB::debug;
	    print &rehash_mems()."\n";
	} elsif ($command eq "find_mem") {
	    print DEBUG "calling find_mem($arg)\n" if $CBB::debug;
	    print &find_mem($arg)."\n";
	} elsif ($command eq "init_cats") {
	    print DEBUG "calling init_cats()\n" if $CBB::debug;
	    print &init_cats()."\n";
	} elsif ($command eq "edit_cat") {
	    print DEBUG "calling edit_cat($arg)\n" if $CBB::debug;
	    print &edit_cat($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "insert_cat") {
	    print DEBUG "calling insert_cat($arg)\n" if $CBB::debug;
	    print &insert_cat($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "delete_cat") {
	    print DEBUG "calling delete_cat($arg)\n" if $CBB::debug;
	    print &delete_cat($arg)."\n";
	    &log_txn($full_command) if $CBB::logging;
	} elsif ($command eq "all_cats") {
	    print DEBUG "calling all_cats()\n";
	    print &all_cats()."\n";
	} elsif ($command eq "find_cat") {
	    print DEBUG "calling find_cat($arg)\n";
	    print &find_cat($arg)."\n";
	} elsif ($command eq "get_cat_info") {
	    print DEBUG "calling get_cat_info($arg)\n";
	    print &get_cat_info($arg)."\n";
	} elsif ($command eq "load_cats") {
	    print DEBUG "calling load_cats($arg)\n" if $CBB::debug;
	    print &load_cats($arg)."\n";
	} elsif ($command eq "load_dbm_cats") {
	    print DEBUG "calling load_dbm_cats($arg)\n" if $CBB::debug;
	    print &load_dbm_cats($arg)."\n";
	} elsif ($command eq "save_cats") {
	    print DEBUG "calling save_cats($arg)\n" if $CBB::debug;
	    print &save_cats($arg)."\n";
	} elsif ($command eq "rep_txn_list") {
	    print DEBUG "calling rep_txn_list($arg)\n" if $CBB::debug;
	    print &rep_txn_list($arg)."\n";
	} elsif ($command eq "rep_txn_by_cat") {
	    print DEBUG "calling rep_txn_by_cat($arg)\n" if $CBB::debug;
	    print &rep_txn_by_cat($arg)."\n";
	} elsif ($command eq "rep_txn_by_cat_short") {
	    print DEBUG "calling rep_txn_by_cat_short($arg)\n" if $CBB::debug;
	    print &rep_txn_by_cat_short($arg)."\n";
	} elsif ($command eq "nice_date") {
	    print DEBUG "calling nice_date($arg)\n" if $CBB::debug;
	    print &nice_date($arg)."\n";
	} elsif ($command eq "raw_date") {
	    print DEBUG "calling raw_date()\n" if $CBB::debug;
	    print &raw_date()."\n";
	} elsif ($command eq "start_date") {
	    print DEBUG "calling start_date()\n" if $CBB::debug;
	    print &start_date($arg)."\n";
	} elsif ($command eq "century") {
	    print DEBUG "calling century()\n" if $CBB::debug;
	    print &century()."\n";
	} elsif ($command eq "get_files") {
	    print DEBUG "get_files($arg)\n" if $CBB::debug;
	    print &get_files($arg)."\n";
	} elsif ($command eq "debug") {
	    print DEBUG "debug($arg)\n" if $CBB::debug;
	    print &debug($arg)."\n";
	} elsif ($command eq "cache") {
	    print DEBUG "cache($arg)\n" if $CBB::debug;
	    $CBB::cache = int($arg);
	    print $CBB::cache . "\n";
	} elsif ($command eq "encrypt") {
	    print DEBUG "encrypt($arg)\n" if $CBB::debug;
	    $CBB::encrypt = $arg;
	    print $CBB::encrypt . "\n";
	} elsif ($command eq "decrypt") {
	    print DEBUG "decrypt($arg)\n" if $CBB::debug;
	    $CBB::decrypt = $arg;
	    print $CBB::decrypt . "\n";
	} elsif ($command eq "duplicate") {
	    print DEBUG "duplicate($arg)\n" if $CBB::debug;
	    $CBB::duplicate = $arg;
	    print $CBB::duplicate . "\n";
	} elsif ($command eq "compare") {
	    print DEBUG "compare($arg)\n" if $CBB::debug;
	    $CBB::compare = $arg;
	    print $CBB::compare . "\n";
	} elsif ($command eq "logging") {
	    print DEBUG "logging($arg)\n" if $CBB::debug;
	    $CBB::logging = int($arg);
	    print $CBB::logging . "\n";
	} elsif ($command eq "quit") {
	    print DEBUG "exiting\n" if $CBB::debug;
	    exit(0);
	} else {
	    # unknown command ... return error
	    print DEBUG "unknown command\n" if $CBB::debug;
	    print "error\n";
	}
    }
}


1;				# need to return a true value
