/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include "absimg.h"

#if defined HAVE_GDKPIXBUF2 || defined HAVE_GDKPIXBUF

#include <gdk/gdkx.h>
#include <string.h>

void absimg_init()
{
}

absimg_image_t *absimg_load(filename)
char *filename;
{
	GdkPixbuf *image;
	absimg_image_t *rv;

	image = gdk_pixbuf_new_from_file(filename);

	if (!image) return NULL;

	rv = g_malloc(sizeof(absimg_image_t));
	rv->image = image;
	rv->rgb_height = gdk_pixbuf_get_height(image);
	rv->rgb_width = gdk_pixbuf_get_width(image);
	rv->filename = g_strdup(filename);

	return rv;
}

void absimg_flip_horizontal(image)
absimg_image_t *image;
{
	int w,h;
	int x,y;
	int rs;
	guchar *pb;
	char tmp[32];
	int nb;

	rs = gdk_pixbuf_get_rowstride(image->image);
	h = gdk_pixbuf_get_height(image->image);
	w = gdk_pixbuf_get_width(image->image);
	nb = gdk_pixbuf_get_n_channels(image->image) *
		gdk_pixbuf_get_bits_per_sample(image->image)/8;

	pb = gdk_pixbuf_get_pixels(image->image);

	for (y = 0; y < h*rs ; y += rs)
	{
		for (x = 0; x < w/2 ; x++)
		{
			memcpy(tmp , pb + y + x*nb, nb);
			memcpy(pb + y + x*nb, pb + y + (w-1-x)*nb, nb);
			memcpy(pb + y + (w-1-x)*nb, tmp, nb);
		}
	}
}

void absimg_flip_vertical(image)
absimg_image_t *image;
{
	int w,h;
	int y;
	int rs;
	guchar *pb;
	char *tmp;

	rs = gdk_pixbuf_get_rowstride(image->image);
	h = gdk_pixbuf_get_height(image->image);
	w = gdk_pixbuf_get_width(image->image);

	pb = gdk_pixbuf_get_pixels(image->image);

	tmp = g_malloc(rs);

	for (y = 0; y < (h/2) ; y ++)
	{
		memcpy(tmp , pb + y*rs , rs);
		memcpy(pb + y*rs, pb + (h-1-y)*rs , rs);
		memcpy(pb + (h-1-y)*rs, tmp, rs);
	}

	g_free(tmp);
}

GdkPixmap *absimg_render(image, width, height)
absimg_image_t *image;
gint width;
gint height;
{
	GdkPixbuf *temp;
	GdkPixmap *pixmap;
	GdkGC *gc;
	int w,h;

	width = MAX(1, width);
	height = MAX(1, height);
	gc = gdk_gc_new(GDK_ROOT_PARENT());

	h = gdk_pixbuf_get_height(image->image);
	w = gdk_pixbuf_get_width(image->image);

	if (w != width || h != height)
	{
#ifdef HAVE_GDKPIXBUF2
		temp = gdk_pixbuf_scale_simple(image->image, width, height, GDK_INTERP_BILINEAR);
#else
		temp = gdk_pixbuf_scale_simple(image->image, width, height, ART_FILTER_BILINEAR);
#endif
	}
	else
	{
		temp = image->image;
		gdk_pixbuf_ref(image->image);
	}

	pixmap = gdk_pixmap_new(GDK_ROOT_PARENT(), width, height,
                                    gdk_visual_get_best_depth());

	gdk_pixbuf_render_to_drawable(temp, pixmap , gc ,
			0, 0, 0, 0, width, height, GDK_RGB_DITHER_NORMAL, 1, 1);

	gdk_pixbuf_unref(temp);

	gdk_gc_unref(gc);

	return pixmap;
}

void absimg_destroy(image)
absimg_image_t *image;
{
	gdk_pixbuf_unref(image->image);
	g_free(image->filename);
	g_free(image);
}

void absimg_destroy_pixmap(pixmap)
GdkPixmap *pixmap;
{
	gdk_pixmap_unref(pixmap);
}

int absimg_have_alpha(image)
absimg_image_t *image;
{
	return gdk_pixbuf_get_has_alpha(image->image);
}

void absimg_render_alpha_to_pixmap(pixmap, image, width, height)
GdkPixmap *pixmap; 
absimg_image_t *image;
gint width;
gint height;
{
	GdkPixbuf *temp;
	int w,h,x,y;

	width = MAX(1, width);
	height = MAX(1, height);

	h = gdk_pixbuf_get_height(image->image);
	w = gdk_pixbuf_get_width(image->image);

	if (w != width || h != height)
	{
#ifdef HAVE_GDKPIXBUF2
		temp = gdk_pixbuf_scale_simple(image->image, width, height, GDK_INTERP_BILINEAR);
#else
		temp = gdk_pixbuf_scale_simple(image->image, width, height, ART_FILTER_BILINEAR);
#endif
	}
	else
	{
		temp = image->image;
		gdk_pixbuf_ref(image->image);
	}

	gdk_window_get_size(pixmap, &w, &h);

	x = (w - width)/2;
	y = (h - height)/2;

	/* in gdk-pixbuf-0.9 GDK_PIXBUF_ALPHA_FULL not supported yet :-( */
	gdk_pixbuf_render_to_drawable_alpha(temp, pixmap,
			0, 0, x, y, width, height,
			GDK_PIXBUF_ALPHA_FULL, 128,
			GDK_RGB_DITHER_NORMAL, 1, 1);

	gdk_pixbuf_unref(temp);
}

void absimg_render_to_rgb(rgb, image, width, height, xpos, ypos)
absimg_rgb_t *rgb;
absimg_image_t *image;
gint width;
gint height;
gfloat xpos;
gfloat ypos;
{
	int px,py;
	int rx,ry,ix,iy;
	unsigned char *pb;
	int rs,nb;
	GdkPixbuf *temp;
	gboolean has_alpha;

	width = MAX(1, width);
	height = MAX(1, height);

	if (image->rgb_width != width || image->rgb_height != height)
	{
#ifdef HAVE_GDKPIXBUF2
		temp = gdk_pixbuf_scale_simple(image->image, width, height, GDK_INTERP_BILINEAR);
#else
		temp = gdk_pixbuf_scale_simple(image->image, width, height, ART_FILTER_BILINEAR);
#endif
	}
	else
	{
		temp = image->image;
		gdk_pixbuf_ref(image->image);
	}

	pb = gdk_pixbuf_get_pixels(temp);
	rs = gdk_pixbuf_get_rowstride(temp);
	nb = gdk_pixbuf_get_n_channels(temp) *
		gdk_pixbuf_get_bits_per_sample(temp)/8;
	has_alpha = gdk_pixbuf_get_has_alpha(temp);

	px = (int) ((gfloat)(rgb->width - width) * xpos);
	py = (int) ((gfloat)(rgb->height - height) * ypos);

	for (iy = MAX(0, -py), ry = MAX(0, py);
	     iy < height && ry < rgb->height;
	     iy++, ry++)
	{
		for (ix = MAX(0, -px), rx = MAX(0, px);
		     ix < width && rx < rgb->width;
		     ix++, rx++)
		{
			int ri = ry * 3 * rgb->width + 3 * rx;
			int ii = iy * rs + nb * ix;

			if (has_alpha)
			{
				ABSIMG_ALPHA(pb[ii], rgb->rgb[ri], pb[ii+3])
				ABSIMG_ALPHA(pb[ii+1], rgb->rgb[ri+1], pb[ii+3])
				ABSIMG_ALPHA(pb[ii+2], rgb->rgb[ri+2], pb[ii+3])
			}
			else
			{
				rgb->rgb[ri] = pb[ii];
				rgb->rgb[ri+1] = pb[ii+1];
				rgb->rgb[ri+2] = pb[ii+2];
			}
		}
	}

	gdk_pixbuf_unref(temp);
}

absimg_image_t *absimg_scale(img, width, height)
absimg_image_t *img;
int width;
int height;
{
	GdkPixbuf *image;
	absimg_image_t *rv;

#ifdef HAVE_GDKPIXBUF2
	image = gdk_pixbuf_scale_simple(img->image, width, height, GDK_INTERP_BILINEAR);
#else
	image = gdk_pixbuf_scale_simple(img->image, width, height, ART_FILTER_BILINEAR);
#endif

	if (!image) return NULL;

	rv = g_malloc(sizeof(absimg_image_t));
	rv->image = image;
	rv->rgb_height = gdk_pixbuf_get_height(image);
	rv->rgb_width = gdk_pixbuf_get_width(image);
	rv->filename = g_strdup(img->filename);

	return rv;
}

absimg_image_t *absimg_from_pixmap(pixmap)
GdkPixmap *pixmap;
{
	GdkPixbuf *image;
	absimg_image_t *rv;
	guint w,h;

	gdk_window_get_size(pixmap, &w, &h);

	image = gdk_pixbuf_get_from_drawable(NULL, pixmap,
		gdk_colormap_get_system(), 0, 0, 0, 0, w, h);

	if (!image) return NULL;

	rv = g_malloc(sizeof(absimg_image_t));
	rv->image = image;
	rv->rgb_height = gdk_pixbuf_get_height(image);
	rv->rgb_width = gdk_pixbuf_get_width(image);
	rv->filename = g_strdup("pixmap");

	return rv;

}

absimg_rgb_t *absimg_to_rgba(img)
absimg_image_t *img;
{
	int x,y;
	unsigned char *pb;
	int rs,nb;
	gboolean has_alpha;
	absimg_rgb_t *rgb;

	pb = gdk_pixbuf_get_pixels(img->image);
	rs = gdk_pixbuf_get_rowstride(img->image);
	nb = gdk_pixbuf_get_n_channels(img->image) *
		gdk_pixbuf_get_bits_per_sample(img->image)/8;
	has_alpha = gdk_pixbuf_get_has_alpha(img->image);

	rgb = absimg_rgb_new(img->rgb_width, img->rgb_height);

	if (has_alpha)
		rgb->alpha = g_malloc(img->rgb_width * img->rgb_height);
		
	for (y = 0; y < img->rgb_height; y++)
	{
		for (x = 0; x < img->rgb_width; x++)
		{
			int ri = y * 3 * img->rgb_width + 3 * x;
			int ii = y * rs + nb * x;

			rgb->rgb[ri] = pb[ii];
			rgb->rgb[ri+1] = pb[ii+1];
			rgb->rgb[ri+2] = pb[ii+2];
			if (has_alpha)
				rgb->alpha[y * rgb->width + x] = pb[ii+3];
		}
	}

	return rgb;
}

#endif

