;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: image.lisp,v 1.9 2001/11/12 20:07:08 jesse Exp $
;;;
;;; Copyright (c) 1999, 2000, 2001 onShore Development, Inc.
;;;
;;; See the file 'COPYING' in this directory for terms.

(in-package :imho)

(defstruct image-record
  default
  disabled
  highlit
  clicked)

(defun directory-normalize (dir &rest more-dirs)
  "ugly function for comining directory path elements"
  (let ((ndir ""))
    (do* ((d dir (car list))
          (list more-dirs (cdr list)))
         ((null d))
      (setq ndir (concatenate 'string ndir "/" (string-trim "/" d))))
    (concatenate 'string ndir "/")))

(defun get-image-url (image-base-name &optional (type :default))
  "given an image's 'base' name, return the full URL for it for the
current application"
  (concatenate 'string
	       (directory-normalize (slot-value *active-application* 'doc-root) "images")
               image-base-name
               (case type
                 (:disabled     "-d.gif")
                 (:highlit      "-o.gif")
                 (:clicked      "-a.gif")
		 (:inactive     "-i.gif")
                 (t             ".gif"))))

;; i = default, o = mouseover, a = clicked, d = disabled

(defun get-applet-codebase ()
  "return the location that the current application's applets should
be loaded from"
  (directory-normalize (slot-value *active-application* 'doc-root) "classes"))


