;;;; MaiSQL --- Common Lisp Interface Layer to SQL Databases
;;;; This is copyrighted software.  See documentation for terms.
;;;; 
;;;; mysql-loader.cl --- Foreign Object Loader for MySQL
;;;; 
;;;; Checkout Tag: $Name:  $
;;;; $Id: mysql-loader.lisp,v 1.1.1.1 1999/09/20 23:04:47 jesse Exp $

(in-package :MAISQL-MYSQL)

;;;; %File Description:
;;;; 
;;;; 
;;;; 

;;;; Load the foreign library
(defvar *mysql-so-load-path* "/usr/lib/libmysqlclient.so"
  "Location where the MySQL client library is to be found.  If this
differs at your site, set *mysql-so-load-path* to the right path
before compiling or loading the system.")

(defvar *mysql-so-libraries* '("-lc")
  "List of library flags needed to be passed to ld to load the
MySQL client library succesfully.  If this differs at your site,
set *mysql-so-libraries* to the right path before compiling or
loading the system.")

(defmethod database-type-load-foreign ((database-type (eql :mysql)))
  (load-foreign *mysql-so-load-path*
		:libraries *mysql-so-libraries*))

(database-type-load-foreign :mysql)
