/***************************************************************************
                   Controller_Keyboard.cpp  -  description
                             -------------------
    begin                : ?
    copyright            : (C) 1999 by Andreas Hundt, Denis Oliver Kropp
    email                : clanbomber@fischlustig.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// $Id: Controller_Keyboard.cpp,v 1.3 2000/01/09 01:18:32 dok Exp $

#include <ClanLib/Core/Input/keyboard.h>

#include "ClanBomber.h"
#include "Controller_Keyboard.h"

Controller_Keyboard::Controller_Keyboard(int keymap_nr) : Controller()
{
	switch (keymap_nr)
	{
	case 0:
		left_key = CL_KEY_LEFT;
		right_key = CL_KEY_RIGHT;
		up_key = CL_KEY_UP;
		down_key = CL_KEY_DOWN;
		bomb_key = CL_KEY_ENTER;
		break;
	case 1:
		left_key = CL_KEY_A;
		right_key = CL_KEY_D;
		up_key = CL_KEY_W;
		down_key = CL_KEY_S;
		bomb_key = CL_KEY_TAB;
		break;
	case 2:
		left_key = CL_KEY_J;
		right_key = CL_KEY_L;
		up_key = CL_KEY_I;
		down_key = CL_KEY_K;
		bomb_key = CL_KEY_SPACE;
		break;
	case 3:
		left_key = CL_KEY_4;
		right_key = CL_KEY_6;
		up_key = CL_KEY_8;
		down_key = CL_KEY_5;
		bomb_key = CL_KEY_0;
		break;
	}
	reset();
}

void Controller_Keyboard::update()
{
	if (CL_Keyboard::get_keycode(bomb_key) && !bomb_key_down)
	{
		put_bomb = true;
	} else
	{
		put_bomb = false;
	}
	bomb_key_down = CL_Keyboard::get_keycode(bomb_key);
}

void Controller_Keyboard::reset()
{
	put_bomb = false;
	bomb_key_down = true;
	reverse = false;
}

bool Controller_Keyboard::is_left()
{
	if (reverse)
		return CL_Keyboard::get_keycode( right_key ) && active;
		
	return CL_Keyboard::get_keycode( left_key ) && active;
}

bool Controller_Keyboard::is_right()
{
	if (reverse)
		return CL_Keyboard::get_keycode( left_key ) && active;
		
	return CL_Keyboard::get_keycode( right_key ) && active;
}

bool Controller_Keyboard::is_up()
{
	if (reverse)
		return CL_Keyboard::get_keycode( down_key ) && active;
		
	return CL_Keyboard::get_keycode( up_key ) && active;
}

bool Controller_Keyboard::is_down()
{
	if (reverse)
		return CL_Keyboard::get_keycode( up_key ) && active;
		
	return CL_Keyboard::get_keycode( down_key ) && active;
}

bool Controller_Keyboard::is_bomb()
{
	switch (bomb_mode)
	{
		case NEVER:
			return false;
		case ALWAYS:
			return true;
		default:
		break;
	}
	return put_bomb && active;
}



