#! /bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_PARSER='src/lib/perl5/COD/CIF/Parser.pm'
INPUT_DDL_MODULE='src/lib/perl5/COD/CIF/DDL.pm'
INPUT_CIF='tests/inputs/4308312-audit-dict-name.cif'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2020-07-10 15:53:55 +0300 (Fri, 10 Jul 2020) $ 
#$Revision: 8185 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.1.0/tests/shtests/get_cif_dictionary_ids_001.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::DDL::get_cif_dictionary_ids() subroutine.
#**

use strict;
use warnings;

use COD::CIF::Parser qw( parse_cif );
use COD::CIF::DDL qw( get_cif_dictionary_ids );
use Data::Dumper;

$Data::Dumper::Sortkeys = 1;

my( $data, $dataset );

( $data ) = parse_cif( 'tests/inputs/4308312-audit-dict-name.cif' );
( $dataset ) = @$data;

print Dumper get_cif_dictionary_ids( $dataset );

END_SCRIPT
