/* io_load.c */
#include <stdlib.h>
#include <stdint.h>
#include <unistd.h>
#include <string.h>
#include <sys/stat.h>

#include "trivial.h"
#include "programs.h"
#include "sysinfo.h"
#include "io_load.h"

extern char *opt_tmpf;
extern char *opt_io_other_file;

#define MIN_BLK_SIZE	1024

int do_io_load(void)
{
	FILE *fp;
	unsigned long i;
	void *buf=NULL;
	struct stat statbuf;
	unsigned long mem, step;

	if(get_ram(&mem)){
		printe("ram size not available, aborting\n");
		exit(2);
	}

	for(;;){
		if(!(fp=fopen(opt_tmpf, "w"))){
			printsys("error opening temporary file %s\n", opt_tmpf);
		}
		if(!buf){
			if(stat(opt_tmpf, &statbuf)==-1){
				printsys("error stating temporary file %s\n", opt_tmpf);
			}
			printd("blksize=%lu\n", (unsigned long)statbuf.st_blksize);
			if(statbuf.st_blksize<MIN_BLK_SIZE){
				statbuf.st_blksize=MIN_BLK_SIZE;
			}
			if(!(buf=calloc(1, statbuf.st_blksize))){
				printsys("error allocating io buffer\n");
			}
			printd("mem=%lu, blksize=%lu\n", mem, (unsigned long)statbuf.st_blksize);
			mem/=statbuf.st_blksize/1024;	/* kilobytes to blocks */
		}
		printd("using mem=%lu\n", mem);
		printd("Writing %lu blocks (%lukB each) to temporary file %s "
			"for io_load\n", mem, (unsigned long)statbuf.st_blksize/1024,
								opt_tmpf);
		step=(mem *1024)/(10*statbuf.st_blksize);
		printd("using step=%lu\n", step);
		for(i=0; i<mem; i++){
			if(fwrite(buf, statbuf.st_blksize, 1, fp)!=1){
				printsys("Error writing to temporary file %s, aborting\n", opt_tmpf);
			}
			if(!(i%step)){
				if(write(TMP_FD, buf, 10)==-1){
					printsys("error reporting progress\n");
				}
			}
		}
		if(fclose(fp)){
			printsys("error closing stream for file %s\n", opt_tmpf);
		}
		printd("going to reopen\n");
	}
	return 0;	/* not reached */
}

int do_io_other(void)
{
	/* we are executing in a different address space */
	opt_tmpf=opt_io_other_file;
	return do_io_load();
}

int cleanup_io_load(void)
{
	if(unlink(opt_tmpf)){
		printsys("error unlinking %s\n", opt_tmpf);
	}
	return 0;
}

int cleanup_io_other(void)
{
	char *tmp;

	tmp=opt_tmpf;
	opt_tmpf=opt_io_other_file;
	cleanup_io_load();
	opt_tmpf=tmp;
	return 0;
}
