/* coolquery.c - simple example usage of the coolwidget X API
   Copyright (C) 1996-2000 Paul Sheer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.
 */

#include <coolwidget.h>
#include "cmdlineopt.h"
#include "pool.h"
#include "mad.h"

/* {{{ command-line options */

#ifdef HAVE_DND
extern int option_dnd_version;
#endif

/* main and first window */
Window main_window = 0;

/* shell command to run */
extern char *option_man_cmdline;

/* argv[0] */
char *argv_nought = 0;

/* font from the library */
extern char *init_font;

/* server from command line */
char *option_display = 0;

/* font from the command line */
char *option_font = "-*-helvetica-bold-r-*--14-*-*-*-p-*-iso8859-1";

static int get_help = 0;
static int get_version = 0;

/* other things on the command line */
static char *command_line_args[] =
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

void usage (void)
{
    printf (\
	    _ ("Coolquery version %s\nUsage:\n" \
	       "Coolquery [options] <Message-Header> <button1> <button2> ...\n" \
	       "-d, -display <display>                   the X server to display on\n" \
	       "-f, -fn, -font <font-name>               default: 8x13bold\n" \
	       "-h, -H, -?, --help                       print this message to stdout\n" \
	       "-V, -v, --version                        print versiom info\n" \
	       "Coolquery reads from stdin and makes a query box\n" \
	       "\n"), \
	    VERSION);
}

void version (void)
{
    printf (_ ("Coolquery version %s\n"), VERSION);
}

struct prog_options coolquery_options[] =
{
    {' ', "", "", ARG_STRINGS, 0, command_line_args, 0},
#ifdef HAVE_DND
    {0, "-dnd-old", "--dnd-old", ARG_CLEAR, 0, 0, &option_dnd_version},
#endif
    {'f', "-fn", "-font", ARG_STRING, &option_font, 0, 0},
    {'h', "-?", "--help", ARG_SET, 0, 0, &get_help},
    {'H', "-help", "--help", ARG_SET, 0, 0, &get_help},
    {'V', "-v", "--version", ARG_SET, 0, 0, &get_version},
    {'d', "", "-display", ARG_STRING, &option_display, 0, 0},
    {0, 0, 0, 0, 0, 0, 0}
};

/* here we use our own function (which is better than get_opt() or get_opt_long()) */
static void process_command_line (int argc, char **argv)
{
    int error;
    error = get_cmdline_options (argc, argv, coolquery_options);

    if (error) {
	fprintf (stderr, _ ("%s: error processing commandline argument %d\n"), argv[0], error);
	usage ();
	exit (1);
    }
    if (get_help)
	usage ();
    if (get_version)
	version ();
    if (get_help || get_version)
	exit (0);
}

/* }}} command-line options */


void load_trivial_options (void);

int main (int argc, char **argv)
{
    POOL *p;
    CInitData coolquery_startup;
    char *header = 0;
    int i;

    setlocale (LC_CTYPE, "");
    setlocale (LC_TIME, "");
    setlocale (LC_MESSAGES, "");
    bindtextdomain (PACKAGE, LOCALEDIR);
    textdomain (PACKAGE);

    load_trivial_options ();

    process_command_line (argc, argv);

/* initialise the library */
    memset (&coolquery_startup, 0, sizeof (coolquery_startup));
    coolquery_startup.name = argv[0];
    coolquery_startup.display = option_display;
    coolquery_startup.font = option_font;
    CInitialise (&coolquery_startup);
    CDrawMainWindow ("dummy", "dummy");

    p = pool_init ();
    for (;;) {
	int c;
	char ch;
	c = fgetc (stdin);
	if (c < 0)
	    break;
	ch = c;
	pool_write (p, (unsigned char *) &c, 1);
    }
    pool_null (p);

    if (!pool_length (p))
	exit (0);

    if (command_line_args[0]) {
	header = (char *) strdup (command_line_args[0]);
    } else {
	CShutdown ();
	exit (1);
    }

    i = CQueryDialog (CRoot, 20, 20, header, (char *) pool_break (p),
	command_line_args[1], command_line_args[2], command_line_args[3],
	command_line_args[4], command_line_args[5], command_line_args[6],
	command_line_args[7], command_line_args[8], command_line_args[9],
		  command_line_args[10]);

    if (i < 0)
	printf ("-1\n");
    else
	printf ("%s\n", command_line_args[i+1]);

#if 0
    CTextboxMessageDialog (CRoot, 20, 20, 80, 25, header, (char *) pool_break (p), 0);
#endif
/* close connection to the X display */
    CShutdown ();
    exit (1);
    return 0;
}

