// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000, 2001 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// extwindow.h - extended window classes
//
// Changes:
//   23-06-2001 - added ProgressWindow
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_EXTWINDOW_H
#define _INCLUDE_EXTWINDOW_H

#include "window.h"
#include "button.h"
#include "textbox.h"

// window to display a text and two buttons to get a response from the user (e.g. "OK", "Cancel")
class RequestWindow : public Window {
public:
  RequestWindow( const char *msg, const char *txt1, const char *txt0, short def, View *view );

  ButtonWidget *button1;
  ButtonWidget *button0;
};


// simple window with a short message (used e.g. at the start of each turn)
class NoteWindow : public Window {
public:
  NoteWindow( const char *title, const char *note, unsigned short flags, View *view );
  virtual void Draw( void );

  TextWidget *textbox;
  ButtonWidget *button;

private:
  const char *title;
};


// message window with a textscroll widget and a button
class MessageWindow : public Window {
public:
  MessageWindow( const char *title, const char *msg, View *view );
  virtual void Draw( void );
  void SetTitle( const char *title ) { this->title = title; }

  ButtonWidget *button;
  TextScrollWidget *textscroll;

private:
  const char *title;
};


// password window
class PasswordWindow : public Window {
public:
  PasswordWindow( const char *title, const char *msg,
                  const char *pass, View *view );
  virtual void Draw( void );

  bool PasswordOk( void ) const;
  void NewPassword( const char *pass );

  ButtonWidget *button;
  StringWidget *string;

private:
  const char *password;
  const char *title;
};


// progress window
class ProgressWindow : public Window {
public:
  ProgressWindow( short x, short y, unsigned short w,
                  unsigned short h, short pmin, short pmax,
                  unsigned short flags, bool abort, View *view );

  bool Aborted( void );

  ButtonWidget *button;
  ProgressWidget *progress;
};


// menu window
#define MENU_ITEM_SEPARATOR  ((char *)-1)    // just draw a separator

class MenuWindow : public Window {
public:
  MenuWindow( const char *title, const char **labels,
              ButtonHook *hook, short firstid, View *view );
  virtual void Draw( void );

private:
  const char *title;
  const char **labels;
  unsigned short hspacing;
  unsigned short barheight;
};



class TacticalWindow : public Window {
public:
  TacticalWindow( View *view );
  ~TacticalWindow( void );

  void Draw( void );
  GUI_Status HandleEvent( const SDL_Event &event );

private:
  void DrawTacticalMap( Surface *dest, short x, short y, unsigned char magnify ) const;
  void DrawViewport( void );
  void CalcViewport( void );

  unsigned char magnify;
  Surface *mapbuffer;
  Rect map;
  Rect viewport;
};

#endif	/* _INCLUDE_EXTWINDOW_H */

