// Description:
//   main. Ready, set, go!
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#include "SDL.h" //needed for SDL_main

#include <Trace.hpp>
#include <Constants.hpp>
#include <Config.hpp>
#include <Input.hpp>
#include <Game.hpp>
#include <GameState.hpp>
#include <Endian.hpp>
#include <ResourceManager.hpp>
#include <GetDataPath.hpp>

void checkEndian( void)
{
    if( ::isLittleEndian())
    {
	LOG_INFO << "Setting up for little endian." << endl;
    }
    else
    {
	LOG_INFO << "Setting up for big endian." << endl;
    }
}

void showInfo()
{
    LOG_INFO << "----------------------------------" << endl;
    LOG_INFO << GAMETITLE << " " << GAMEVERSION 
             << " - "__TIME__" "__DATE__
             << endl;
    LOG_INFO << "Copyright (C) 2001-2004 by Frank Becker" << endl;
    LOG_INFO << "Visit http://criticalmass.sourceforge.net" << endl;
    LOG_INFO << "----------------------------------" << endl;
}

#include <png.h>
void showVersions( void)
{
    const SDL_version *vsdl = SDL_Linked_Version();
    LOG_INFO << "SDL Version " 
             << (int)vsdl->major  << "."
             << (int)vsdl->minor  << "."
             << (int)vsdl->patch  << endl;
     LOG_INFO << "zlib Version " << zlibVersion() << endl;
     LOG_INFO << "PNG Version " << png_get_header_version(NULL) << endl;
}
 
int main( int argc, char *argv[])
{
    XTRACE();

    showInfo();
    showVersions();

    checkEndian();
    if( !ResourceManagerS::instance()->
	  addResourcePack("resource.dat", getDataPath()))
    {
	LOG_WARNING << "resource.dat not found. Trying data directory." << endl;
#ifdef VCPP
	ResourceManagerS::instance()->addResourceDirectory( "..\\data");
#else
	ResourceManagerS::instance()->addResourceDirectory( "data");
#endif
	if( ResourceManagerS::instance()->getResourceSize("system/config.txt") < 0)
	{
	    LOG_ERROR << "Sorry, unable to find game data!" << endl;
	    return -1;
	}
    }

    Config *cfg = ConfigS::instance();

    // register config handler(s)
    cfg->registerConfigHandler( InputS::instance()->preinit());

    // read config file...
    cfg->updateFromFile();

    // process command line arguments...
    cfg->updateFromCommandLine( argc, argv);

    // to dump or not to dump...
    cfg->getBoolean( "developer", GameState::isDeveloper);
    if( GameState::isDeveloper)
    {
	cfg->dump();
    }

    // get ready!
    if( GameS::instance()->init())
    {
        // let's go!
	GameS::instance()->run();
    }

    // Fun is over. Cleanup time...
    GameS::cleanup();
    ConfigS::cleanup();

    LOG_INFO << "Cleanup complete. Ready to Exit." << endl;

    showInfo();

    // See ya!
    return 0;
}
