<CsoundSynthesizer>
<CsOptions>
; Select audio/midi flags here according to platform
; Audio out   Audio in    No messages
-odac           -iadc     -d   -M0     ;;;RT audio I/O, midi in
; For Non-realtime ouput leave only the line below:
; -o sfload.wav -W ;;; for file output any platform
</CsOptions>
<CsInstruments>

sr         = 44100
ksmps = 100
nchnls = 2
; load two soundfonts
isf	sfload	"07AcousticGuitar.sf2"
ir	sfload	"01hpschd.sf2"
	sfpassign	0, isf	
	sfpassign	1, ir

	instr 1
; play from score and midi keyboard (=midi channel 1)
	mididefault		60, p3
	midinoteonkey	p4, p5
inum	init	p4
ivel	init	p5
print	ivel

ivel	init	3*(ivel/127)					; velocity-dependent
kamp	linsegr	1,1,1,.1,0
kfreq	init	1						;do not change freq from sf
a1,a2	sfplay3	ivel, inum, kamp*ivel, kfreq, 0, 0
	outs	a1, a2
	
	endin
	
		instr 2
; play from score and midi keyboard (=midi channel 2)
	mididefault		60, p3
	midinoteonkey	p4, p5
inum	init	p4
ivel	init	p5
print	ivel

ivel	init	10*(ivel/127)				; 01hpschd.sf2 needs extra volume
kamp	linsegr	1,1,1,.1,0				; velocity-dependent
kfreq	init	1						;do not change freq from sf
a1,a2	sfplay3	ivel, inum, kamp*ivel, kfreq, 1, 0
	outs	a1, a2
	
	endin
	
</CsInstruments>
<CsScore>
f0  60				; stay active for 1 minute

i1 0 1 60 100
i1 + 1 62 <
i1 + 1 65 <
i1 + 1 69 10

i2 5 1 60 100
i2 + 1 62 <
i2 7 1 65 <
i2 7 1 69 10
</CsScore>
</CsoundSynthesizer>
