#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "installer.h"

static struct stat statbuf;

int bin;
int man;

static void diesys(const char* msg)
{
  fprintf(stderr, "installer error: %s:\n  %s\n", msg,
	  sys_errlist[errno]);
  exit(1);
}

static void diefsys(const char* msg, const char* filename)
{
  fprintf(stderr, "installer error: %s '%s':\n  %s\n", msg, filename,
	  sys_errlist[errno]);
  exit(1);
}

static void warn(const char* filename, const char* msg)
{
  printf("instcheck warning: File '%s' %s.\n", filename, msg);
}

static void testmode(int dir, const char* filename,
		     unsigned uid, unsigned gid, unsigned mode, unsigned type)
{
  if (fchdir(dir) == -1)
    diesys("Could not change base directory");
  if (stat(filename, &statbuf) == -1) {
    if (errno == ENOENT)
      warn(filename, "is missing");
    else
      diefsys("Could not stat file", filename);
  }
  if ((statbuf.st_mode & S_IFMT) != type)
    warn(filename, "is the wrong type of file");
  if (uid != (unsigned)-1 && statbuf.st_uid != uid)
    warn(filename, "has wrong owner");
  if (gid != (unsigned)-1 && statbuf.st_gid != gid)
    warn(filename, "has wrong group");
  if ((statbuf.st_mode & 07777) != mode)
    warn(filename, "has wrong permissions");
}

void c(int dir, const char* filename,
       unsigned uid, unsigned gid, unsigned mode)
{
  testmode(dir, filename, uid, gid, mode, S_IFREG);
}

int d(int dir, const char* subdir,
      unsigned uid, unsigned gid, unsigned mode)
{
  testmode(dir, subdir, uid, gid, mode, S_IFDIR);
  return opendir(subdir);
}

int opendir(const char* dir)
{
  int fd;
  if (chdir(dir) == -1)
    diefsys("Could not change directory to", dir);
  if ((fd = open(".", O_RDONLY)) == -1)
    diefsys("Could not open directory", dir);
  return fd;
}

int opensubdir(int dir, const char* subdir)
{
  if (fchdir(dir) == -1)
    diesys("Could not change base directory in opensubdir");
  return opendir(subdir);
}

int main(void)
{
  insthier();
  return 0;
}
