% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI-package.R
\docType{package}
\name{DBI-package}
\alias{DBI}
\alias{DBI-package}
\title{R Database Interface}
\description{
A database interface definition for communication
between R and relational database management systems.  All
classes in this package are virtual and need to be extended by
the various R/DBMS implementations.
}
\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "iris", iris)
dbGetQuery(con, "SELECT * FROM iris WHERE [Petal.Width] > 2.3")

dbDisconnect(con)
}
\seealso{
Important generics: \code{\link{dbConnect}}, \code{\link{dbGetQuery}},
  \code{\link{dbWriteTable}}, \code{\link{dbDisconnect}}

  Formal specification (currently work in progress and incomplete):
  \link{DBIspec}
}

