/* screenop.c - screen/display bits for dcd
 * (C) 1999 David E. Smith (dave@technopagan.org)
 * Released under GNU GPL, see `COPYING' for details.
 */

#include "screenop.h"
#include "version.h"
#include "libcdplay.h"
#include "dcd.h"
#include "cdindex.h"
#include <unistd.h>
#include <stdio.h>

void disk_directory(void) {
  u_char ct = cd_current_track();
  u_char trackz = cd_last_track();
  char *trackname;
  int disc_length = cd_disc_length();
  int cdi_stat = cdi_status();
  int i;

  printf ("Track  Time  (%i tracks / %2i:%02i)",
          trackz, disc_length/60, disc_length%60);
  /* if (cdi_stat == CDI_OK) printf (" (ID %s)", cd_discid()); */
  printf ("\n");
  for (i=1; i<=trackz; i++) {
    int track_length = cd_track_length(i);
    printf ("%s %2i  %2i:%02i", (i==ct ? "*" : " "),
            i, (track_length/60),
            (track_length%60));
    if (cdi_stat == CDI_OK) {
      trackname = cdi_trackname(i);
      printf ("  %1.64s", trackname);
      if((strlen(trackname)) > 64) printf("\n");
    }
    if ((cd_data_track(i)) && (cdi_stat == CDI_NONE)) printf (" (Data)");
    /* tracknames include \n, and data tracks are identified as such */
    if (cdi_stat == CDI_NONE) printf ("\n"); /* tracknames include \n */
  } /* for */
}

void print_status(void) {
  int disc_length, track_length, current_track, last_track, disc_status;
  disc_length = cd_disc_length();
  last_track = cd_last_track();
  current_track = cd_current_track();
  disc_status = cd_hw_status();
  if (0 == current_track) {
    printf ("Not playing (%i tracks, %i:%02i)\n", last_track,
             disc_length/60, disc_length%60);
    return;
  }
  track_length = cd_track_length(current_track);
  printf ("Playing track %i (of %i), length %i:%02i (of %i:%02i)",
           current_track, last_track, track_length/60, track_length%60,
           disc_length/60, disc_length%60);
  printf ("\n");
}

void short_help (void) {
  printf ("%s\n", VERSION);
  printf ("\n");
  printf ("For a complete list of options, try `%s help'.\n", PROGNAME);
  printf ("Options include: Back-track, Dir, Eject, Forward-track, Help,\n");
  printf ("   Info, Loop, Pause, Random, Stop, Version.\n");
  printf ("(For the above commands, only the first letter is required.\n");
}

void print_help (void) {
  printf ("%s\n", VERSION);
  printf ("\n");
  printf ("This program is released to the public with NO WARRANTY under the\n");
  printf ("GNU General Public License. See `COPYING' in the %s distribution\n", PROGNAME);
  printf ("for details.\n\n");
  printf ("Usage: %s [options] [tracklist]\n", PROGNAME);
  printf ("The following options cause %s to exit immediately:\n", PROGNAME);
  printf ("      d   dir      lists the CD directory\n");
  printf ("      e   eject    opens the CD tray\n");
  printf ("      h   help     displays this message :-)\n");
  printf ("      i   info     minimal info/status of current CD\n");
  printf ("      p   pause    pause/resume the CD\n");
  printf ("      s   stop     stops the CD player\n");
  printf ("      v   version  displays software version\n");
  printf ("      f   forward  play the next track on CD\n");
  printf ("      b   back     play the previous track on CD\n");
  printf ("      k   kill     kill all known instances of %s\n", PROGNAME);
  printf ("\n");
  printf ("These options are for using the CD Index (http://www.cdindex.org/):\n");
  printf ("      c   connect   toggles network availability status (Default: %s)\n", NETWORK_CAPABLE ? "Enabled" : "Disabled");
  printf ("      x   cdindex   display discid for current CD\n");
  printf ("      u   url       display request URL for current CD\n");
  printf ("\n");
  printf ("These options are for programming %s like a CD player:\n", PROGNAME);
  printf ("      l   loop    loop the listed tracks (or CD if none given)\n");  
  printf ("      r   random  plays random track from the CD\n");
  printf ("      q   quit    Don't detach from console until finished\n");
  printf ("\n");
  printf ("These are miscellaneous options, intended mainly for shell scripting:\n");
  printf ("      a   firstrk  Echo the first track number to stdout\n");
  printf ("      z   last-trk Echo the last track number to stdout\n");
} /* help */

void print_discid (void) {
  printf ("%s\n", cd_discid());
}

void print_disc_url (void) {
  printf ("http://www.cdindex.org/cgi-bin/cdi/get.pl?id=");
  print_discid();
}

void print_sub_url (void) {
  printf ("%s\n", cd_subid());
}

void dcd_version (void) {
  printf ("%s\n", VERSION);
  printf ("Compiled on %s with the following options:\n", __DATE__);
  printf ("CD-ROM device is %s\n", CDROM_DEVICE);
  if (EXTRA_SLEEP_TIME > 0)
    printf ("Sleep time: %i seconds\n", EXTRA_SLEEP_TIME);
  printf ("CD Index cache directory: $HOME/%s\n", CDINDEX_HOME);
  printf ("Network status default: %s\n",
           NETWORK_CAPABLE ? "Enabled" : "Disabled");
}
