## -*- perl -*-
## ----------------------------------------------------------------------
## DebianDoc_SGML/Map/LaTeX: LaTeX output format data map
## ----------------------------------------------------------------------
## Copyright (C) 1999-2002 Ardo van Rangelrooij
##
## This is free software; see the GNU General Public Licence
## version 2 or later for copying conditions.  There is NO warranty.
## ----------------------------------------------------------------------

## ----------------------------------------------------------------------
## package interface definition
#package DebianDoc_SGML::Map::LaTeX;
#use strict;
#use vars qw( @ISA @EXPORT );
#use Exporter;
#@ISA = ( 'Exporter' );
#@EXPORT = qw ();

## ----------------------------------------------------------------------
%cdata = (
	  );

## ----------------------------------------------------------------------
%sdata = (

	  ## ISO 8879:1986//ENTITIES Added Latin 1//EN
	  "[aacute]" => "\\'{a}",
	  "[Aacute]" => "\\'{A}",
	  "[acirc ]" => "\\^{a}",
	  "[Acirc ]" => "\\^{A}",
	  "[agrave]" => "\\`{a}",
	  "[Agrave]" => "\\`{A}",
	  "[aring ]" => "\\r{a}",
	  "[Aring ]" => "\\r{A}",
	  "[atilde]" => "\\~{a}",
	  "[Atilde]" => "\\~{A}",
	  "[auml  ]" => "\\\"{a}",
	  "[Auml  ]" => "\\\"{A}",
	  "[aelig ]" => "\\ae{}",
	  "[AElig ]" => "\\AE{}",
	  "[ccedil]" => "\\c{c}",
	  "[Ccedil]" => "\\c{C}",
	  "[eth   ]" => "[eth]",
	  "[ETH   ]" => "[ETH]",
	  "[eacute]" => "\\'{e}",
	  "[Eacute]" => "\\'{E}",
	  "[ecirc ]" => "\\^{e}",
	  "[Ecirc ]" => "\\^{E}",
	  "[egrave]" => "\\`{e}",
	  "[Egrave]" => "\\`{E}",
	  "[euml  ]" => "\\\"{e}",
	  "[Euml  ]" => "\\\"{E}",
	  "[iacute]" => "\\'{\\i}",
	  "[Iacute]" => "\\'{I}",
	  "[icirc ]" => "\\^{\\i}",
	  "[Icirc ]" => "\\^{I}",
	  "[igrave]" => "\\`{\\i}",
	  "[Igrave]" => "\\`{I}",
	  "[iuml  ]" => "\\\"{\\i}",
	  "[Iuml  ]" => "\\\"{I}",
	  "[ntilde]" => "\\~{n}",
	  "[Ntilde]" => "\\~{N}",
	  "[oacute]" => "\\'{o}",
	  "[Oacute]" => "\\'{O}",
	  "[ocirc ]" => "\\^{o}",
	  "[Ocirc ]" => "\\^{O}",
	  "[ograve]" => "\\`{o}",
	  "[Ograve]" => "\\`{O}",
	  "[oslash]" => "\\o{}",
	  "[Oslash]" => "\\O{}",
	  "[otilde]" => "\\~{o}",
	  "[Otilde]" => "\\~{O}",
	  "[ouml  ]" => "\\\"{o}",
	  "[Ouml  ]" => "\\\"{O}",
	  "[szlig ]" => "\\ss{}",
	  "[thorn ]" => "[thorn]",
	  "[THORN ]" => "[THORN]",
	  "[uacute]" => "\\'{u}",
	  "[Uacute]" => "\\'{U}",
	  "[ucirc ]" => "\\^{u}",
	  "[Ucirc ]" => "\\^{U}",
	  "[ugrave]" => "\\`{u}",
	  "[Ugrave]" => "\\`{U}",
	  "[uuml  ]" => "\\\"{u}",
	  "[Uuml  ]" => "\\\"{U}",
	  "[yacute]" => "\\'{y}",
	  "[Yacute]" => "\\'{Y}",
	  "[yuml  ]" => "\\\"{y}",

	  ## ISO 8879:1986//ENTITIES Added Latin 2//EN
	  "[abreve]" => "\\u{a}",
	  "[Abreve]" => "\\u{A}",
	  "[amacr ]" => "\\={a}",
	  "[Amacr ]" => "\\={A}",
	  "[aogon ]" => "\\k{a}",
	  "[Aogon ]" => "\\k{A}",
	  "[cacute]" => "\\'{c}",
	  "[Cacute]" => "\\'{C}",
	  "[ccaron]" => "\\v{c}",
	  "[Ccaron]" => "\\v{C}",
	  "[ccirc ]" => "\\^{c}",
	  "[Ccirc ]" => "\\^{C}",
	  "[cdot  ]" => "\\.{c}",
	  "[Cdot  ]" => "\\.{C}",
	  "[dcaron]" => "\\v{d}",
	  "[Dcaron]" => "\\v{D}",
	  "[dstrok]" => "\\dj{}",
	  "[Dstrok]" => "\\DJ{}",
	  "[ecaron]" => "\\v{e}",
	  "[Ecaron]" => "\\v{E}",
	  "[edot  ]" => "\\.{e}",
	  "[Edot  ]" => "\\.{E}",
	  "[emacr ]" => "\\={e}",
	  "[Emacr ]" => "\\={E}",
	  "[eogon ]" => "\\k{e}",
	  "[Eogon ]" => "\\k{E}",
	  "[gacute]" => "\\'{g}",
	  "[gbreve]" => "\\u{g}",
	  "[Gbreve]" => "\\u{G}",
	  "[Gcedil]" => "\\c{G}",
	  "[gcirc ]" => "\\^{g}",
	  "[Gcirc ]" => "\\^{G}",
	  "[gdot  ]" => "\\.{g}",
	  "[Gdot  ]" => "\\.{G}",
	  "[hcirc ]" => "\\^{h}",
	  "[Hcirc ]" => "\\^{H}",
	  "[hstrok]" => "[hstrok]",
	  "[Hstrok]" => "[Hstrok]",
	  "[Idot  ]" => "\\.{I}",
	  "[Imacr ]" => "\\={\\i}",
	  "[imacr ]" => "\\={I}",
	  "[ijlig ]" => "ij",
	  "[IJlig ]" => "IJ",
	  "[inodot]" => "\\i",
	  "[iogon ]" => "\\k{i}",
	  "[Iogon ]" => "\\k{I}",
	  "[itilde]" => "\\~{\\i}",
	  "[Itilde]" => "\\~{I}",
	  "[jcirc ]" => "[jcirc]",
	  "[Jcirc ]" => "\\^{J}",
	  "[kcedil]" => "\\c{k}",
	  "[Kcedil]" => "\\c{K}",
	  "[kgreen]" => "\\textsc{k}",
	  "[lacute]" => "\\'{l}",
	  "[Lacute]" => "\\'{L}",
	  "[lcaron]" => "\\v{l}",
	  "[Lcaron]" => "\\v{L}",
	  "[lcedil]" => "\\c{l}",
	  "[Lcedil]" => "\\c{L}",
	  "[lmidot]" => "[lmidot]",
	  "[Lmidot]" => "[Lmidot]",
	  "[lstrok]" => "\\l{}",
	  "[Lstrok]" => "\\L{}",
	  "[nacute]" => "\\'{n}",
	  "[Nacute]" => "\\'{N}",
	  "[eng   ]" => "[eng]",
	  "[ENG   ]" => "[ENG]",
	  "[napos ]" => "[napos]",
	  "[ncaron]" => "\\v{n}",
	  "[Ncaron]" => "\\v{N}",
	  "[ncedil]" => "\\c{n}",
	  "[Ncedil]" => "\\c{N}",
	  "[odblac]" => "\\H{o}",
	  "[Odblac]" => "\\H{O}",
	  "[omacr ]" => "\\={o}",
	  "[Omacr ]" => "\\={O}",
	  "[oelig ]" => "\\oe{}",
	  "[OElig ]" => "\\OE{}",
	  "[racute]" => "\\'{r}",
	  "[Racute]" => "\\'{R}",
	  "[rcaron]" => "\\v{r}",
	  "[Rcaron]" => "\\v{R}",
	  "[rcedil]" => "\\c{r}",
	  "[Rcedil]" => "\\c{R}",
	  "[sacute]" => "\\'{s}",
	  "[Sacute]" => "\\'{S}",
	  "[scaron]" => "\\v{s}",
	  "[Scaron]" => "\\v{S}",
	  "[scedil]" => "\\c{s}",
	  "[Scedil]" => "\\c{S}",
	  "[scirc ]" => "\\^{s}",
	  "[Scirc ]" => "\\^{S}",
	  "[tcaron]" => "\\v{t}",
	  "[Tcaron]" => "\\v{T}",
	  "[tcedil]" => "\\c{t}",
	  "[Tcedil]" => "\\c{T}",
	  "[tstrok]" => "[tstrok]",
	  "[Tstrok]" => "[Tstrok]",
	  "[ubreve]" => "\\u{u}",
	  "[Ubreve]" => "\\u{U}",
	  "[udblac]" => "\\H{u}",
	  "[Udblac]" => "\\H{U}",
	  "[umacr ]" => "\\={u}",
	  "[Umacr ]" => "\\={U}",
	  "[uogon ]" => "\\k{u}",
	  "[Uogon ]" => "\\k{U}",
	  "[uring ]" => "\\r{u}",
	  "[Uring ]" => "\\r{U}",
	  "[utilde]" => "\\~{u}",
	  "[Utilde]" => "\\~{U}",
	  "[wcirc ]" => "\\^{w}",
	  "[Wcirc ]" => "\\^{W}",
	  "[ycirc ]" => "\\^{y}",
	  "[Ycirc ]" => "\\^{Y}",
	  "[Yuml  ]" => "\\\"{Y}",
	  "[zacute]" => "\\'{z}",
	  "[Zacute]" => "\\'{Z}",
	  "[zcaron]" => "\\v{z}",
	  "[Zcaron]" => "\\v{Z}",
	  "[zdot  ]" => "\\.{z}",
	  "[Zdot  ]" => "\\.{Z}",

	  ## ISO 8879:1986//ENTITIES Greek Letters//EN
	  "[agr   ]" => "[agr]",
	  "[Agr   ]" => "[Agr]",
	  "[bgr   ]" => "[bgr]",
	  "[Bgr   ]" => "[Bgr]",
	  "[ggr   ]" => "[ggr]",
	  "[Ggr   ]" => "[Ggr]",
	  "[dgr   ]" => "[dgr]",
	  "[Dgr   ]" => "[Dgr]",
	  "[egr   ]" => "[egr]",
	  "[Egr   ]" => "[Egr]",
	  "[zgr   ]" => "[zgr]",
	  "[Zgr   ]" => "[Zgr]",
	  "[eegr  ]" => "[eegr]",
	  "[EEgr  ]" => "[EEgr]",
	  "[thgr  ]" => "[thgr]",
	  "[THgr  ]" => "[THgr]",
	  "[igr   ]" => "[igr]",
	  "[Igr   ]" => "[Igr]",
	  "[kgr   ]" => "[kgr]",
	  "[Kgr   ]" => "[Kgr]",
	  "[lgr   ]" => "[lgr]",
	  "[Lgr   ]" => "[Lgr]",
	  "[mgr   ]" => "[mgr]",
	  "[Mgr   ]" => "[Mgr]",
	  "[ngr   ]" => "[ngr]",
	  "[Ngr   ]" => "[Ngr]",
	  "[xgr   ]" => "[xgr]",
	  "[Xgr   ]" => "[Xgr]",
	  "[ogr   ]" => "[ogr]",
	  "[Ogr   ]" => "[Ogr]",
	  "[pgr   ]" => "[pgr]",
	  "[Pgr   ]" => "[Pgr]",
	  "[rgr   ]" => "[rgr]",
	  "[Rgr   ]" => "[Rgr]",
	  "[sgr   ]" => "[sgr]",
	  "[Sgr   ]" => "[Sgr]",
	  "[sfgr  ]" => "[sfgr]",
	  "[tgr   ]" => "[tgr]",
	  "[Tgr   ]" => "[Tgr]",
	  "[ugr   ]" => "[ugr]",
	  "[Ugr   ]" => "[Ugr]",
	  "[phgr  ]" => "[phgr]",
	  "[PHgr  ]" => "[PHgr]",
	  "[khgr  ]" => "[khgr]",
	  "[KHgr  ]" => "[KHgr]",
	  "[psgr  ]" => "[psgr]",
	  "[PSgr  ]" => "[PSgr]",
	  "[ohgr  ]" => "[ohgr]",
	  "[OHgr  ]" => "[OHgr]",

	  ## ISO 8879:1986//ENTITIES Monotoniko Greek//EN
	  "[aacgr ]" => "[aacgr]",
	  "[Aacgr ]" => "[Aacgr]",
	  "[eacgr ]" => "[eacgr]",
	  "[Eacgr ]" => "[Eacgr]",
	  "[eeacgr]" => "[eeacgr]",
	  "[EEacgr]" => "[EEacgr]",
	  "[idigr ]" => "[idigr]",
	  "[Idigr ]" => "[Idigr]",
	  "[iacgr ]" => "[iacgr]",
	  "[Iacgr ]" => "[Iacgr]",
	  "[idiagr]" => "[idiagr]",
	  "[oacgr ]" => "[oacgr]",
	  "[Oacgr ]" => "[Oacgr]",
	  "[udigr ]" => "[udigr]",
	  "[Udigr ]" => "[Udigr]",
	  "[uacgr ]" => "[uacgr]",
	  "[Uacgr ]" => "[Uacgr]",
	  "[udiagr]" => "[udiagr]",
	  "[ohacgr]" => "[ohacgr]",
	  "[OHacgr]" => "[OHacgr]",

	  ## ISO 8879:1986//ENTITIES Russian Cyrillic//EN
	  "[acy   ]" => "[acy]",
	  "[Acy   ]" => "[Acy]",
	  "[bcy   ]" => "[bcy]",
	  "[Bcy   ]" => "[Bcy]",
	  "[vcy   ]" => "[vcy]",
	  "[Vcy   ]" => "[Vcy]",
	  "[gcy   ]" => "[gcy]",
	  "[Gcy   ]" => "[Gcy]",
	  "[dcy   ]" => "[dcy]",
	  "[Dcy   ]" => "[Dcy]",
	  "[iecy  ]" => "[iecy]",
	  "[IEcy  ]" => "[IEcy]",
	  "[iocy  ]" => "[iocy]",
	  "[IOcy  ]" => "[IOcy]",
	  "[zhcy  ]" => "[zhcy]",
	  "[ZHcy  ]" => "[ZHcy]",
	  "[zcy   ]" => "[zcy]",
	  "[Zcy   ]" => "[Zcy]",
	  "[icy   ]" => "[icy]",
	  "[Icy   ]" => "[Icy]",
	  "[jcy   ]" => "[jcy]",
	  "[Jcy   ]" => "[Jcy]",
	  "[kcy   ]" => "[kcy]",
	  "[Kcy   ]" => "[Kcy]",
	  "[lcy   ]" => "[lcy]",
	  "[Lcy   ]" => "[Lcy]",
	  "[mcy   ]" => "[mcy]",
	  "[Mcy   ]" => "[Mcy]",
	  "[ncy   ]" => "[ncy]",
	  "[Ncy   ]" => "[Ncy]",
	  "[ocy   ]" => "[ocy]",
	  "[Ocy   ]" => "[Ocy]",
	  "[pcy   ]" => "[pcy]",
	  "[Pcy   ]" => "[Pcy]",
	  "[rcy   ]" => "[rcy]",
	  "[Rcy   ]" => "[Rcy]",
	  "[scy   ]" => "[scy]",
	  "[Scy   ]" => "[Scy]",
	  "[tcy   ]" => "[tcy]",
	  "[Tcy   ]" => "[Tcy]",
	  "[ucy   ]" => "[ucy]",
	  "[Ucy   ]" => "[Ucy]",
	  "[fcy   ]" => "[fcy]",
	  "[Fcy   ]" => "[Fcy]",
	  "[khcy  ]" => "[khcy]",
	  "[KHcy  ]" => "[KHcy]",
	  "[tscy  ]" => "[tscy]",
	  "[TScy  ]" => "[TScy]",
	  "[chcy  ]" => "[chcy]",
	  "[CHcy  ]" => "[CHcy]",
	  "[shcy  ]" => "[shcy]",
	  "[SHcy  ]" => "[SHcy]",
	  "[shchcy]" => "[shchcy]",
	  "[SHCHcy]" => "[SHCHcy]",
	  "[hardcy]" => "[hardcy]",
	  "[HARDcy]" => "[HARDcy]",
	  "[ycy   ]" => "[ycy]",
	  "[Ycy   ]" => "[Ycy]",
	  "[softcy]" => "[softcy]",
	  "[SOFTcy]" => "[SOFTcy]",
	  "[ecy   ]" => "[ecy]",
	  "[Ecy   ]" => "[Ecy]",
	  "[yucy  ]" => "[yucy]",
	  "[YUcy  ]" => "[YUcy]",
	  "[yacy  ]" => "[yacy]",
	  "[YAcy  ]" => "[YAcy]",
	  "[numero]" => "[numero]",

	  ## ISO 8879:1986//ENTITIES Non-Russian Cyrillic//EN
	  "[djcy  ]" => "[djcy]",
	  "[DJcy  ]" => "[DJcy]",
	  "[gjcy  ]" => "[gjcy]",
	  "[GJcy  ]" => "[GJcy]",
	  "[jukcy ]" => "[jukcy]",
	  "[Jukcy ]" => "[Jukcy]",
	  "[dscy  ]" => "[dscy]",
	  "[DScy  ]" => "[DScy]",
	  "[iukcy ]" => "[iukcy]",
	  "[Iukcy ]" => "[Iukcy]",
	  "[yicy  ]" => "[yicy]",
	  "[YIcy  ]" => "[YIcy]",
	  "[jsercy]" => "[jsercy]",
	  "[Jsercy]" => "[Jsercy]",
	  "[ljcy  ]" => "[ljcy]",
	  "[LJcy  ]" => "[LJcy]",
	  "[njcy  ]" => "[njcy]",
	  "[NJcy  ]" => "[NJcy]",
	  "[tshcy ]" => "[tshcy]",
	  "[TSHcy ]" => "[TSHcy]",
	  "[kjcy  ]" => "[kjcy]",
	  "[KJcy  ]" => "[KJcy]",
	  "[ubrcy ]" => "[ubrcy]",
	  "[Ubrcy ]" => "[Ubrcy]",
	  "[dzcy  ]" => "[dzcy]",
	  "[DZcy  ]" => "[DZcy]",

	  ## ISO 8879:1986//ENTITIES Numeric and Special Graphic//EN
	  "[half  ]" => "\$\\frac{1}{2}\$",
	  "[frac12]" => "\$\\frac{1}{2}\$",
	  "[frac14]" => "\$\\frac{1}{4}\$",
	  "[frac34]" => "\$\\frac{3}{4}\$",
	  "[frac18]" => "\$\\frac{1}{8}\$",
	  "[frac38]" => "\$\\frac{3}{8}\$",
	  "[frac58]" => "\$\\frac{5}{8}\$",
	  "[frac78]" => "\$\\frac{7}{8}\$",
	  "[sup1  ]" => "\$^1\$",
	  "[sup2  ]" => "\$^2\$",
	  "[sup3  ]" => "\$^3\$",
	  "[plus  ]" => "+",
	  "[plusmn]" => "\$\\pm\$",
	  "[lt    ]" => "\\textless{}",
	  "[equals]" => "=",
	  "[gt    ]" => "\\textgreater{}",
	  "[divide]" => "\\textdiv{}",
	  "[times ]" => "\\texttimes{}",
	  "[curren]" => "\\textcurrency{}",
	  "[pound ]" => "\\textsterling{}",
	  "[dollar]" => "\\textdollar{}",
	  "[cent  ]" => "\\textcent{}",
	  "[yen   ]" => "\\textyen{}",
	  "[num   ]" => "\\#",
	  "[percnt]" => "\\%",
	  "[amp   ]" => "\\&",
	  "[ast   ]" => "\\textasteriskcentered{}",
	  "[commat]" => "@",
	  "[lsqb  ]" => "[",
	  "[bsol  ]" => "\\textbackslash{}",
	  "[rsqb  ]" => "]",
	  "[lcub  ]" => "\\textbraceleft{}",
	  "[horbar]" => "---",
	  "[verbar]" => "\\textbar{}",
	  "[rcub  ]" => "\\textbraceright{}",
	  "[micro ]" => "\\textmu{}",
	  "[ohm   ]" => "[ohm]",
	  "[deg   ]" => "\\textdegree{}",
	  "[ordm  ]" => "\\textordmasculine{}",
	  "[ordf  ]" => "\\textordfeminine{}",
	  "[sect  ]" => "\\textsection{}",
	  "[para  ]" => "\\textparagraph{}",
	  "[middot]" => "\\textperiodcentered{}",
	  "[larr  ]" => "[larr]",
	  "[rarr  ]" => "[rarr]",
	  "[uarr  ]" => "[uarr]",
	  "[darr  ]" => "[darr]",
	  "[copy  ]" => "\\textcopyright{}",
	  "[reg   ]" => "\\textregistered{}",
	  "[trade ]" => "\\texttrademark{}",
	  "[brvbar]" => "\\textbrokenbar{}",
	  "[not   ]" => "\\textlnot{}",
	  "[sung  ]" => "[sung]",
	  "[excl  ]" => "!",
	  "[iexcl ]" => "\\textexclamdown{}",
	  "[quot  ]" => "\\textquotedbl{}",
	  "[apos  ]" => "\\textquotesingle{}",
	  "[lpar  ]" => "(",
	  "[rpar  ]" => ")",
	  "[comma ]" => ",",
	  "[lowbar]" => "\\textunderscore{}",
	  "[hyphen]" => "-",
	  "[period]" => ".",
	  "[sol   ]" => "/",
	  "[colon ]" => ":",
	  "[semi  ]" => ";",
	  "[quest ]" => "?",
	  "[iquest]" => "\\textquestiondown{}",
	  "[laquo ]" => "\\guillemotleft{}",
	  "[raquo ]" => "\\guillemotright{}",
	  "[lsquo ]" => "\\textquoteleft{}",
	  "[rsquo ]" => "\\textquoteright{}",
	  "[ldquo ]" => "\\textquotedblleft{}",
	  "[rdquo ]" => "\\textquotedblright{}",
	  "[nbsp  ]" => "~",
	  "[shy   ]" => "\\-",

	  ## ISO 8879:1986//ENTITIES Diacritical Marks//EN
	  "[acute ]" => "\\textasciiacute{}",
	  "[breve ]" => "\\textasciibreve{}",
	  "[caron ]" => "\\textasciicaron{}",
	  "[cedil ]" => "\\c{}",
	  "[circ  ]" => "\\textasciicircum{}",
	  "[dblac ]" => "\\textacutedbl{}",
	  "[die   ]" => "\\textasciidieresis{}",
	  "[dot   ]" => "[dot]",
	  "[grave ]" => "\\textasciigrave{}",
	  "[macr  ]" => "\\textasciimacron{}",
	  "[ogon  ]" => "\\k{}",
	  "[ring  ]" => "\\textdegree{}",
	  "[tilde ]" => "\\textasciitilde{}",
	  "[uml   ]" => "\\textasciidieresis{}",

	  ## ISO 8879:1986//ENTITIES Publishing//EN
	  "[emsp  ]" => "\\hspace{1em}",
	  "[ensp  ]" => "\\hspace{0.5em}",
	  "[emsp3 ]" => "\\hspace{0.33em}",
	  "[emsp4 ]" => "\\hspace{0.25em}",
	  "[numsp ]" => "\\hphantom{0}",
	  "[puncsp]" => "\\hphantom{,}",
	  "[thinsp]" => "\\hspace{0.167em}",
	  "[hairsp]" => "\\hspace{1pt}",
	  "[mdash ]" => "\\textemdash{}",
	  "[ndash ]" => "\\textendash{}",
	  "[dash  ]" => "-",
	  "[blank ]" => "\\textvisiblespace{}",
	  "[hellip]" => "\\textellipsis{}",
	  "[nldr  ]" => "[nldr]",
	  "[frac13]" => "\$\\frac{1}{3}\$",
	  "[frac23]" => "\$\\frac{2}{3}\$",
	  "[frac15]" => "\$\\frac{1}{5}\$",
	  "[frac25]" => "\$\\frac{2}{5}\$",
	  "[frac35]" => "\$\\frac{3}{5}\$",
	  "[frac45]" => "\$\\frac{4}{5}\$",
	  "[frac16]" => "\$\\frac{1}{6}\$",
	  "[frac56]" => "\$\\frac{5}{6}\$",
	  "[incare]" => "\${^c\\!/\\!_o}\$",
	  "[block ]" => "[block]",
	  "[uhblk ]" => "[uhblk]",
	  "[lhblk ]" => "[lhblk]",
	  "[blk14 ]" => "[blk14]",
	  "[blk12 ]" => "[blk12]",
	  "[blk34 ]" => "[blk34]",
	  "[marker]" => "[marker]",
	  "[cir   ]" => "\$\\circ\$",
	  "[squ   ]" => "[squ]",
	  "[rect  ]" => "[rect]",
	  "[utri  ]" => "[utri]",
	  "[dtri  ]" => "[dtri]",
	  "[star  ]" => "\\ding{73}",
	  "[bull  ]" => "\\textbullet{}",
	  "[squf  ]" => "[squf]",
	  "[utrif ]" => "[utrif]",
	  "[dtrif ]" => "[dtrif]",
	  "[ltrif ]" => "[ltrif]",
	  "[rtrif ]" => "[rtrif]",
	  "[clubs ]" => "\\ding{168}",
	  "[diams ]" => "\\ding{169}",
	  "[hearts]" => "\\ding{170}",
	  "[spades]" => "\\ding{171}",
	  "[malt  ]" => "\\ding{64}",
	  "[dagger]" => "\\textdagger{}",
	  "[Dagger]" => "\\textdaggerdbl{}",
	  "[check ]" => "\\ding{51}",
	  "[ballot]" => "\\ding{55}",
	  "[sharp ]" => "\$\\sharp\$",
	  "[flat  ]" => "\$\\flat\$",
	  "[male  ]" => "\\male{}",
	  "[female]" => "\\female{}",
	  "[phone ]" => "\\phone{}",
	  "[telrec]" => "\\recorder{}",
	  "[copysr]" => "[copysr]",
	  "[caret ]" => "[caret]",
	  "[lsquor]" => "\\quotesinglbase{}",
	  "[ldquor]" => "\\quotedblbase{}",
	  "[fflig ]" => "ff",
	  "[filig ]" => "fi",
	  "[fjlig ]" => "fj",
	  "[ffilig]" => "ffi",
	  "[ffllig]" => "ffl",
	  "[fllig ]" => "fl",
	  "[mldr  ]" => "[mldr]",
	  "[rdquor]" => "\\textquotedblleft{}",
	  "[rsquor]" => "'",
	  "[vellip]" => "\$\\vdots\$",
	  "[hybull]" => "[hybull]",
	  "[loz   ]" => "[loz]",
	  "[lozf  ]" => "[lozf]",
	  "[ltri  ]" => "\$\\triangleleft\$",
	  "[rtri  ]" => "\$\\triangleright\$",
	  "[starf ]" => "[starf]",
	  "[natur ]" => "\$\\natural\$",
	  "[rx    ]" => "[rx]",
	  "[sext  ]" => "\\ding{86}",
	  "[target]" => "[target]",
	  "[dlcrop]" => "[dlcrop]",
	  "[drcrop]" => "[drcrop]",
	  "[ulcrop]" => "[ulcrop]",
	  "[urcrop]" => "[urcrop]",

	  ## ISO 8879:1986//ENTITIES Box and Line Drawing//EN
	  "[boxh  ]" => "[boxh]",
	  "[boxv  ]" => "[boxv]",
	  "[boxur ]" => "[boxur]",
	  "[boxul ]" => "[boxul]",
	  "[boxdl ]" => "[boxdl]",
	  "[boxdr ]" => "[boxdr]",
	  "[boxvr ]" => "[boxvr]",
	  "[boxhu ]" => "[boxhu]",
	  "[boxvl ]" => "[boxvl]",
	  "[boxhd ]" => "[boxhd]",
	  "[boxvh ]" => "[boxvh]",
	  "[boxvR ]" => "[boxvR]",
	  "[boxhU ]" => "[boxhU]",
	  "[boxvL ]" => "[boxvL]",
	  "[boxhD ]" => "[boxhD]",
	  "[boxvH ]" => "[boxvH]",
	  "[boxH  ]" => "[boxH]",
	  "[boxV  ]" => "[boxV]",
	  "[boxUR ]" => "[boxUR]",
	  "[boxUL ]" => "[boxUL]",
	  "[boxDL ]" => "[boxDL]",
	  "[boxDR ]" => "[boxDR]",
	  "[boxVR ]" => "[boxVR]",
	  "[boxHU ]" => "[boxHU]",
	  "[boxVL ]" => "[boxVL]",
	  "[boxHD ]" => "[boxHD]",
	  "[boxVH ]" => "[boxVH]",
	  "[boxVr ]" => "[boxVr]",
	  "[boxHu ]" => "[boxHu]",
	  "[boxVl ]" => "[boxVl]",
	  "[boxHd ]" => "[boxHd]",
	  "[boxVh ]" => "[boxVh]",
	  "[boxuR ]" => "[boxuR]",
	  "[boxUl ]" => "[boxUl]",
	  "[boxdL ]" => "[boxdL]",
	  "[boxDr ]" => "[boxDr]",
	  "[boxUr ]" => "[boxUr]",
	  "[boxuL ]" => "[boxuL]",
	  "[boxDl ]" => "[boxDl]",
	  "[boxdR ]" => "[boxdR]",

	  ## ISO 8879:1986//ENTITIES General Technical//EN
	  "[aleph ]" => "\$\\aleph\$",
	  "[and   ]" => "\$\\land\$",
	  "[ang90 ]" => "[ang90]",
	  "[angsph]" => "[angsph]",
	  "[ap    ]" => "\$\\approx\$",
	  "[becaus]" => "[because]",
	  "[bottom]" => "\$\\bot\$",
	  "[cap   ]" => "\$\\cap\$",
	  "[cong  ]" => "\$\\cong\$",
	  "[conint]" => "\$\\oint\$",
	  "[cup   ]" => "\$\\cup\$",
	  "[equiv ]" => "\$\\equiv\$",
	  "[exist ]" => "\$\\exists\$",
	  "[forall]" => "\$\\forall\$",
	  "[fnof  ]" => "\$f\$",
	  "[ge    ]" => "\$\\ge\$",
	  "[iff   ]" => "\$\\iff\$",
	  "[infin ]" => "\$\\infty\$",
	  "[int   ]" => "\$\\int\$",
	  "[isin  ]" => "\$\\in\$",
	  "[lang  ]" => "\$\\langle\$",
	  "[lArr  ]" => "\$\\Leftarrow\$",
	  "[le    ]" => "\$\\le\$",
	  "[minus ]" => "\$-\$",
	  "[mnplus]" => "\$\\mp\$",
	  "[nabla ]" => "\$\\nabla\$",
	  "[ne    ]" => "\$\\neq\$",
	  "[ni    ]" => "\$\\ni\$",
	  "[or    ]" => "\$\\vee\$",
	  "[par   ]" => "\$\\parallel\$",
	  "[part  ]" => "\$\\partial\$",
	  "[permil]" => "\\textperthousand{}",
	  "[perp  ]" => "\$\\perp\$",
	  "[prime ]" => "\$\\prime\$",
	  "[Prime ]" => "\$\\prime\\prime\$",
	  "[prop  ]" => "\$\\propto\$",
	  "[radic ]" => "\$\\surd\$",
	  "[rang  ]" => "\$\\rangle\$",
	  "[rArr  ]" => "\$\\Rightarrow\$",
	  "[sim   ]" => "\$\\sim\$",
	  "[sime  ]" => "\$\\simeq\$",
	  "[square]" => "\$\\Box\$",
	  "[sub   ]" => "\$\\subset\$",
	  "[sube  ]" => "\$\\subseteq\$",
	  "[sup   ]" => "\$\\supset\$",
	  "[supe  ]" => "\$\\supseteq\$",
	  "[there4]" => "[there4]",
	  "[Verbar]" => "\$\\Vert\$",
	  "[angst ]" => "\\AA{}",
	  "[bernou]" => "\$\\mathcal{B}\$",
	  "[compfn]" => "\$\\circ\$",
	  "[Dot   ]" => "\$\\ddot{}\$",
	  "[DotDot]" => "\$\\ddot{}\\kern4.5pt\\ddot{ }\$",
	  "[hamilt]" => "\$\\mathcal{H}\$",
	  "[lagran]" => "\$\\mathcal{L}\$",
	  "[lowast]" => "\$\\ast\$",
	  "[notin ]" => "\$\\not\\in\$",
	  "[order ]" => "\$\\mathcal{O}\$",
	  "[phmmat]" => "\$\\mathcal{M}\$",
	  "[tdot  ]" => "\$\\ddot{}\\kern 3pt\\dot{ }\$",
	  "[tprime]" => "\$\\prime\\prime\\prime\$",
	  "[wedgeq]" => "\$\\stackrel{\\wedge}{=}\$",

	  ## ISO 8879:1986//ENTITIES Greek Symbols//EN
	  "[alpha ]" => "\$\\alpha\$",
	  "[beta  ]" => "\$\\beta\$",
	  "[gamma ]" => "\$\\gamma\$",
	  "[Gamma ]" => "\$\\Gamma\$",
	  "[gammad]" => "[gammad]",
	  "[delta ]" => "\$\\delta\$",
	  "[Delta ]" => "\$\\Delta\$",
	  "[epsi  ]" => "\$\\epsilon\$",
	  "[epsiv ]" => "\$\\varepsilon\$",
	  "[epsis ]" => "\$\\epsilon\$",
	  "[zeta  ]" => "\$\\zeta\$",
	  "[eta   ]" => "\$\\eta\$",
	  "[thetas]" => "\$\\theta\$",
	  "[Theta ]" => "\$\\Theta\$",
	  "[thetav]" => "\$\\vartheta\$",
	  "[iota  ]" => "\$\\iota\$",
	  "[kappa ]" => "\$\\kappa\$",
	  "[kappav]" => "[kappav]",
	  "[lambda]" => "\$\\lambda\$",
	  "[Lambda]" => "\$\\Lambda\$",
	  "[mu    ]" => "\$\\mu\$",
	  "[nu    ]" => "\$\\nu\$",
	  "[xi    ]" => "\$\\xi\$",
	  "[Xi    ]" => "\$\\Xi\$",
	  "[pi    ]" => "\$\\pi\$",
	  "[piv   ]" => "\$\\varpi\$",
	  "[Pi    ]" => "\$\\Pi\$",
	  "[rho   ]" => "\$\\rho\$",
	  "[rhov  ]" => "\$\\varrho\$",
	  "[sigma ]" => "\$\\sigma\$",
	  "[Sigma ]" => "\$\\Sigma\$",
	  "[sigmav]" => "\$\\varsigma\$",
	  "[tau   ]" => "\$\\tau\$",
	  "[upsi  ]" => "\$\\upsilon\$",
	  "[Upsi  ]" => "\$\\Upsilon\$",
	  "[phis  ]" => "\$\\phi\$",
	  "[Phi   ]" => "\$\\Phi\$",
	  "[phiv  ]" => "\$\\varphi\$",
	  "[chi   ]" => "\$\\chi\$",
	  "[psi   ]" => "\$\\psi\$",
	  "[Psi   ]" => "\$\\Psi\$",
	  "[omega ]" => "\$\\omega\$",
	  "[Omega ]" => "\$\\Omega\$",

	  ## ISO 8879:1986//ENTITIES Alternative Greek Symbols//EN
	  "[b.alpha ]" => "\$\\alpha\$",
	  "[b.beta  ]" => "\$\\beta\$",
	  "[b.gamma ]" => "\$\\gamma\$",
	  "[b.Gamma ]" => "\$\\Gamma\$",
	  "[b.gammad]" => "[b.gammad]",
	  "[b.delta ]" => "\$\\delta\$",
	  "[b.Delta ]" => "\$\\Delta\$",
	  "[b.epsi  ]" => "\$\\epsilon\$",
	  "[b.epsiv ]" => "\$\\varepsilon\$",
	  "[b.epsis ]" => "\$\\epsilon\$",
	  "[b.zeta  ]" => "\$\\zeta\$",
	  "[b.eta   ]" => "\$\\eta\$",
	  "[b.thetas]" => "\$\\theta\$",
	  "[b.Theta ]" => "\$\\Theta\$",
	  "[b.thetav]" => "\$\\vartheta\$",
	  "[b.iota  ]" => "\$\\iota\$",
	  "[b.kappa ]" => "\$\\kappa\$",
	  "[b.kappav]" => "[b.kappav]",
	  "[b.lambda]" => "\$\\lambda\$",
	  "[b.Lambda]" => "\$\\Lambda\$",
	  "[b.mu    ]" => "\$\\mu\$",
	  "[b.nu    ]" => "\$\\nu\$",
	  "[b.xi    ]" => "\$\\xi\$",
	  "[b.Xi    ]" => "\$\\Xi\$",
	  "[b.pi    ]" => "\$\\pi\$",
	  "[b.piv   ]" => "\$\\varpi\$",
	  "[b.Pi    ]" => "\$\\Pi\$",
	  "[b.rho   ]" => "\$\\rho\$",
	  "[b.rhov  ]" => "\$\\varrho\$",
	  "[b.sigma ]" => "\$\\sigma\$",
	  "[b.Sigma ]" => "\$\\Sigma\$",
	  "[b.sigmav]" => "\$\\varsigma\$",
	  "[b.tau   ]" => "\$\\tau\$",
	  "[b.upsi  ]" => "\$\\upsilon\$",
	  "[b.Upsi  ]" => "\$\\Upsilon\$",
	  "[b.phis  ]" => "\$\\phi\$",
	  "[b.Phi   ]" => "\$\\Phi\$",
	  "[b.phiv  ]" => "\$\\varphi\$",
	  "[b.chi   ]" => "\$\\chi\$",
	  "[b.psi   ]" => "\$\\psi\$",
	  "[b.Psi   ]" => "\$\\Psi\$",
	  "[b.omega ]" => "\$\\omega\$",
	  "[b.Omega ]" => "\$\\Omega\$",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Ordinary//EN
	  "[ang   ]" => "[ang]",
	  "[angmsd]" => "[angmsd]",
	  "[beth  ]" => "[beth]",
	  "[bprime]" => "[bprime]",
	  "[comp  ]" => "[comp]",
	  "[daleth]" => "[daleth]",
	  "[ell   ]" => "[ell]",
	  "[empty ]" => "[empty]",
	  "[gimel ]" => "[gimel]",
	  "[image ]" => "[image]",
	  "[inodot]" => "[inodot]",
	  "[jnodot]" => "[jnodot]",
	  "[nexist]" => "[nexist]",
	  "[oS    ]" => "[oS]",
	  "[planck]" => "[planck]",
	  "[real  ]" => "[real]",
	  "[sbsol ]" => "[sbsol]",
	  "[vprime]" => "[vprime]",
	  "[weierp]" => "[weierp]",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Binary Operators//EN
	  "[amalg ]" => "[amalg]",
	  "[Barwed]" => "[Barwed]",
	  "[barwed]" => "[barwed]",
	  "[Cap   ]" => "[Cap]",
	  "[Cup   ]" => "[Cup]",
	  "[cuvee ]" => "[cuvee]",
	  "[cuwed ]" => "[cuwed]",
	  "[diam  ]" => "[diam]",
	  "[divonx]" => "[divonx]",
	  "[intcal]" => "[intcal]",
	  "[lthree]" => "[lthree]",
	  "[ltimes]" => "[ltimes]",
	  "[minusb]" => "[minusb]",
	  "[oast  ]" => "[oast]",
	  "[ocir  ]" => "[ocir]",
	  "[odash ]" => "[odash]",
	  "[odot  ]" => "[odot]",
	  "[ominus]" => "[ominus]",
	  "[oplus ]" => "[oplus]",
	  "[osol  ]" => "[osol]",
	  "[otimes]" => "[otimes]",
	  "[plusb ]" => "[plusb]",
	  "[plusdo]" => "[plusdo]",
	  "[rthree]" => "[rthree]",
	  "[rtimes]" => "[rtimes]",
	  "[sdot  ]" => "[sdot]",
	  "[sdotb ]" => "[sdotb]",
	  "[setmn ]" => "[setmn]",
	  "[sqcap ]" => "[sqcap]",
	  "[sqcup ]" => "[sqcup]",
	  "[ssetmn]" => "[ssetmn]",
	  "[sstarf]" => "[sstarf]",
	  "[timesb]" => "[timesb]",
	  "[top   ]" => "[top]",
	  "[uplus ]" => "[uplus]",
	  "[wreath]" => "[wreath]",
	  "[xcirc ]" => "[xcirc]",
	  "[xdtri ]" => "[xdtri]",
	  "[xutri ]" => "[xutri]",
	  "[coprod]" => "[coprod]",
	  "[prod  ]" => "[prod]",
	  "[sum   ]" => "[sum]",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Relations//EN
	  "[ape   ]" => "[ape]",
	  "[asymp ]" => "[asymp]",
	  "[bcong ]" => "[bcong]",
	  "[bepsi ]" => "[bepsi]",
	  "[bowtie]" => "[bowtie]",
	  "[bsim  ]" => "[bsim]",
	  "[bsime ]" => "[bsime]",
	  "[bump  ]" => "[bump]",
	  "[bumpe ]" => "[bumpe]",
	  "[cire  ]" => "[cire]",
	  "[colone]" => "[colone]",
	  "[cuepr ]" => "[cuepr]",
	  "[cuesc ]" => "[cuesc]",
	  "[cupre ]" => "[cupre]",
	  "[dashv ]" => "[dashv]",
	  "[ecir  ]" => "[ecir]",
	  "[ecolon]" => "[ecolon]",
	  "[eDot  ]" => "[eDot]",
	  "[esdot ]" => "[esdot]",
	  "[efDot ]" => "[efDot]",
	  "[egs   ]" => "[egs]",
	  "[els   ]" => "[els]",
	  "[erDot ]" => "[erDot]",
	  "[fork  ]" => "[fork]",
	  "[frown ]" => "[frown]",
	  "[gap   ]" => "[gap]",
	  "[gsdot ]" => "[gsdot]",
	  "[gE    ]" => "[gE]",
	  "[gel   ]" => "[gel]",
	  "[gEl   ]" => "[gEl]",
	  "[ges   ]" => "[ges]",
	  "[Gg    ]" => "[Gg]",
	  "[gl    ]" => "[gl]",
	  "[gsim  ]" => "[gsim]",
	  "[Gt    ]" => "[Gt]",
	  "[lap   ]" => "[lap]",
	  "[ldot  ]" => "[ldot]",
	  "[lE    ]" => "[lE]",
	  "[lEg   ]" => "[lEg]",
	  "[leg   ]" => "[leg]",
	  "[les   ]" => "[les]",
	  "[lg    ]" => "[lg]",
	  "[Ll    ]" => "[Ll]",
	  "[lsim  ]" => "[lsim]",
	  "[Lt    ]" => "[Lt]",
	  "[ltrie ]" => "[ltrie]",
	  "[mid   ]" => "[mid]",
	  "[models]" => "[models]",
	  "[pr    ]" => "[pr]",
	  "[prap  ]" => "[prap]",
	  "[pre   ]" => "[pre]",
	  "[prsim ]" => "[prsim]",
	  "[rtrie ]" => "[rtrie]",
	  "[samalg]" => "[samalg]",
	  "[sc    ]" => "[sc]",
	  "[scap  ]" => "[scap]",
	  "[sccue ]" => "[sccue]",
	  "[sce   ]" => "[sce]",
	  "[scsim ]" => "[scsim]",
	  "[sfrown]" => "[sfrown]",
	  "[smid  ]" => "[smid]",
	  "[smile ]" => "[smile]",
	  "[spar  ]" => "[spar]",
	  "[sqsub ]" => "[sqsub]",
	  "[sqsube]" => "[sqsube]",
	  "[sqsup ]" => "[sqsup]",
	  "[sqsupe]" => "[sqsupe]",
	  "[ssmile]" => "[ssmile]",
	  "[Sub   ]" => "[Sub]",
	  "[subE  ]" => "[subE]",
	  "[Sup   ]" => "[Sup]",
	  "[supE  ]" => "[supE]",
	  "[thkap ]" => "[thkap]",
	  "[thksim]" => "[thksim]",
	  "[trie  ]" => "[trie]",
	  "[twixt ]" => "[twixt]",
	  "[vdash ]" => "[vdash]",
	  "[Vdash ]" => "[Vdash]",
	  "[vDash ]" => "[vDash]",
	  "[veebar]" => "[veebar]",
	  "[vltri ]" => "[vltri]",
	  "[vprop ]" => "[vprop]",
	  "[vrtri ]" => "[vrtri]",
	  "[Vvdash]" => "[Vvdash]",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Negated Relations//EN
	  "[gnap  ]" => "[gnap]",
	  "[gne   ]" => "[gne]",
	  "[gnE   ]" => "[gnE]",
	  "[gnsim ]" => "[gnsim]",
	  "[gvnE  ]" => "[gvnE]",
	  "[lnap  ]" => "[lnap]",
	  "[lnE   ]" => "[lnE]",
	  "[lne   ]" => "[lne]",
	  "[lnsim ]" => "[lnsim]",
	  "[lvnE  ]" => "[lvnE]",
	  "[nap   ]" => "[nap]",
	  "[ncong ]" => "[ncong]",
	  "[nequiv]" => "[nequiv]",
	  "[ngE   ]" => "[ngE]",
	  "[nge   ]" => "[nge]",
	  "[nges  ]" => "[nges]",
	  "[ngt   ]" => "[ngt]",
	  "[nle   ]" => "[nle]",
	  "[nlE   ]" => "[nlE]",
	  "[nles  ]" => "[nles]",
	  "[nlt   ]" => "[nlt]",
	  "[nltri ]" => "[nltri]",
	  "[nltrie]" => "[nltrie]",
	  "[nmid  ]" => "[nmid]",
	  "[npar  ]" => "[npar]",
	  "[npr   ]" => "[npr]",
	  "[npre  ]" => "[npre]",
	  "[nrtri ]" => "[nrtri]",
	  "[nrtrie]" => "[nrtrie]",
	  "[nsc   ]" => "[nsc]",
	  "[nsce  ]" => "[nsce]",
	  "[nsim  ]" => "[nsim]",
	  "[nsime ]" => "[nsime]",
	  "[nsmid ]" => "[nsmid]",
	  "[nspar ]" => "[nspar]",
	  "[nsub  ]" => "[nsub]",
	  "[nsube ]" => "[nsube]",
	  "[nsubE ]" => "[nsubE]",
	  "[nsup  ]" => "[nsup]",
	  "[nsupE ]" => "[nsupE]",
	  "[nsupe ]" => "[nsupe]",
	  "[nvdash]" => "[nvdash]",
	  "[nvDash]" => "[nvDash]",
	  "[nVDash]" => "[nVDash]",
	  "[nVdash]" => "[nVdash]",
	  "[prnap ]" => "[prnap]",
	  "[prnE  ]" => "[prnE]",
	  "[prnsim]" => "[prnsim]",
	  "[scnap ]" => "[scnap]",
	  "[scnE  ]" => "[scnE]",
	  "[scnsim]" => "[scnsim]",
	  "[subne ]" => "[subne]",
	  "[subnE ]" => "[subnE]",
	  "[supne ]" => "[supne]",
	  "[supnE ]" => "[supnE]",
	  "[vsubnE]" => "[vsubnE]",
	  "[vsubne]" => "[vsubne]",
	  "[vsupne]" => "[vsupne]",
	  "[vsupnE]" => "[vsupnE]",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Arrow Relations//EN
	  "[cularr]" => "[cularr]",
	  "[curarr]" => "[curarr]",
	  "[dArr  ]" => "[dArr]",
	  "[darr2 ]" => "[darr2]",
	  "[dharl ]" => "[dharl]",
	  "[dharr ]" => "[dharr]",
	  "[lAarr ]" => "[lAarr]",
	  "[Larr  ]" => "[Larr]",
	  "[larr2 ]" => "[larr2]",
	  "[larrhk]" => "[larrhk]",
	  "[larrlp]" => "[larrlp]",
	  "[larrtl]" => "[larrtl]",
	  "[lhard ]" => "[lhard]",
	  "[lharu ]" => "[lharu]",
	  "[hArr  ]" => "[hArr]",
	  "[harr  ]" => "[harr]",
	  "[lrarr2]" => "[lrarr2]",
	  "[rlarr2]" => "[rlarr2]",
	  "[harrw ]" => "[harrw]",
	  "[rlhar2]" => "[rlhar2]",
	  "[lrhar2]" => "[lrhar2]",
	  "[lsh   ]" => "[lsh]",
	  "[map   ]" => "[map]",
	  "[mumap ]" => "[mumap]",
	  "[nearr ]" => "[nearr]",
	  "[nlArr ]" => "[nlArr]",
	  "[nlarr ]" => "[nlarr]",
	  "[nhArr ]" => "[nhArr]",
	  "[nharr ]" => "[nharr]",
	  "[nrarr ]" => "[nrarr]",
	  "[nrArr ]" => "[nrArr]",
	  "[nwarr ]" => "[nwarr]",
	  "[olarr ]" => "[olarr]",
	  "[orarr ]" => "[orarr]",
	  "[rAarr ]" => "[rAarr]",
	  "[Rarr  ]" => "[Rarr]",
	  "[rarr2 ]" => "[rarr2]",
	  "[rarrhk]" => "[rarrhk]",
	  "[rarrlp]" => "[rarrlp]",
	  "[rarrtl]" => "[rarrtl]",
	  "[rarrw ]" => "[rarrw]",
	  "[rhard ]" => "[rhard]",
	  "[rharu ]" => "[rharu]",
	  "[rsh   ]" => "[rsh]",
	  "[drarr ]" => "[drarr]",
	  "[dlarr ]" => "[dlarr]",
	  "[uArr  ]" => "[uArr]",
	  "[uarr2 ]" => "[uarr2]",
	  "[vArr  ]" => "[vArr]",
	  "[varr  ]" => "[varr]",
	  "[uharl ]" => "[uharl]",
	  "[uharr ]" => "[uharr]",
	  "[xlArr ]" => "[xlArr]",
	  "[xhArr ]" => "[xhArr]",
	  "[xharr ]" => "[xharr]",
	  "[xrArr ]" => "[xrArr]",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Delimiters//EN
	  "[rceil ]" => "[rceil]",
	  "[rfloor]" => "[rfloor]",
	  "[rpargt]" => "[rpargt]",
	  "[urcorn]" => "[urcorn]",
	  "[drcorn]" => "[drcorn]",
	  "[lceil ]" => "[lceil]",
	  "[lfloor]" => "[lfloor]",
	  "[lpargt]" => "[lpargt]",
	  "[ulcorn]" => "[ulcorn]",
	  "[dlcorn]" => "[dlcorn]",

	  );

## ----------------------------------------------------------------------
## don't forget this
1;

## ----------------------------------------------------------------------
