
#include "delo.h"

#define _PARM_LIMIT	32

static	char	*carray[_PARM_LIMIT+2];

char **getconfig(char *config, char *name) {
	char		*t,
			*start,
			*end;
	int		i;

	/* Loop on lines */
	while(*config != 0x0) {

		start=config;

		while(*config != 0xa && *config != 0x0) {
			/* Delete comments */
			if (*config == '#') 
				*config=0x0;
			config++;
		}

		/* Did we stop at the end of a line ? */
		if (*config == 0xa) {
			/* Terminate Line */
			*config=0x0;
			config++;
		}		

		/* Skip leading spaces and tabs */
		while(*start == ' ' || *start == '\t') 
			start++;

		/* If the start of a line is the end - Next line */
		if (*start == 0x0)
			continue;

		/* get the end pointer */
		end=&start[strlen(start)-1];

		/* Delete spaces and tabs at the end of a line */
		while(*end == ' ' || *end == '\t')
			*end--=0x0;

		if (strncasecmp("label=",start,6) == 0) {
			/* If we found the right profile or want the first */
			if (carray[0])
				if ((name[0] == 0x0) ||
					(strcasecmp(carray[0], name) == 0))
					return carray;
			/* Reset image & append */
			carray[1]=carray[2]=0;
			carray[0]=&start[6];
		} else if (strncasecmp("image=",start,6) == 0) {
			carray[1]=&start[6]; 
		} else if (strncasecmp("append=",start,7) == 0) {
			t=&start[7];
			/* Does append start with " */
			if (*t = '"') {
				t++;
				/* If so - append starts +1 */
				carray[2]=t;
				/* Search ending quote */
				while(*t != '"' && *t != 0x0)
					t++;
				/* And delete */
				if (*t == '"') 
					*t=0x0;
			} else 
				carray[2]=&start[7];

			t=carray[2];
			i=3;
			while(i<_PARM_LIMIT && *t != 0x0) {
				t++;
					
				if (*t == ' ' || *t == '\t') {
					*t++=0x0;
					if (*t != 0x0)
						carray[i++]=t;
				}
			}
		}
	}
	if (carray[0])
		if ((name[0] == 0x0) ||
			(strcasecmp(carray[0], name) == 0))
			return carray;

	/* If we found the profile or want the first */

	return(0);
}


