/* drawtimesig.c
 *
 * Function for drawing the time signature
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001 Matthew Hiller
 */

#include "utils.h"		/* Includes <gdk.h> */

void
draw_timesig (GdkPixmap * pixmap, GdkGC * gc, GdkFont * font, gint xx, gint y,
	      gint time1, gint time2)
{
  static GdkFont *timesigfont = NULL;
  static GString *timesigtop;
  static GString *timesigbottom;

  if (!timesigfont)
    {
      timesigfont =
	gdk_fontset_load ("-*-courier-*-r-normal-*-25-*-*-*-*-*-iso8859-*");
      if (!timesigfont)
	timesigfont = font;
      timesigtop = g_string_new (NULL);
      timesigbottom = g_string_new (NULL);
    }
  g_string_sprintf (timesigtop, "%d", time1);
  g_string_sprintf (timesigbottom, "%d", time2);

  gdk_draw_text (pixmap, timesigfont, gc, xx, y + 2 * LINE_SPACE,
		 timesigtop->str, timesigtop->len);
  gdk_draw_text (pixmap, timesigfont, gc, xx, y + 4 * LINE_SPACE,
		 timesigbottom->str, timesigbottom->len);
}
